
//---------------------------------------------------------------------------
//FryeDef definitions file for Fryers32.DLL and FryeCom.DLL
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any later version of Borland Delphi (written using Delphi V3.00)
//---------------------------------------------------------------------------

unit FryeDefs;

interface
uses Windows, Graphics, FryeColors;

const SUCCESS = 0; //my success always = 0
const CANCEL = -1; //my cancel always = -1

const FOREVER = true;

type tByteArray = array[0..1999] of BYTE; //temp byte array type for temp work
type tachar = array[0..1999] of char; //temp char array type for temp pchar work
type Str255 = string[255];
type tpByteArray = ^tByteArray;       //pointer to a byte array
type tpByte = ^BYTE;  //byte pointer

//type unsigned char BYTE;
type INT16 = SmallInt;
//type WORD = unsigned short int;

{$ifndef DWORD}
  type DWORD = longint; //Pascal does not have a unsigned longint,
                      //so we use regular long int and be very careful
{$endif}

type INT32 = longint;

//Pascal does not require these declarations - they are inherient in the compiler syntax
//typedef void (*PROCEDURE)(); //procedure declaration (used by callback and menus)
//typedef int  (*FUNCTION)();  //function declaration (used by sequence)
//typedef int  (*PFUNCTION)(int Parm);  //function declaration with one parameter

const INVALID_DATA16 = -32768;  //Value used to identify data value not used (8000H)
//Note: values that reference INVALID_DATA16 should be declared as INT16
//otherwise wierd compiler screwups can happen when the compiler fails to properly
//promote the INVALID_DATA16 constant.

const sEND = '';             // end string in a string list is a null string

type div_t = packed record
  quot:integer;
  rem:integer;
end;

//==============================================================================

{--$I FryeRegs.INC}  //<-- now located in Fryers.pas

//==============================================================================

const UNKNOWN = 0;
const ENGLISH = 1;
const FRENCH = 2;
const GERMAN = 3;
const SPANISH = 4;
const NUM_LANGUAGE = 5; //number of known languages

//==============================================================================
(*
//See FryeColors for a more extensive list of Frye defined colors.
const ERROR_COLOR = clRed;        //something went wrong
const WARNING_COLOR = clFuchsia;  //Warning message
const NOTICE_COLOR = clYellow;    //Please notice this message
const STATUS_COLOR = clWhite;     //normal process
const ACTION_COLOR = clSilver;    //What's going on
const SUCCESS_COLOR = clLime;     //done
const NO_COLOR = TColor(0);     //don't change the color
*)

const ENABLE = true;
const DISABLE = false;

//==============================================================================
// Curve frame definitions
//==============================================================================
const CURVE_HEADER_SIZE_WORDS = 8; //headers are eight words long
const NUM_PTS_IO_CURVE = 9;        //Num of data pts in IO curve

const NO_DIST_LIST = NIL;         //No distortion list provided
const NUM_PTS_TONE_DIST = 16;      //Num of Tone Normal Distortion values

const NUM_PTS_CRV_FRAME_64 = 64;   //Num of data pts in Curve Frame 0
const NUM_PTS_CRV_FRAME_80 = 80;   //Num of data pts in Curve Frame 1
const NUM_PTS_CRV_FRAME_16 = 16;   //Num of data pts in Curve Frame 2
const NUM_PTS_CRV_FRAME_32 = 32;   //Num of data pts in Curve Frame 3
const MAX_CRV_DATA = 80;           //max possible curve data is 80 points
const MAX_CRV_LIST = (MAX_CRV_DATA+1); //max list size is data size +1
const MAX_AUD_DATA = 14;               //max audiogram data items

//------------------------------------------------------------------------------
//WARNING! *NEVER*EVER* change this structure. It is exported to the real world.
// this structure must be compiled in packed form (one byte resolution)
type tCurveFrame = packed record //standard curve frame definition
  Flags : DWORD;         //flag bits identifying how measurement was done
  TimeStamp : DWORD;     //time stamp for the curve (0=none available)
  Source : INT16;        //source spl used to measure curve data (db*100)
  Peak : INT16;          //peak value in curve frame (db*100)
  Output : INT16;        //overall rms of composite curve, avg of PT curve (db*100)
  NoiseReduction : BYTE; //amount of noise reduction used (0-255)
  Spare : BYTE;          //reserved for future use (should be set to zero)
  Data : array[0..(MAX_CRV_DATA-1)] of INT16; //80 points of data
end; //(88 words total)
type ptCurveFrame = ^tCurveFrame; //pointer to a curveframe type
//Note: the easiest way to tell if a curve frame has valid data is to look
//at the Peak value. If it is INVALID_DATA16, data has never been placed in the
//array since the source will always be either OFF(0) or some valid value.

//------------------------------------------------------------------------------
//WARNING! *NEVER*EVER* change this structure. It is exported to the real world.
//Note it is possible to map the tAudFrame24 on top of the standard tCrvFrame
//using a type cast in order to pass it around, but be very careful if you do
//so that you don't pass it to a routine that will try to access the data points
//beyond the end of the smaller audiogram structure.
type tAudFrame24 = packed record //audiogram curve frame (short 24word version) [CURVE_FRAME_16]
  Flags:DWORD;      //flag bits identifying how measurement was done
  TimeStamp:DWORD;  //time stamp for the curve (0=none available)
  Source:INT16;     //reserved for future use (should be set to INVALID_DATA)
  Peak:INT16;       //peak value in frame section #1 (9-24) (in db*100)
  Average:INT16;    //500/1000/2000 average value
  NoiseReduction:BYTE;//amount of noise reduction used (0-255)
  Spare:BYTE;       //reserved for future use (should be set to zero)
  Data : array[0..13]of INT16;   //14 points of HL data
  Spare4:INT16;
  Spare5:INT16;     //two extra spare words at the end
end;
type ptAudFrame24 = ^tAudFrame24; //pointer to an AudFrame24 type

//audiometric curve frame data locations
const   AF_DATA_125 = 0;
const   AF_DATA_250 = 1;
const   AF_DATA_500 = 2;
const   AF_DATA_750 = 3;
const   AF_DATA_1000 = 4;
const   AF_DATA_1500 = 5;
const   AF_DATA_2000 = 6;
const   AF_DATA_3000 = 7;
const   AF_DATA_4000 = 8;
const   AF_DATA_6000 = 9;
const   AF_DATA_8000 = 10;
const   AF_DATA_10000 = 11;
const   AF_DATA_12000 = 12;
const   AF_DATA_16000 = 13;

const CURVE_FRAME_THIRD_OCT_FLAG   = $00020000; //was ear def flag
const CURVE_FRAME_SMOOTH_FLAG      = $00000020;
const CURVE_FRAME_DISTORTION_FLAGS = $00000006;
const CURVE_FRAME_2ND_HARM_FLAGS   = $00000002;
const CURVE_FRAME_3RD_HARM_FLAGS   = $00000004;
const CURVE_FRAME_TOT_HARM_FLAGS   = $00000006;
const CURVE_FRAME_TYPE_FLAGS       = $00001c00;
const CURVE_FRAME_TYPE_64_FLAGS    = $00000000;
const CURVE_FRAME_TYPE_80_FLAGS    = $00000400;
const CURVE_FRAME_TYPE_16_FLAGS    = $00000800;
const CURVE_FRAME_TYPE_USER_FLAGS  = $00001c00;
const CURVE_FRAME_LEVEL_FLAG   = $00002000;
const CURVE_FRAME_REFMIC_FLAG  = $00000010;
const CURVE_FRAME_MODIFIED     = $00040000;
const CURVE_FRAME_ENV_FLAGS  = $000000c0;
const CURVE_FRAME_TCOIL_FLAG = $00000040;
const CURVE_FRAME_OES_FLAG  = $00010000;
const CURVE_FRAME_CIC_FLAG  = $00800000;
const CURVE_FRAME_COR_FLAGS = $00810000;

const CURVE_FRAME_GAIN_FLAG    = $00004000;

const CURVE_FRAME_WEIGHTING_FLAGS       = $00000300;
const CURVE_FRAME_INPUT_WEIGHTING_FLAG  = $00000100;
const CURVE_FRAME_OUTPUT_WEIGHTING_FLAG = $00000200;
const CURVE_FRAME_FLAT_WEIGHTED_FLAGS   = $00000000;
const CURVE_FRAME_WEIGHTED_POWER_FLAGS  = $00000200;
const CURVE_FRAME_WEIGHTED_GAIN_FLAGS   = $00000300;

const CURVE_TYPE_FLAGS           = $0f000000;
const CURVE_TYPE_UNAIDED_FLAGS   = $01000000;
const CURVE_TYPE_LEVELING_FLAGS  = $05000000;
const CURVE_TYPE_AIDED_FLAGS     = $02000000;
const CURVE_TYPE_INSERTION_FLAGS = $04000000;
const CURVE_TYPE_TARGET_FLAGS    = $08000000;
const CURVE_SUBINFO_FLAGS        = $f0000000;

const CURVE_FRAME_FITRULE_FLAGS = $f0000000;

//--------
const CURVE_FRAME_CRVREF_FLAGS     = $00208000; //crv frame crvref flags mask
const CURVE_FRAME_MEASURED_FLAGS   = $00000000; //part of crvref
const CURVE_FRAME_AVERAGE_FLAGS    = $00200000; //part of crvref
const CURVE_FRAME_DIFFERENCE_FLAGS = $00008000; //part of crvref
const CURVE_FRAME_PREDICTED_FLAGS  = $00208000; //part of crvref
//--------

//The default probe header is used to make curve frames from target and
//other curves like average unaided.   (80pt, gain, leveled, snd field)
const DEFAULT_PROBE_HEADER = $00006480;

//==============================================================================
// Other misc data and structure definitions
//==============================================================================

//-----------------------------------------------------------------------
//Microsoft BMP format
type BmpHeaderType = packed record
       id              : word;
       Filesize        : longint;
       reserved        : longint;
       HeaderSize      : longint;
       InfoSize        : longint;
       Width           : longint;
       Height          : longint;
       biPlanes        : word;
       Bits            : word;
       biCompression   : longint;
       biSizeImage     : longint;
       biXPelsPermeter : longint;
       biYPelsPermeter : longint;
       biClrUsed       : longint;
       biClrImportant  : longint;
     end;
var BmpHeader : BmpHeaderType;

type BmpPaletteType = packed record
       Item : array[0..1] of longint;
     end;


//=================================================================


// The Curve Frame Time Stamp only exists in curve frames
//---------------------------------------------------------------
//               Curve Frame Time Stamp Format
//----------- high word --------- ---------- low word -----------
//F E D C B A 9 8 7 6 5 4 3 2 1 0 F E D C B A 9 8 7 6 5 4 3 2 1 0
//|---------| |-----| |-------| |-------------------------------|
//   Year      Month     Day          Seconds in Day  H*M*S
//   (0-63)     (1-12)   (1-31)              (0-86399)
//   0=1990     1=Jan                   00:00:00 to 23:59:59
//---------------------------------------------------------------

type FD_tCrvTimeStamp = DWORD;    //The packed crv stamp is formated as a Dword


//Frye uses the MSDOS/Windows date/time record for expanded date/time
type FD_tTime = packed record
  Millisecond:WORD;  //set to 0 if not supported
  Second:BYTE; //0-59
  Minute:BYTE; //0-59
  Hour:BYTE;   //0-24 or 1-12
  spare:BYTE;  //spare (is day of week on some clocks)
  Day:BYTE;    //1-31
  Month:BYTE;  //1-12
  Year:WORD;   //1992-9999
end;

//like above but with the time fields removed
type FD_tDate = packed record
  Day:BYTE;    //1-31
  Month:BYTE;  //1-12
  Year:WORD;   //1992-9999
end;


//---------------------------------------------------------------------------
//Frye uses two different calibration date formats. The data packed into
//the Dallas part is the Packed date format shown below. Upon being read, it
//is expanded to the CalDate format shown.
//---------------------------------------------------------------------------
//Frye Packed Date format is a DWORD formated with the following nibbles:
//dd:ee:yyy:m - where "dd"=day(31-24), "ee"=expire(23-16)
//"yyy" = year(bits 15-4), "m"=month(3-0), (year=0->4095)
type FD_tPackedCalDate = DWORD;    //A packed date is formated as a Dword

//Unpacked Frye Cal date structure
type FD_tCalDate = packed record
   Expire:WORD;  //expiration in months from date of calibration
   Year:WORD;    //Year of calibration
   Month:BYTE;   //month of calibration
   Day:BYTE;     //day of calibration
end;

//date string format
const DATE_US = 0;
const DATE_US_SHORT = 1;
const DATE_COMPUTER = 2;

// ID information (from dallas part in instrument) returned by cmd 101
type FD_tDeviceID = packed record
  Family:BYTE;
  Serial : array [0..5] of BYTE;
  Crc:BYTE;
end;

//-----------------------------------------------------------------------------
//Signature is used to provide information about the instrument.
//This information is normally filled in at the time the attached Fonix
//instrument is identified. Not all the fields may be filled in.
//Some instruements may not have the information available.
//Also this is only filled in if you use the UpdateSignature() call
//to collect the information about the instrument (See the FonixSig file.)

//State information - (status of the Instrument Signature record)
const SIG_INVALID = 0; //the signature has not been updated
const SIG_BINARY = 1;  //only the binary values are valid
const SIG_STRING = 2;  //only the strings are valid
const SIG_VALID = 3;   //both the binary values and the strings are valid

const MAX_MICID = 8;   //we can handle up to 8 different Mic IDs

//The following variables are updated by GetFonixVersion() cmd.
//*When in the application mode, InstrumentBaseType, InstrumentSubType,
// InstrumentModel, SoftwareVersion, StdOptions and CstOptions are valid.
//**When in Bootloader mode, only BootVersion is valid.
//----------
//#GetDeviceInfo will fill out the remaining fields where applicable.
//The information is only available when the instrument is in the application
//mode as this information is related to the application software.
//UpdateSignature is normally called once after the instrument has been identified
//with GetFonixVersion(). GetFonixVersion() should be called periodically to detect
//if the instrument has been changed. If a change is detected, UpdateSignature()
//should be called to determine the characteristics of the new instrument that
//was detected.
//--------
//Items marked with "#" are updated by the GetDeviceInfo() call.
//##GetMicID returns the ID of the currently active microphone.
//###GetPrinterLabel will return the currently active Printer label and
//where applicable the currently active UserID.
//The label information is stored in ExtLabel rather than Signature.
//The GetUserId is collected by a call to GetUserIDText from GetDeviceInfo().
//If UserID data is available, it is stored in the Signature record structure.
//UserNumber and MaxUserNumber are also collected by calling GetUserNumber().
//If User selection is not available, these numbers will be zero.
//***For instruments that have a unique identifier (CpuID), CpuID will be
//updated by the GetMachineID().
//Not all instruments will return all the information. It depends on the
//instrument and version of software running on the instrument.
//------------
//Note: InstrumentBaseType, InstrumentSubType, InstrumentModel, SoftwareVersion,
//StdOptions and CstOptions will always be valid for any Fonix instrument when it
//is in application mode and the SIG_UpdateSignature() command is called successfully.
//Other values in this record may or may not be valid depending on the instrument.
type FD_tSignature = packed record
  State:integer;                //0=invalid, 1=binary info valid, 3=all valid
  InstSoftwareMode:integer;     //Mode the instrument is in 0=normal, -1=bootloader
  OptionsState:integer;         //0=unknown, 1=invalid, 2=bootloader, 3=valid application
  StdOptions:DWORD;         //*standard options for this instrument (0=off, 1=on)
  CstOptions:DWORD;         //*custom options for this instrument (0=off, 1=on)
  CpuID:FD_tDeviceID;       //***ID for this instrument
  MicID : array[0..MAX_MICID] of FD_tDeviceID; //##ID for the currently active microphone in the instrument (up to 8 supported)
  MicIDcount:INT16;         //number of Mic IDs available
  InstrumentBaseType:INT16; //*what instrument base type this is  (0=6500, 35=fp35, 7000=7000, etc)
  InstrumentSubType:INT16;  //*additional identification of the instrument
  InstrumentModel:INT16;    //*what instrument model number this is for (0=6500, 35=fp35, 7000=7000, etc)
  SoftwareVersion:INT16;    //*version number of the associated software
  Language:INT16;           //#language the instrument program uses
  NvsVersion:INT16;         //#eerom format version number
  BootVersion:INT16;        //#**Boot loader version
  MfgDate:FD_tCalDate;      //#Mfg date and warranty expiration
  HwCalDate:FD_tCalDate;    //#hardware calibration date and expiration
  SwCalDate:FD_tCalDate;    //#Software calibration date and expiration
  CalibrationStatus:INT16;  //#current calibration status
  SwBuildDate:FD_tCalDate;  //#Software build date
  SwBuildNumber:INT16;      //#Software build number
  UserNumber:INT16;         //###Currently active user number
  MaxUsers:INT16;           //###Max available user numbers.
  SerialNumber : array[0..8] of char;   //#serial number string (eight places plus null tag)
  ModelNumber : array[0..8] of char;    //model number string (eight places plus null tag)
  UserID1: array[0..27] of char;       //###first line of user ID
  UserID2: array[0..27] of char;       //###second line of user ID
end;
var FD_Signature : FD_tSignature;
//InstrumentType verse InstrumentNumber...
//The Instrument type number is the raw type number read via RS232 from the instrument.
//Normally this is the same as the Instrument Number, but because

var FD_CancelOperation:boolean;
var FD_CallBackActive:boolean;

//-----------------------------------------------------------------------
type fc_tEgaPalette = array[0..15] of TColor;
var FC_EgaPalette : fc_tEgaPalette = (
        $00000000,  //0 black
        $00AA0000,  //1  dark blue
        $0000AA00,  //2  dark greem
        $00AAAA00,  //3  dark cyan
        $000000AA,    //4 dark red
        $00AA00AA,    //5 dark magenta
        $000055AA,    //6 brown
        $00AAAAAA,    //7 gray
        $00555555,   //8   silver
        $00FF5555,   //9   blue
        $0055FF55,   //10 green
        $00FFFF55,   //11 cyan
        $005555FF,    //12 red
        $00FF55FF,    //13 magenta
        $0055ffff,   //14 yellow
        $00ffffff   //15 white
      );


//-----------------------------------------------------------------------
//Info to determine which DLL we are using
const FD_NO_DLL_LOADED = 0;
const FD_FRYERS32_LOADED = 1;
const FD_FRYECOM_LOADED = 2;
var FD_WhichDll : integer = 0;  //0=none, 1=fryers32, 2=fryecom

//-----------------------------------------------------------
const FD_ErrorFilename:Str255 = ''; //used by error handler to pick up last referenced filename

const FD_NoCalDate : FD_tCalDate = (Expire:0; Year:0; Month:0; Day:0);   //Default No Calibration date
const FD_NoPackedDate : FD_tPackedCalDate = 0;  //Default No packed cal date

//special case ID values
const FD_Cal_Jig_ID : FD_tDeviceID   =
      (Family:0; Serial:(0,0,0,0,0,0); Crc:0); //calibrator jig ID
const FD_No_Device_ID : FD_tDeviceID =
      (Family:0; Serial:(0,0,0,0,0,0); Crc:1); //no attached ID device found
const FD_Bad_Device_ID : FD_tDeviceID =
      (Family:0; Serial:(0,0,0,0,0,0) ;Crc:2); //bad ID read
const FD_Unknown_Device_ID : FD_tDeviceID =
      (Family:0; Serial:(0,0,0,0,0,0); Crc:3); //device ID not read yet
const FD_6500_Device_ID : FD_tDeviceID =
      (Family:0; Serial:(0,0,0,0,0,0); Crc:$65); //fake device ID for 6500
const FD_FP40_Device_ID : FD_tDeviceID =
      (Family:0; Serial:(0,0,0,0,0,0); Crc:$40); //fake device ID for FP40

//non-library versions of memory copy/fill.
procedure FD_ByteCopy(var Dest; var Src; Size:integer);
procedure FD_WordCopy(var Dest; var Src; Size:integer);
procedure FD_ByteFill(var Dest; Data:BYTE; Size:integer);
procedure FD_WordFill(var Dest : array of WORD; Data:WORD; Size:integer);
procedure FD_LongFill(var Dest : array of DWORD; Data:DWORD; Size:integer);

function FD_div(Num:integer; Divisor:integer):div_t;


implementation


//=====================================================================
//A note about building forms.
//Windows has a habit of setting the form to what it thinks
//the size should be at start up when set to fsNormal and the
//borders are set to be resizable.
//Unfortunately it likes to build the form too small and puts scroll bars on
//it if you use large fonts. To "fix" this, put a bevel on the form.
//Set the top left corner to (0,0) and then set the left and bottom edges
//of the bevel to where you want the left and bottom edges of the form to be
//created at. Then in FormCreate place the following code:
//  Form1->ClientWidth = MasterBevel->Width;
//  Form1->ClientHeight = MasterBevel->Height;
// If you have a status panel or text attached to the bottom of the form,
// change the second line to this:
//  Form1->ClientHeight = MasterBevel->Height + StatusPanel->Height;
//This will cause the form to be resized to where youu want it to be.
//Do this to all forms that you create (if you want them to be created
//the way you want them to be created). The user can still resize the form
//if they wish. The above just sets the form size at the time it is created.
//Note: you can hide the bevel if you wish to get rid of the visual edge it
//creates (MasterBevel->Visible = false;).
//======================================================================
//Another trick is to place the form where the user last left it.
//Windows will either place the form at a random location, or at the designed
//location depending on how you set it up. The user though normally prefers it
//to be at a particular location. You can track this by saving the window
//information in the registry
//on FormCloseQuery() add the following code:
//  MainTop = Form1->Top;
//  MainLeft = Form1->Left;
//  REG_Value(WRITE_REGISTRY_INTEGER,&MainTop,aPrgKey,"WINDOW_POSITION_TOP");
//  REG_Value(WRITE_REGISTRY_INTEGER,&MainLeft,aPrgKey,"WINDOW_POSITION_LEFT");
//Where "aPrgKey" is the keyname for the program in the registry.
//Then in the FormCreate() routine add the following code:
//  MainTop = 1;
//  MainLeft = 1;
//  REG_Value(READ_REGISTRY_INTEGER,&MainTop,aPrgKey,"WINDOW_POSITION_TOP");
//  REG_Value(READ_REGISTRY_INTEGER,&MainLeft,aPrgKey,"WINDOW_POSITION_LEFT");
//  if ((MainTop < 1)||(MainTop > Form1->Height)) MainTop = 1;
//  if ((MainLeft < 1)||(MainLeft > Form1->Width)) MainLeft = 1;
//  Form1->Top = MainTop;
//  Form1->Left = MainLeft;
//This will cause the form to be placed back on the screen where the user
//left it when it was closed. It will also check to verify that the form is
//still on the screen and will move it if it is not. No more lost forms when
//they change screen resolution.
//=======================================================================

//---------------------------------------------------------------------------
//copy src to dest for size in bytes.
//if either pointer is null, do nothing.
procedure FD_ByteCopy(var Dest; var Src; Size:integer);
begin
  Move(Src,Dest,Size);
end;

//---------------------------------------------------------------------------
//copy src to dest for size in words.
//if either pointer is null, do nothing.
procedure FD_WordCopy(var Dest; var Src; Size:integer);
begin
  Move(Src,Dest,Size*2);
end;

//---------------------------------------------------------------------------
//Fill Dest with Data BYTE for size in BYTEs.
procedure FD_ByteFill(var Dest; Data:BYTE; Size:integer);
begin
  FillChar(Dest,Size,Data);
end;

//Fill Dest with Data WORD for size in WORDs.
procedure FD_WordFill(var Dest : array of WORD; Data:WORD; Size:integer);
var i:integer;
begin
  for i:=0 to (Size-1) do
  begin
    Dest[i] := Data;
  end;
end;

//Fill Dest with Data DWORD for size in DWORDs.
procedure FD_LongFill(var Dest : array of DWORD; Data:DWORD; Size:integer);
var i :integer;
begin
  for i:=0 to (Size-1) do
  begin
    Dest[i] := Data;
  end;
end;

//emulate the special C division function
function FD_div(Num:integer; Divisor:integer):div_t;
begin
  Result.quot := Num div Divisor;
  Result.rem := Num mod Divisor;
end;



end.
