//FryeStr special strings interface unit
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//----------------------------------------------------

#include <ctype.h>
#include <stdlib.h>
#include "FryeDefs.h"
#include "FryeStr.h"

//---------------------------------------------------------------------------

char FS_sBLANK[] = sEND;      //blank string def (a string with just a zero in it)
char FS_sBlank[]  = "      "; //no message
char FS_sFailed[] = "FAILED ";
char FS_sUnknown[] = "UNKNOWN ";
char FS_sNoMic[]  = "NO MICROPHONE";
char FS_sCalibrationCable[] = "CALIBRATION";
char FS_cHex[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

char fs_sDStr[1999];   //temp global string used to build date string
char fs_sString[1999];

//---------------------------------------------------------------------------
char* FS_ByteToHex(int Value, char * HexStr) {
  HexStr[0] = FS_cHex[(Value >> 4) & 0x0f];
  HexStr[1] = FS_cHex[(Value >> 0) & 0x0f];
  HexStr[2] = 0;
  return(HexStr);
};

//---------------------------------------------------------------------------
char* FS_WordToHex(int Value, char * HexStr) {
  HexStr[0] = FS_cHex[(Value >> 12) & 0x0f];
  HexStr[1] = FS_cHex[(Value >> 8) & 0x0f];
  HexStr[2] = FS_cHex[(Value >> 4) & 0x0f];
  HexStr[3] = FS_cHex[(Value >> 0) & 0x0f];
  HexStr[4] = 0;
  return(HexStr);
};

//---------------------------------------------------------------------------
char* FS_DwordToHex(DWORD Value, char* HexStr) {
  FS_WordToHex((WORD)((Value >> 16) & 0x0ffff),&HexStr[0]);
  FS_WordToHex((WORD)(Value & 0x0ffff),&HexStr[4]);
  return(HexStr);
};


//---------------------------------------------------------------------------
//returns -1 if bad hex char, or +n if ok.
int FS_HexToDecimal(char HexDigit) {
  if (HexDigit < '0') return(-1);
  if (HexDigit <= '9') return(HexDigit - '0');
  HexDigit &= 0x5f;
  if (HexDigit < 'A') return(-1);
  if (HexDigit <= 'F') return(HexDigit - 'A' + 10);
  return(-1);
};

//---------------------------------------------------------------------------
long double FS_HexToNumber(char* HexStr) {
  int i;
  int Number;
  int Error = 0;
  long double factor = 1.0;
  long double total = 0.0;
  for (i=FS_SLen(HexStr)-1; i>=0; i--) {
    if (HexStr[i] >= '0') {
      Number = FS_HexToDecimal(HexStr[i]);
      if (Number >= 0) {
        total += (Number * factor);
        factor *= 16;
      }else{
        Error++;
      }
    }
  }
  if (Error > 0)
    return(-1.0);
  else return(total);
};

//---------------------------------------------------------------------------
//generic hex to value conversion - used by HexToByte,HexToWord,HexToDword
//converts hex string in HexStr to a DWORD. If a bad hex value is given,
//that position is filled by the Default value.
//If not enough characters given, returns -1 and the value is zero.
//if bad hex char found, returns +n, and the determined number is returned.
//if all ok, returns a zero.
int FS_HexToValue(WORD Size, char* HexStr, DWORD* Value, DWORD Default) {
  int i;
  int Number;
  int factor = 1;
  int total = 0;
  int Error = 0;
  *Value = 0;
  if ((int)FS_SLen(HexStr) < (int)Size) return(-1);
  for (i=Size-1; i>=0; i--) {
    Number = FS_HexToDecimal(HexStr[i]);
    if (Number >= 0)
      total += (Number * factor);
    else{
      total += Default;
      Error++;
    }
    factor *= 16;
  }
  *Value = total;
  return(Error);
};

//---------------------------------------------------------------------------
//converts hex string in HexStr to a BYTE.
//returns zero result if successful
int FS_HexToByte(char* HexStr, BYTE* Value, BYTE Default) {
  DWORD Number;
  int Error = FS_HexToValue(2,HexStr,&Number,Default);
  *Value = (BYTE)Number;
  return(Error);
};

//---------------------------------------------------------------------------
//converts hex string in HexStr to a WORD.
//returns zero result if successful
int FS_HexToWord(char* HexStr, WORD* Value, WORD Default) {
  DWORD Number;
  int Error = FS_HexToValue(4,HexStr,&Number,Default);
  *Value = (WORD)Number;
  return(Error);
};

//---------------------------------------------------------------------------
//converts hex string in HexStr to a DWORD. If a bad hex value is given,
//that position is filled by the Default value.
//If not enough characters given, returns -1 and the value is zero.
//if bad hex char found, returns +n, and the determined number is returned.
//if all ok, returns a zero.
int FS_HexToDword(char* HexStr, DWORD* Value, DWORD Default) {
  return(FS_HexToValue(8,HexStr,Value,Default));
};

//---------------------------------------------------------------------------
//converts hex string in HexStr to binary. If a bad hex value is given,
//that position is filled by the Default value.
//If not enough characters given, returns -1 and the data is not changed.
//Returns the number of errors encountered (0=all ok).
//Note: Count is the number of returned bytes, not the number of hex chars.
//If Count +n, the hex string length must match or be greater than the count
//If Count -n, the hex string result will be zero filled to the left if
//not enough data in HexStr to produce n bytes of data.
//If Count 0, no data is returned.
//Note: There must always be two hex nibbles per byte
//any odd count hex characters at the end (right) are discarded
int FS_HexToBinary(int Count, char* HexStr, BYTE* Data, BYTE Default) {
  BYTE Number;
  int i;
  int Result;
  int HexIndex;
  int Error = 0;
  if ((Count <= 0)||(HexStr == NULL)||(Data==NULL)) return(0); //if count = 0 do nothing
  i = 0;
  while(Count > 0) {
    HexIndex = (Count-1)*2;
    Result = FS_HexToByte(&HexStr[HexIndex],&Number,0);
    if (Result == 0) {
      Data[i++] = Number;
    }else{
      Data[i++] = Default;
      Error++;
    }
    Count--;
  }
  return(Error);
};

//---------------------------------------------------------------------------
//converts hex string in HexStr to a byte array. If a bad hex value is given,
//that position is filled by the Default value.
//If not enough characters given, returns -1 and the data is not changed.
//Returns the number of errors encountered (0=all ok).
//Note: Count is the number of returned bytes, not the number of hex chars.
//If Count 0, no data is returned.
//Note: There must always be two hex nibbles per byte
//any odd count hex characters at the end (right) are discarded
int FS_HexToByteArray(int Count, char* HexStr, BYTE* Data, BYTE Default) {
  BYTE Number;
  int i;
  int Result;
  int HexIndex;
  int Error = 0;
  if ((Count <= 0)||(HexStr == NULL)||(Data==NULL)) return(0); //if count = 0 do nothing
  i = 0;
  while(Count > 0) {
    HexIndex = i*2;
    Result = FS_HexToByte(&HexStr[HexIndex],&Number,0);
    if (Result == 0) {
      Data[i++] = Number;
    }else{
      Data[i++] = Default;
      Error++;
    }
    Count--;
  }
  return(Error);
};

/*
//If Count +n, the hex string length must match or be greater than the count
//If Count -n, the hex string result will be zero filled to the left if
//not enough data in HexStr to produce n bytes of data.
//If Count 0, no data is returned.
int STR_HexToByteArray(char* HexStr, BYTE* Data, BYTE Default) {
  BYTE Number;
  int i;
  int Size;
  int Result;
  int HexIndex;
  int Error = 0;
  if ((Count == 0)||(HexStr == NULL)||(Data==NULL)) return(0); //if count = 0 do nothing
  Size = strlen(HexStr) / 2;
  if ((Count > 0)&&(Count != Size)) return(-1);
  if (Count < 0) Count = (0 - Count);
  i = 0;
  Count -= Size;
  while(Size > 0) {
    HexIndex = (Size-1)*2;
    Result = HexToByte(&HexStr[HexIndex],&Number,0);
    if (Result == 0) {
      Data[i++] = Number;
    }else{
      Data[i++] = Default;
      Error++;
    }
    Size--;
  }
  while(Count > 0) {
    Data[i++] = 0;
    Count--;
  }
  return(Error);
};
*/

//---------------------------------------------------------------------------
//converts binary data of Size bytes to hex string in HexStr.
//If HexStr is null or count = 0 returns -1, else returns 0
//Assumes that highest byte is to be placed on the left (lowest hex char)
int FS_BinaryToHex(int Size, BYTE* Data, char* HexStr) {
  int i,j;
  if (HexStr == NULL) return(-1);
  HexStr[0] = 0;
  if (Size == 0) return(0);
  if (Size < 0) return(-1);
  j = 0;
  for (i = Size - 1; i >= 0; i--) {
    HexStr[j++] = FS_cHex[(Data[i] >> 4) &0x0f];
    HexStr[j++] = FS_cHex[Data[i] &0x0f];
  }
  HexStr[j] = 0;
  return(0);
};

//---------------------------------------------------------------------------
//null protected string length
//Find a null byte in string pointed at by Data
//Returns index in array where the null was found
//Also returns zero if Data pointer is nil
int FS_SLen(char* Data) {
  int i = 0;
  if (Data == NULL) return(0);
  while(Data[i] != 0) i++;
  return(i);
};

//---------------------------------------------------------------------------
//null protected strcpy
//copy src to dest until null encountered.
//if either pointer is null, do nothing.
//Assumes enough space in dest is avail for copy.
//Returns destination pointer.
char* FS_SCopy(char* Dest, char* Src) {
  BYTE* Dst = (BYTE*)Dest;
  BYTE* Sr = (BYTE*)Src;
  if ((Sr != 0)&&(Dst!=0)) {
    while(FOREVER) {
      *Dst = *Sr;
      if (*Sr == 0) break;
      Dst++;
      Sr++;
    }
  }
  return((char*)Dest);
};


//---------------------------------------------------------------------------
//null protected strcat
//concatinate src to end of dest string until null in src encountered.
//if either pointer is null, do nothing. Assumes that enough space for
//copy to dest is avail. Returns destination pointer.
char* FS_SCat(char* Dest, char* Src) {
  BYTE* Dst = (BYTE*)Dest;
  BYTE* Sr = (BYTE*)Src;
  if ((Sr != 0)&&(Dst!=0)) {
    while(*Dst != 0) Dst++;
    while(FOREVER) {
      *Dst = *Sr;
      if (*Sr == 0) break;
      Dst++;
      Sr++;
    }
  }
  return((char*)Dest);
};


//---------------------------------------------------------------------------
//copies three strings ito a desitination string.
//returns a pointer to the destination string.
//If a string is null, it is not included.
//Note: Make sure Dest is big enough to hold all the strings
char* FS_SCopy3(char* Dest, char* Str1, char* Str2, char* Str3) {
  FS_SCopy(Dest,Str1);
  FS_SCat(Dest,Str2);
  FS_SCat(Dest,Str3);
  return(Dest);
};

//---------------------------------------------------------------------------
//List StrCopy3 above, but concatinates to the end of an existing string
char* FS_SCat3(char* Dest, char* Str1, char* Str2, char* Str3) {
  FS_SCat(Dest,Str1);
  FS_SCat(Dest,Str2);
  FS_SCat(Dest,Str3);
  return(Dest);
};

//{-----------------------------------------------------------------}
// Return a rounded integer "Num" as a fixed point number string.
// D specifies how many decimal points to return 0=none, 1=1.1, 2=2.22}
// String is returned in S. The number in the string is right justified (left spaces)
// L specifies string S total length. If L<0, string is left justified (right spaces)
// If L=0 the exact length string is returned.
// Number passed is presumed to be Fn*100 (100x fixed point decimal number)
// Note: if the resulting string length is greater than L, the returned
// string will be longer than L. Make sure enough space has been allocated.
// If a Tag string is provided, it will be added to the end of the result.
char* FS_Rnum(int Num, int D, int L, char* S, char* Tag) {
  int k,j,r;
  div_t n;
  char Sq[999];
  int z = L;
  if (z<0) z=0-z;   //get target length to z
  if (S==0) {S=fs_sString; S[0] = 0;} //if no string provided, use our own
  if (D < 0) D = 0;
  if (D > 2) D = 2;
  if (D==0) {
    n = div(Num,100);
    if (n.rem <= -50) {n.quot--;} else if (n.rem >= 50) {n.quot++;} //round it
    itoa(n.quot,Sq,10);  //if Num < 0 then v := Num+5-50 else v := Num+50;
    k = FS_SLen(Sq);     //find string length
  }else if (D==1) {
    n = div(Num,10);   //pre-divide for rounding
    r = n.quot;
    if (n.rem <= -5) {r--;} else if (n.rem >= 5) {r++;} //round it
    n = div(r,10);  //finish the divide
    if (r < 0) {Sq[0] = '-'; itoa(abs(n.quot),&Sq[1],10); }
      else itoa(n.quot,Sq,10);         //if i < 0 then v := i-5 else v := i+5;
    k = FS_SLen(Sq);     //find string length
    Sq[k] = '.'; k++;
    itoa(abs(n.rem),&Sq[k],10);     //fraction portion is always len=2 (0'.0')
    k++;
  }else{ // D>=2
    n = div(Num,100);
    r = abs(n.rem);
    if (Num < 0) {Sq[0] = '-'; itoa(abs(n.quot),&Sq[1],10); }
      else itoa(n.quot,Sq,10);         //if i < 0 then v := i-5 else v := i+5;
    k = FS_SLen(Sq);     //find string length
    Sq[k] = '.'; k++;    //fraction portion is always len=3 (0'.00')
    if (r > 9) { itoa(r,&Sq[k],10); k +=2; }
      else { Sq[k] = '0'; k++; itoa(r,&Sq[k],10); k++; Sq[k] = 0; };
  } //k now points at the null at the end of the number string
  if (k > z) z=k;  //if max length < this len, force max length to this length
  j = 0;
  if (L>0) {FD_ByteFill(&S[j],' ',z-k); j += z-k; } //right adj string if L=pos
  FS_SCopy(&S[j],&Sq[0]); j += k;         //cat number string to the result
  if (L<0) {FD_ByteFill(&S[j],' ',z-k); S[z] = 0;} //Left adj string if L neg
  if (Tag != NULL) FS_SCat(&S[z],Tag);    //cat tag
  return(S);
};

//{-----------------------------------------------------------------}
// Return an integer "Num" as a number string.
// String is returned in S. The number in the string is right justified (left spaces)
// L specifies string S total length. If L<0, string is left justified (right spaces)
// If L=0 the exact length string is returned.
// Number passed is presumed to be a whole decimal number (N*1)
// Note: if the resulting string length is greater than L, the returned
// string will be longer than L. Make sure enough space has been allocated.
// If a Tag string is provided, it will be added to the end of the result.
char* FS_Inum(int Num, int L, char* S, char* Tag) {
  int j,k;
  char Sq[999];
  int z = L;
  if (z<0) z=0-z;   //get target length to z
  if (S==0) {S=fs_sString; S[0] = 0;} //if no string provided, use our own
  itoa(Num,Sq,10);  //if Num < 0 then v := Num+5-50 else v := Num+50;
  k = FS_SLen(Sq);     //find string length
  if (k > z) z=k;  //if max length < this len, force max length to this length
  j = 0;
  if (L>0) {FD_ByteFill(&S[j],' ',z-k); j += z-k; } //right adj?
  FS_SCopy(&S[j],&Sq[0]); j += k;                   //copy number
  if (L<0) {FD_ByteFill(&S[j],' ',z-k); S[z] = 0;}  //left adj?
  if (Tag != NULL) FS_SCat(&S[z],Tag);              //cat tag
  return(S);
};

//{-----------------------------------------------------------------}
//Short version of Inum. No tags, just convert the number.
char* FS_IntToStr(int Num, char* S) {
  FS_Inum(Num,0,S,NULL);
  return(S);
};

//{-----------------------------------------------------------------}
// Return an integer "Num" as a number string.
// String is returned in S. The number in the string is right justified (left spaces)
// L specifies string S total length. If L<0 zeros are padded in front.
// if L>0, spaces are padded in front. If L==0 nothing is added.
// Number passed is presumed to be a whole decimal number (N*1)
// Note: if the resulting string length is greater than L, the returned
// string will be longer than L. Make sure enough space has been allocated.
// **NOTE** If S is provided with a string, it will be added to the front
// of the result. If a Tag string is provided, it will be added to the
// end of the result. *CHANGE* The prestring feature is disabled due to
// too many problems with its use (garbage strings because they were not preinitialized
char* FS_Znum(int Num, int L, char* S, char* Tag) {
  int j,k;
  char Sq[999];
  int z = L;
  if (z<0) z=0-z;   //get target length to z
  if (S==0) {S=fs_sString; S[0] = 0;}  //if no string provided, use our own
  itoa(Num,Sq,10);  //if Num < 0 then v := Num+5-50 else v := Num+50;
  k = FS_SLen(Sq);     //find number string length (result in k)
  if (k > z) z=k; //z=max string length (less pre and post tags)
  j = 0; //STR_SLen(S);  //find pre string length
  if (L>0) {FD_ByteFill(&S[j],' ',z-k); j += z-k; } //lead spaces if any
  if (L<0) {FD_ByteFill(&S[j],'0',z-k); j += z-k; } //lead zeros if any
  FS_SCopy(&S[j],&Sq[0]); //j += k;  //cat number string to result
  if (Tag != NULL) FS_SCat(&S[z],Tag);  //cat tag if any
  return(S);
};

//------------------------------------------------------------------------------
//Converts a string to a decimal number. Leading spaces/ctrls are stripped
//Number is converted until no more numeric text found.
//If the number is too large, it will overflow.
//If nothing found, returns false, else returns true
bool FS_StringToInt(char* S, int* Value) {
  int i;
  int Size;
  bool Valid = false;
  if (Value == NULL) return(false);
  *Value = 0;
  if (S == NULL) return(false);
  Size = FS_SLen(S);
  for (i=0; i<Size; i++) {
    if (S[i] == 0) break;
    if (S[i] > '9') break;
    if (S[i] >= '0') {
      *Value = (*Value * 10) + (S[i] & 0x0f);
      Valid = true;
    }//endif(S)
  }//endfor(i)
  return(Valid);
};

//------------------------------------------------------------------------------
//Just like StringToInt, but returns a 16 bit int.
bool FS_StringToInt16(char* S, INT16* Value) {
  int Number;
  bool Result = FS_StringToInt(S,&Number);
  *Value = (INT16)Number;
  return(Result);
};

//------------------------------------------------------------------------------
// Return a justified string.
//   String is returned in sOutput.
//   L specifies string sOutput total length.
//   If L>0 the text in the string is right justified (spaces added to the left)
//   If L<0, string is left justified (spaces added to the right)
//   If L=0 the exact length string is returned.
//
// Note: if the resulting string length is greater than L, the returned
// string will be longer than L. Make sure enough space has been allocated.
//------------------------------------------------------------------------------
char* FS_Justify( char* sOutput, char* sInput, int L) {
  int j,k;
  int z = L;
  if (z<0) z=0-z;   //get target length to z
  if (sOutput==0) {sOutput=fs_sString; sOutput[0] = 0;}  //if no string provided, use our own
  if (sInput == NULL) {
    sOutput[0] = 0;  //if no inout string, return empty string
    return(sOutput);
  }
  k = FS_SLen(sInput);     //find input string length (result in k)
  if (k > z) z=k;  //if max length < this len, force max length to this length
  j = 0;
  // Right justify string by adding spaces to left of string
  if (L>0) {FD_ByteFill(&sOutput[j],' ',z-k); j += z-k; } //right adj?
  FS_SCopy(&sOutput[j],&sInput[0]); j += k;  //copy the input string
  if (L<0) {FD_ByteFill(&sOutput[j],' ',z-k); } //left adj?
  sOutput[z] = 0;  //tag string with a null
  return(sOutput);
};

//---------------------------------------------------------------------------
//Trim leading zeros from a string
char* FS_TrimLeadingZeros(char* pStr) {
  int i,j;
  if (pStr == NULL) return(pStr);
  i = 0;   //look for leading zeros
  while( (pStr[i] == '0') && (pStr[i] != 0) ) i++;
  j = 0;  //copy string without leading zeros
  while(pStr[i] != 0)
    pStr[j++] = pStr[i++];
  pStr[j] = 0;
  return(pStr);
};

//---------------------------------------------------------------------------
//Trim leading spaces from a string (in-place strip)
char* FS_TrimLeadingSpaces(char* pStr) {
  int i,j;
  if (pStr == NULL) return(pStr);
  i = 0;   //look for leading zeros
  while( (pStr[i] == ' ') && (pStr[i] != 0) ) i++;
  j = 0;  //copy string without leading spaces
  while(pStr[i] != 0)
    pStr[j++] = pStr[i++];
  pStr[j] = 0;
  return(pStr);
};

//---------------------------------------------------------------------------
//trim trailing spaces and control chars from a string passed in Src
//Returns new string in Dest.
//Note: Dest array must be at least as big as Src array
char* FS_TrimTrailingSpaces(char* Dest, char* Src) {
  int i;
  if (Dest==0) {Dest=fs_sString; Dest[0] = 0;}
  i = FS_SLen(Src);
  Dest[0] = 0;
  if (i == 0) return(Dest);
  while((i >= 0) && (Src[i] <= ' ')) {i--;}
  Dest[i+1] = 0;
  while(i >= 0) {
    Dest[i] = Src[i];
    i--;
  }
  return(Dest);
};

//---------------------------------------------------------------------------
//tag string with fill char to fill string to Size
//Note: Dest array must be at least as big as Src array plus count
char* FS_TagFill(char* Dest, char* Src, char FillChar, int Size) {
  int i = 0;
  if (Dest==0) {Dest=fs_sString; Dest[0] = 0;}
  if (Src==0) return(Dest);
  while(Src[i] != 0) {
    Dest[i] = Src[i];
    i++;
  };
  while (i<Size) {
    Dest[i] = FillChar;
    i++;
  }
  Dest[i] = 0;
  return(Dest);
};

//---------------------------------------------------------------------------
//This splits a sub string out of the provided str starting at location Start
//until either the separator character is found, or the end of the string is found.
//returns a result of where the next search will start (separator+1).
//if Str is empty, or attempt to read past end of string, returns
//SubStr empty, and returned Location is set to end of the string.
int FS_ExtractString(char* Str, int Loc, char Separator, char* SubStr) {
  int i = 0;
  if (SubStr == NULL) return(0);
  SubStr[0] = 0;
  if (Str == NULL) return(0);
  while(true) {
    SubStr[i] = Str[Loc];
    if (Str[Loc] == 0) return(Loc);
    if (Str[Loc] == Separator) {
      SubStr[i] = 0;
      return(Loc+1);
    }
    Loc++;
    i++;
  }//endwhile
};

//---------------------------------------------------------------------------
//strip a substring from Src and place it into Dest.
//starts at Start location in Src string and copies Count characters
//returns actual size of the returned string
int FS_SubStr(char* Src, char* Dest, int Start, int Count) {
  int Size;
  if (Dest == NULL) return(0);
  Dest[0] = 0;
  if (Src == NULL) return(0);
  Size = FS_SLen(Src);
  if (Size < Start) return(0);
  if (Size < (Start+Count)) Count = Size - Start;
  FD_ByteCopy(Dest,&Src[Start],Count);
  Dest[Count] = 0;
  return(Count);
};

//-----------------------------------------------------------------------
//Convert Mic Cal date to a display string. rets null str if date not valid
// How = DATE_NORMAL (dd-mm-yy), DATE_SHORT (dd-mm-yy)
// DATE_COMPUTER (yyyy-mm-dd)
// If S is provided, it will be used to return the data.
// If data is provided in S, it will be left in front of the time string.
// Assumes DS_ReadMicCalibration() was called previously to update mic cal date.
//---------------------------------------------------------------------------
char* FS_DateStr(FD_tCalDate* Date, char* S, int How) {
  char* ts = S;
  char st[999] = "/\0";
  if (S == 0) { ts = &fs_sDStr[0]; ts[0] = 0; }
  if ((Date->Year == 0)||(Date->Month == 0)||(Date->Day == 0)) return(ts);
  if (How == DATE_COMPUTER) {
    FS_Znum(Date->Year,4,ts,st);
    FS_Znum(Date->Month,-2,ts,st);
    FS_Znum(Date->Day,-2,ts,0);
  }else{
    if (How == DATE_US_SHORT)
      FS_Znum(Date->Year%100,-2,ts,st);
    else FS_Znum(Date->Year,4,ts,st);
    FS_Znum(Date->Month,-2,ts,st);
    st[1] = ' ';
    FS_Znum(Date->Day,-2,ts,0);
  }
  return(ts);
};

//---------------------------------------------------------------------------
//Convert six byte serial number to ascii Hex
char* FS_HexID(BYTE* Serial, int x, char* S) {
  int N;
  char* pS;
  int i = 0;
  if (S==0) {pS=fs_sString; pS[0]=0;} else {pS=S;}
  if (x > 0) { pS[i] = '0'; i++; pS[i++] = 'x'; i++; };
  N = (Serial[5]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = Serial[5] & 0xF;      if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = (Serial[4]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = Serial[4] & 0xF;      if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = (Serial[3]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = Serial[3] & 0xF;      if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = (Serial[2]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = Serial[2] & 0xF;      if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = (Serial[1]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = Serial[1] & 0xF;      if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  N = (Serial[0]>>4) & 0xF; if((N>0)||(x>=0)||(i>0)) {pS[i] = FS_cHex[N]; i++;}
  pS[i] = FS_cHex[Serial[0] & 0xF]; i++;
  pS[i] = 0;
  return(pS);
};

//-------------------------------------------------------------------
// If S is provided, it will be used to return the data.
// If data is provided in S, it will be left in front of the string.
// Assumes DS_ReadMicCalibration() was called previously to update mic cal date.
char* FS_FileSizeStr(DWORD RawSize, int L, char* S) {
  char* pS;
  if (S==0) {pS=fs_sString; pS[0] = 0;} else {pS=S;}
  if (RawSize < 10000) {
   itoa(RawSize,pS,10);
   }else if (RawSize < (1024*999)) {
     itoa(RawSize / 1024,pS,10);
     FS_SCat(pS,"K");
     //pS[length(Size)+1] := 'K';
   }else{
     itoa(RawSize / (1000*1024), pS, 10);
     FS_SCat(pS,"M");
     //Size[length(Size)+1] := 'M';
   }
//   while length(Size) < 4 do
//     Size := ' '+Size;
  return(pS);
};


//-------------------------------------------------------------------
//Convert lower case string to upper case.
//If sDest is NULL, converts sSrc string in place.
//If sDest is not null, places new upper case string in sDest.
char* FS_Upper(char* sSrc, char* sDest) {
  char* pS;
  int i = 0;

  if (sSrc == NULL) return(NULL);
  if (sDest==0) {pS=sSrc;} else {pS=sDest;}
  while (sSrc[i] != 0) {
    pS[i] = (char)toupper(sSrc[i]);
    i++;
  };
  pS[i] = 0;
  return(pS);
};

//---------------------------------------------------------------------------
//convert device ID number to hex string
void FS_GetDeviceIDString(FD_tDeviceID* DevID, char* S, bool TrimStr) {
  FS_BinaryToHex(6,(BYTE*)&DevID->Serial,S);
  if (TrimStr == true) FS_TrimLeadingZeros(S);
};

//---------------------------------------------------------------------------
//convert Options bit flags to a hex string
void FS_GetOptionsString(DWORD Options, char* S, bool TrimStr) {
  FS_DwordToHex(Options,S);
  if (TrimStr == true) FS_TrimLeadingZeros(S);
};

//---------------------------------------------------------------------------
//Version is the version number, Decimal is the position of the decimal point
//zero decimal point assumes non-decimal type version number
void FS_GetVersionString(int Version, int Decimal, char* VerStr) {
  char Stmp[999];
  if (Decimal > 0)
    FS_Rnum(Version, Decimal, 0, Stmp,0);  // decimal places=2
  else FS_Inum(Version, 0, Stmp,0);  //non-decimal style version number
  FS_SCopy(VerStr,Stmp);
};

//---------------------------------------------------------------------------
//convert language number to language string
bool FS_GetFryeLanguageString(int Language, char* S) {
   switch(Language) {
     case 1: FS_SCopy(S,"English"); return(true);
     case 2: FS_SCopy(S,"French"); return(true);
     case 3: FS_SCopy(S,"German"); return(true);
     case 4: FS_SCopy(S,"Spanish"); return(true);
     default: FS_SCopy(S,"Unknown"); return(false);
   }//endswitch(Language)
};

//---------------------------------------------------------------------------
//convert language string (first char) to language number
int FS_GetFryeLanguageNumber(char* S) {
   char cLang;
   if (S==NULL) return(-1);
   cLang = (char)toupper(S[0]);
   switch(cLang) {
     case 'E': return(1);
     case 'F': return(2);
     case 'G': return(3);
     case 'S': return(4);
     case 'V': return(1);  //treat "V" the same as English for now
     default: return(0);
   }//endswitch(sLanguage)
};

//---------------------------------------------------------------------------
//Version is the version number, Decimal is the position of the decimal point
//zero decimal point assumes non-decimal type version number
//If Language > 0, tacks on the langauge letter at the end of the number
char* FS_GetVerLangString(int Version, int Decimal, char* VerStr, int Language) {
  char Stmp[999];
  if (Decimal > 0)
    FS_Rnum(Version, Decimal, 0, Stmp,0);  // decimal places=2
  else FS_Inum(Version, 0, Stmp,0);  //non-decimal style version number
  FS_SCat(VerStr,Stmp);
  if (Language > 0) {
    if (FS_GetFryeLanguageString(Language, Stmp) == true) {
      Stmp[1] = 0; //only keep first letter
      FS_SCat(VerStr,Stmp);
    }
  }//endif(Language)
  return(VerStr);
};

//-------------------------------------------------------------------
//returns true if the label line has no data
bool FS_BlankLabelLine(char* LabelLine) {
  int i;
  for (i=0; i<28; i++) {
    if (LabelLine[i] != 0x20) return(false);
    if (LabelLine[i] == 0) break;
  }
  return(true);
};


