//FryeStr special strings interface unit header file
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.

//---------------------------------------------------------------------------
#ifndef FryeStrH
#define FryeStrH
//---------------------------------------------------------------------------
extern char FS_sBLANK[];      //blank string def (a string with just a zero in it)
extern char FS_sBlank[];      //no message
extern char FS_sFailed[];
extern char FS_sUnknown[];
extern char FS_sNoMic[];
extern char FS_sCalibrationCable[];
extern char FS_cHex[16];

extern char* FS_ByteToHex(int Value, char * HexStr);
extern char* FS_WordToHex(int Value, char* HexStr);
extern char* FS_DwordToHex(DWORD Value, char* HexStr);
extern int FS_HexToDecimal(char HexDigit);
extern long double FS_HexToNumber(char* HexStr);
extern int FS_HexToValue(WORD Size, char* HexStr, BYTE* Value, int Default);
extern int FS_HexToByte(char* HexStr, BYTE* Value, BYTE Default);
extern int FS_HexToWord(char* HexStr, WORD* Value, WORD Default);
extern int FS_HexToDword(char* HexStr, DWORD* Value, DWORD Default);
extern int FS_HexToBinary(int Count, char* HexStr, BYTE* Data, BYTE Default);
extern int FS_BinaryToHex(int Count, BYTE* Data, char* HexStr);
extern int FS_HexToByteArray(int Count, char* HexStr, BYTE* Data, BYTE Default);
extern int FS_SLen(char* Str);
extern char* FS_SCopy(char* Dest, char* Src);
extern char* FS_SCat(char* Dest, char* Src);
extern char* FS_SCopy3(char* Dest, char* Str1, char* Str2, char* Str3);
extern char* FS_SCat3(char* Dest, char* Str1, char* Str2, char* Str3);
extern char* FS_TrimTrailingSpaces(char* Dest, char* Src);
extern char* FS_TrimLeadingSpaces(char* pStr);
extern char* FS_TrimLeadingZeros(char* pStr);
extern char* FS_Justify( char* sOutput, char* sInput, int L);
extern char* FS_Znum(int Num, int L, char* S, char* Tag);
extern char* FS_Inum(int Num, int L, char* S, char* Tag);
extern char* FS_Rnum(int Num, int D, int L, char* S, char* Tag);
extern char* FS_IntToStr(int Num, char* S);
extern bool FS_StringToInt(char* S, int* Value);
extern bool FS_StringToInt16(char* S, INT16* Value);
extern char* FS_TagFill(char* Dest, char* Src, char FillChar, int Size);
extern int FS_SubStr(char* Src, char* Dest, int Start, int Count);
extern int FS_ExtractString(char* Str, int Loc, char Separator, char* SubStr);
extern char* FS_DateStr(FD_tCalDate* Date, char* S, int How);
extern char* FS_HexID(BYTE* Serial, int x, char* S);
extern char* FS_FileSizeStr(DWORD RawSize, int L, char* S);
extern char* FS_Upper(char* sSrc, char* sDest);

extern void FS_GetDeviceIDString(FD_tDeviceID* DevID, char* S, bool TrimStr);
extern void FS_GetOptionsString(DWORD Options, char* S, bool TrimStr);
extern void FS_GetVersionString(int Version, int Decimal, char* VerStr);
extern bool FS_GetFryeLanguageString(int Language, char* S);
extern int FS_GetFryeLanguageNumber(char* S);
extern char* FS_GetVerLangString(int Version, int Decimal, char* VerStr, int Language);
extern bool FS_BlankLabelLine(char* LabelLine);

#endif
