//FryeTools toolkit file for applications using Fryers32.DLL or FryeCom.DLL
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//---------------------------------------------------------------------------

#include <dos.h>
#include <stdio.h>
#include <dir.h>
#include <windows.h>
#include "FryeDefs.h"
#include "FryeStr.h"
#include "FryeTools.h"

//---------------------------------------------------------------------------
BYTE ft_Crc8Table[256] = {
    0, 94,188,226, 97, 63,221,131,194,
    156,126, 32,163,253, 31, 65, 157,195, 33,127,252,162, 64, 30, 95,
    1,227,189, 62, 96,130,220, 35,125,159,193, 66, 28,254,160, 225,
    191, 93,  3,128,222, 60, 98, 190,224,  2, 92,223,129, 99, 61,124,
    34,192,158, 29, 67,161,255, 70, 24,250,164, 39,121,155, 197,132,
    218, 56,102,229,187, 89,  7, 219,133,103, 57,186,228, 6, 88, 25,
    71,165,251,120, 38,196,154, 101, 59,217,135,  4, 90, 184,230,167,
    249, 27, 69,198,152,122, 36, 248,166, 68, 26,153, 199, 37,123, 58,
    100,134,216, 91,  5,231,185, 140,210, 48,110, 237,179, 81, 15, 78,
    16,242,172, 47,113,147,205, 17, 79,173, 243,112, 46,204,146,211,
    141,111, 49,178,236, 14, 80, 175,241, 19, 77,206,144,114, 44,109,
    51,209,143, 12, 82,176,238, 50,108, 142,208, 83, 13,239,177,240,
    174, 76, 18,145,207, 45,115, 202, 148,118, 40,171,245, 23, 73,  8,
    86,180,234,105, 55,213,139, 87,  9,235,181, 54,104,138,212,149,
    203, 41,119,244,170, 72, 22, 233,183, 85, 11,136,214, 52,106, 43,
    117,151,201, 74, 20,246, 168, 116, 42,200,150, 21, 75,169,247,182,
    232, 10, 84,215,137, 107, 53};

//---------------------------------------------------------------------------
WORD ft_Crc16Table[256] = {
        0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241,
        0xc601, 0x06c0, 0x0780, 0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440,
        0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1, 0xce81, 0x0e40,
        0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841,
        0xd801, 0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40,
        0x1e00, 0xdec1, 0xdf81, 0x1f40, 0xdd01, 0x1dc0, 0x1c80, 0xdc41,
        0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680, 0xd641,
        0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040,
        0xf001, 0x30c0, 0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240,
        0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501, 0x35c0, 0x3480, 0xf441,
        0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
        0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840,
        0x2800, 0xe8c1, 0xe981, 0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41,
        0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1, 0xec81, 0x2c40,
        0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640,
        0x2200, 0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041,
        0xa001, 0x60c0, 0x6180, 0xa141, 0x6300, 0xa3c1, 0xa281, 0x6240,
        0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480, 0xa441,
        0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41,
        0xaa01, 0x6ac0, 0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840,
        0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01, 0x7bc0, 0x7a80, 0xba41,
        0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
        0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640,
        0x7200, 0xb2c1, 0xb381, 0x7340, 0xb101, 0x71c0, 0x7080, 0xb041,
        0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0, 0x5280, 0x9241,
        0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440,
        0x9c01, 0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40,
        0x5a00, 0x9ac1, 0x9b81, 0x5b40, 0x9901, 0x59c0, 0x5880, 0x9841,
        0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81, 0x4a40,
        0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41,
        0x4400, 0x84c1, 0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641,
        0x8201, 0x42c0, 0x4380, 0x8341, 0x4100, 0x81c1, 0x8081, 0x4040
};


WORD FT_Crc16 = 0;              // Init the global Crc16 var

//---------------------------------------------
//This delays by the number of ms that was passed
void FT_Delay(int Value) {
  int StartTime = GetTickCount();
  while (((int)(GetTickCount()) - StartTime) < Value) {};
};

//----------------------------------------------
//process delay in ms - this starts a timer then exits. You can then go do something else
//and periodcically call this to see if your time is up.
//returns the current timer value. Delay is the amount of time to wait.
//StartTime is the original Starting time returned by the function when Delay=0.
//Example Usage:
// int StartTime;
// myXDelay(StartTime,0); //initialize counter
// while(true) {
//   if (myXDelay(StartTime,1000) == true) break; //wait for true
//   DoSomethingElse  //do something else while waiting
// }
bool FT_XDelay(int* StartTime, int Delay) {
  if (Delay == 0) {
    *StartTime = GetTickCount();
    return(true);
  }
  if (((int)(GetTickCount()) - *StartTime) < Delay) return(false);
  else return(true);
};

//---------------------------------------------------------------------------
//Copy a Dallas ID number to another location (eight bytes long)
void FT_CopyFullID(void* Dest, void* Src) {
  int i;
  WORD* D = (WORD*)Dest;
  WORD* S = (WORD*)Src;
  for (i=0; i<4; i++)
    D[i] = S[i];
};

//---------------------------------------------------------------------------
//Compare two Dallas ID numbers (eight bytes long)
//Return TRUE if the same, or FALSE if different
BOOL FT_CompareFullID(void* ID1, void* ID2) {
  int i;
  WORD* IDa = (WORD*)ID1;
  WORD* IDb = (WORD*)ID2;
  for (i=0; i<4; i++) {
    if (IDa[i] != IDb[i])
      return(FALSE);
  }
  return(TRUE);
};

//---------------------------------------------
//combines PathName with FileName to create a fully qualified PathName
//if backslash is missing from the path, adds it in.
//if Path is empty, just returns the FileName.
//if PathName == null, or FileName == null, returns nothing.
//returns a pointer to PathName as the function result.
char* FT_BuildPathName(char* FullPathName, char* FilePath, char* FileName) {
  int Size;
  if (FullPathName == NULL) return(NULL);
  Size = FS_SLen(FilePath);
  if (Size == 0) {
    FS_SCopy(FullPathName,FileName); //scopy returns emtpy PathName if FileName is empty
  }else{
    if (FilePath[Size-1] == '\\')
      FS_SCopy3(FullPathName,FilePath,FileName,0);
    else FS_SCopy3(FullPathName,FilePath,"\\",FileName);
  }
  return(FullPathName);
};

//---------------------------------------------
//removes the extent from a FileName (can be a fully qualified name)
//if DestName == null, or FileName == null, returns nothing.
//returns a pointer to DestName as the function result.
char* FT_RemoveFileExt(char* DestName, char* FileName) {
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];

  if ((DestName == NULL)||(FileName == NULL)) return(NULL);
  fnsplit(FileName,drive,dir,file,ext);
  fnmerge(DestName,drive,dir,file,NULL);
  return(DestName);
};


//---------------------------------------------
//Changes the extent of a FileName (can be a fully qualified name)
//if DestName == null, or FileName == null, returns nothing.
//returns a pointer to DestName as the function result.
char* FT_ChangeFileExt(char* DestName, char* FileName, char* NewExt) {
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];

  if ((DestName == NULL)||(FileName == NULL)) return(NULL);
  fnsplit(FileName,drive,dir,file,ext);
  fnmerge(DestName,drive,dir,file,NewExt);
  return(DestName);
};

//---------------------------------------------------------------------------
void FT_RemoveLastDelimiter(char* S) {
  int Last;
  if (S == NULL) return;
  Last = strlen(S) - 1;
  if (S[Last] == '\\') S[Last] = (char)0;
};

//---------------------------------------------
//if the file exists, returns true and the size of the file,
//if the file does not exist, returns false and zero size.
//Does not include hidden or system files.
bool FT_FileSize(char* PathName, DWORD* Size) {
  struct ffblk sr;
  bool Result;
  int iAttributes = 0;
  iAttributes |= FA_RDONLY;
  iAttributes |= FA_ARCH;
  iAttributes |= FA_HIDDEN;
  if (findfirst(PathName, &sr, iAttributes) == 0) {
    *Size = sr.ff_fsize;
    Result = true;
  }else{
    *Size = 0;
    Result = false;
  }
  findclose(&sr);
  return(Result);
};

//---------------------------------------------------------------------------
// Check the Crc8 of the serial number supplied Data array.
// Size = Array length in bytes. Data* = Array pointer.
// Assumes Crc8 of data is in the last byte of the array.
// If Crc8 is not the last byte in the array, returns Crc8 of the array
// else Returns 0 if Crc8=0 (last byte is a valid Crc8 of the data).
// Note: a Crc8 is much faster than a Crc16, but not as accurate
// If Data is all zeros, the crc will be zero.
//---------------------------------------------------------------------------
BYTE FT_CheckCrc8(int Size, BYTE* Data) {
  int i;
  BYTE Crc8 = 0;          //Init the Crc8
  for(i=0; i<Size; i++)   //Do all n bytes
    Crc8 = ft_Crc8Table[Crc8 ^ Data[i]];
  return(Crc8);
};

//---------------------------------------------------------------------------
// This procedure calculates the Crc16 of the data byte X pass to it.
// The result is accumulated in global variable Crc16 which is a word type.
// Note: The Crc16 result from the Dallas part comes back inverted.
// The Polynomial function is: (X exp 16) + (X exp 15) + (X exp 2) + 1
//---------------------------------------------------------------------------
//calculate 16-bit CRC...  original code including lookup table
//directly derived from a mailing list posting by Mark Crispin via Aaron
WORD FT_FastCrc16(int Size, BYTE* pData, WORD Crc16) {
	BYTE* tempindex = pData;
	//C pointer manipulation at its finest(!?)
	while(Size--)
    Crc16 = (WORD)((Crc16 >> 8) ^ ft_Crc16Table[(Crc16 ^ *tempindex++) & 0xff]);
	return(Crc16);
};


//---------------------------------------------------------------------------
//calculate 16-bit CRC...  original code including lookup table
//directly derived from a mailing list posting by Mark Crispin via Aaron
WORD FT_CheckFastCrc16(int Size, BYTE *pData) {
  WORD MyCrc16 = 0;
  return(FT_FastCrc16(Size,pData,MyCrc16));
};


//---------------------------------------------------------------------------
//Checks cal date. If good cal date returns TRUE, else returns FALSE
bool FT_ValidCalDate(FD_tCalDate* pCalDate) {
  if ((pCalDate->Month == 0x0f)||(pCalDate->Day == 0xff)||(pCalDate->Year == 0))
    return(false);
  else return(true);
};



//---------------------------------------------------------------------------
//This unpacks the MicCal DWORD into the unpacked CalDate variable
//dd:ee:yyy:m where "yyy" = year, "m"=month, "dd"=day, "ee"=expire
//---------------------------------------------------------------------------
bool FT_UnpackCalDate(FD_tPackedCalDate PackedCalDate, FD_tCalDate* pCalDate) {
  pCalDate->Year = (WORD)((PackedCalDate >> 4) & 0x0fff); //year of last cal
  pCalDate->Month = (BYTE)(PackedCalDate & 0x000f);          //month of last calibration
  pCalDate->Day = (BYTE)((PackedCalDate >> 24) & 0x00ff);    //day of last calibration
  pCalDate->Expire = (WORD)((PackedCalDate >> 16) & 0x00ff); //months until expiration
  if (FT_ValidCalDate(pCalDate) == false) {
    *pCalDate = FD_NoCalDate; //if unprogramed, dallas has -1 in it
    return(false);
  }
  return(true);
};

//---------------------------------------------------------------------------
//This packs the CalDate variable down to the MicCal DWORD
//dd:ee:yyy:m where "yyy" = year, "m"=month, "dd"=day, "ee"=expire
//---------------------------------------------------------------------------
FD_tPackedCalDate FT_PackCalDate(FD_tCalDate* CalDate) {
  FD_tPackedCalDate PackedCalDate;
  if ((CalDate->Year == 0)||(CalDate->Month == 0)||(CalDate->Day == 0)) {
    PackedCalDate = FD_NoPackedDate;
  }else{
    PackedCalDate = ((CalDate->Year & 0x0fff) << 4) +
                    (CalDate->Month & 0x000f) +
                    ((CalDate->Day & 0x00ff) << 24) +
                    ((CalDate->Expire & 0x00ff) << 16);
  }
  return(PackedCalDate);
};

//---------------------------------------------------------------
//               Curve Frame Time Stamp Format
//----------- high word --------- ---------- low word -----------
//F E D C B A 9 8 7 6 5 4 3 2 1 0 F E D C B A 9 8 7 6 5 4 3 2 1 0
//|---------| |-----| |-------| |-------------------------------|
//   Year      Month     Day          Seconds in Day  H*M*S
//   (0-63)     (1-12)   (1-31)              (0-86399)
//   0=1990     1=Jan                   00:00:00 to 23:59:59
//---------------------------------------------------------------

//This unpacks a curve frame time stamp to the MSDOS/Windows date/time record format
//returns false is timestamp is invalid (0), else returns true.
bool FT_UnpackCurveStamp(FD_tCrvTimeStamp CrvStamp, FD_tTime* pCrvTime) {
  int Secs;
  pCrvTime->Year = (WORD)(((CrvStamp >> 27) & 0x003F) + 1990);
  pCrvTime->Month = (BYTE)((CrvStamp >> 23) & 0x000F);
  pCrvTime->Day = (BYTE)((CrvStamp >> 18) & 0x001F);
  pCrvTime->spare = 0;
  Secs = (CrvStamp & 0x1FFFF);
  pCrvTime->Hour = (BYTE)(Secs / 3600);
  Secs = (Secs % 3600);
  pCrvTime->Minute = (BYTE)(Secs / 60);
  pCrvTime->Second = (BYTE)(Secs % 60);
  pCrvTime->Millisecond = 0;
  if (CrvStamp == 0) return(false);
  else return(true);
};

//<eof>




