//Fryers Toolkit definition header file for FryeTools
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows
//operating system.
//No warranties are expressed or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//---------------------------------------------------------------------------
#ifndef MyToolsH
#define MyToolsH
//---------------------------------------------------------------------------

enum {
  UNKNOWN = 0,
  ENGLISH = 1,
  FRENCH = 2,
  GERMAN = 3,
  SPANISH = 4
};
#define NUM_LANGUAGE 5 //number of known languages

//---------------------------------------------------------------------------

extern WORD FT_Crc16;                 //global Crc16 var

extern void FT_Delay(int Value);    //delay in ms
extern bool FT_XDelay(int* StartTime, int Delay);
extern void FT_CopyFullID(void* Dest, void* Src);
extern BOOL FT_CompareFullID(void* ID1, void* ID2);
extern char* FT_BuildPathName(char* FullPathName, char* FilePath, char* FileName);
extern char* FT_RemoveFileExt(char* DestName, char* FileName);
extern char* FT_ChangeFileExt(char* DestName, char* FileName, char* NewExt);
extern void FT_RemoveLastDelimiter(char* S);
extern bool FT_FileSize(char* PathName, DWORD* Size);

extern BYTE FT_CheckCrc8(int Size, BYTE* Data);
extern WORD FT_FastCrc16(int Size, BYTE *pData, WORD Crc16);
extern WORD FT_CheckFastCrc16(int Size, BYTE *pData);
extern bool FT_ValidCalDate(FD_tCalDate* pCalDate);
extern bool FT_UnpackCalDate(FD_tPackedCalDate PackedCalDate, FD_tCalDate* pCalDate);
extern FD_tPackedCalDate FT_PackCalDate(FD_tCalDate* CalDate);
extern bool FT_UnpackCurveStamp(FD_tCrvTimeStamp CrvStamp, FD_tTime* pCrvTime);

#endif
