//Common Fryers Interface header file for FryeDlls.cpp
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 10 Oct 2010

#ifndef FryersH
#define FryersH

#include <windows.h>  //used to get the DLL calling API from Windows
#include "FryeDefs.h" //common declarations used with Frye programs.
#include "FryeRegs.h" //low-level calls for older Fryers interface.

#define FIPP_SUCCESS SUCCESS //same basic definitions
#define FIPP_CANCEL  CANCEL  //for backwards compatiblity

//---------------------------------------------------------------------------
const INT16 FCOM_ACK  = (INT16)0xFFFC;
const INT16 FCOM_NAK  = (INT16)0xFFFB;
const INT16 FCOM_ILL  = (INT16)0xFFFA;
const INT16 FCOM_POLL = (INT16)0xFFFF;
const INT16 FCOM_QTC  = (INT16)0x7FFF;


//---------------------------------------------------------------------------
//The following software versions know about the QT command
#define FIPP_QTVersion6500   400
#define FIPP_QTVersionFP40   240
#define FIPP_QTVersionFA1x   111
#define FIPP_QTVersionFP35   200  //(all versions with FIPP)
#define FIPP_QTVersion7000   100  //(all versions with FIPP)
#define FIPP_QTVersion8000   100  //(all versions with FIPP)

// Communication Port constants
#define FIPP_DEFAULT_BAUDRATE 9600      //Fonix instruments default to 9600 baud

//various timeout values
#define FIPP_STD_POLL_TIMEOUT 5500         //std=5.5sec  //value is in msecs
#define FIPP_LONG_POLL_TIMEOUT 15000       //long=15sec
#define FIPP_EXTRA_LONG_POLL_TIMEOUT 30000 //exlong=30sec
#define FIPP_SUPER_LONG_POLL_TIMEOUT 60000 //superlong=1min
#define FIPP_SHORT_POLL_TIMEOUT 1000       //short=1sec
#define FIPP_DEFAULT_NO_POLL FIPP_STD_POLL_TIMEOUT //default = std
#define FIPP_NO_POLL_UNCHANGED  0           //if zero, don't change the no-poll timeout

//current known Machine Model Type Constants
#define FONIX_UNKNOWN -1
#define FONIX_6500 0
#define FONIX_6400 1
#define FONIX_7000 7000
#define FONIX_8000 8000
#define FONIX_8001 8001
#define FONIX_FP40 40
#define FONIX_FP35 35
#define FONIX_FA10 100
#define FONIX_FA12 102
#define FONIX_FA18 108
//100-200 are audiometer machine types. 100, 102, and 108 are defined as FA10,FA12,FA18


//===============================================================================================
//Possible errors that might be returned
//Fryers Errors are -1000 series numbers
#define FRYERS_GENERIC_ERROR -1000   //unknown fryers error - something bad happened
#define FRYERS_FILE_NOT_FOUND -1001  //device driver file not found
#define FRYERS_ENTRY_NOT_FOUND -1002 //entry point to fryers driver not found

#define FRYERS_SUCCESS SUCCESS       //(0) Fryers driver is loaded and entry point found

//These map to the same defines as the older FRYERS error codes
#define FCOM_GENERIC_ERROR -1000   //unknown fryecom error - something bad happened
#define FCOM_FILE_NOT_FOUND -1001  //device driver file not found
#define FCOM_ENTRY_NOT_FOUND -1002 //entry point to fryecom driver not found
#define FCOM_BAD_DRIVER -1003      //unknown internal problem encountered in the Driver

//FIPP Errors use the -2000 series
#define FIPP_INVALID_FORMAT  -2000 //specified cmd format is not valid
#define FIPP_IN_BOOTLOADER  -2010  //instrument is in boot loader and cannot do the specified cmd
#define FIPP_NOGO_ERROR  -2012     //instrument reported that previous cmd failed to operate correctly


//===============================================================================================
//Fryers32 versions that may be returned
//Note: if you call through to the low-level Fryers DLL (CallFryers), 
//you will get the Fryers32 DLL version numbers back instead of the FryeCom DLL version numbers. 
//This is to allow backwards compatibility to old software that might require the Fryers Version number info.
//If you use the standard FryeCom DLL calls, you will get the FryeCom version number.
//int Last_FryersCOM_Version = 0x40; //{major plus standard - minor not used : (MSDOS only) not supported in win32 programs
#define FRYERS32_FIRST_DLL_VERSION 500 //this is the first 32 bit dll version of fryers anything earlier won't work with 32bit windows
#define FRYERS32_EARLY_DLL_VERSION 512 //this is the first good version of the 32bit dll strongly request them to update if earlier than this
#define FRYERS32_LATE_DLL_VERSION 516 //this is the previous good version of the 32bit dll lightly request them to update if earlier than this
#define FRYERS32_GOOD_DLL_PORT_VERSION 520 //this Fryers version fixes the comport problem (allow max > 9 ports)
#define FRYERS32_NEW_DLL_PORT_VERSION 620  //this Fryers version fixes the windows 7 problem (thread sync issues)

//Current Fryers32 version number ** Keep this updated! ** Used by Fcheck program
#define FRYERS32_CURRENT_DLL_VERSION 620 //this is the long version number of the current released DLL

//NOTE: The above is *NOT* the same as the FryeCom version number.
//The FryeCom version number starts with V7.01
//(there was an pre-release beta FryeCom DLL that declared itself to be V6.00)
//===============================================================================================

//Current FryeCom version number ** Keep this updated! ** Used by Fcheck program
#define FRYECOM_CURRENT_DLL_VERSION 720 //this is the long version number of the current released DLL


//===============================================================================================
//Max Com port defines
//Note: We don't actually use FP_MAX_OLD_COM_PORT. It is here for reference only.
const F32_MaxComPort = 255;            //max com ports supported 
const FCOM_MAX_PORTS = 256; //max ports allowed to access via Fryers (V6.00 and above)
const FCOM_MAX_OLD5_COM_PORT = 99;     //max ports of 99 allowed to access for Fryers V5.20 to V5.40 Fryers
const FCOM_MAX_OLD4_COM_PORT = 9;  //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
const FCOM_MAX_COM_PORT = FCOM_MAX_PORTS; //we have 256 comports allowed in this application if new Fryers (6.00 or above)

//------------------

//=====================================================================================================
//These are the older error codes used by the old Fryers based programs. 
//These codes should not be used anymore. See the FryeComD.h file for the updated
//error code values (FCOM_errorcode).

//common errors
const RS232_CANCEL = -1;
const RS232_SUCCESS = 0;

//Fryers errors use the 9000 series
const RS232_BAD_FRYERS_DRIVER = -9000; //bad version of Fryers Driver
const RS232_PORT_NOT_FOUND = -9001;    //Requested port not available
const RS232_PORT_NOT_OPEN = -9002;     //Requested port not open for communication
const RS232_PACKET_NOT_OPEN = -9003;   //Requested port not open for packet xfer
const RS232_NO_POLL = -9004;           //no polls from the instrument
const RS232_SEND_ERROR = -9005;        //error while trying to send the command
const RS232_NO_RESPONSE = -9006;       //no response recieved
const RS232_RESPONSE_ERROR = -9007;    //error while recieveing the response
const RS232_CMD_FAIL = -9008;          //unexpected response to a command
const RS232_ILL_RSP = -9010;           //illegal command rcvd as a response
const RS232_NAK_RSP = -9011;           //NAK rcvd as a respond
const RS232_IN_BOOTLOADER = -9012;     //tried to give non-BL cmd while in BL
const RS232_PORT_RANGE_ERROR = -9013;  //not a valid comport selection (out of range)
const RS232_NO_HARDWARE = -9014;       //no com port hardware found (emulated or real)
const RS232_UNEXPECTED_ACK = -9015;     //got ACK response when wasn't supposed to
const RS232_CHARACTER_NOT_OPEN = -9016; //using char when not in character mode

const RS232_AUTOBAUD_FAILED = -9100;  //could not find baudrate
const RS232_BAD_BAUDRATE = -9101;     //tried to set an invalid baudrate
const RS232_OLD_FRYERS_DRIVER = -9102; //early version of Fryers Driver (not a serious error)


#endif

