//Common Fryers Interface header file for FryeDlls.cpp
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 10 Oct 2010

unit Fryers;
interface

uses windows,   //used to get the DLL calling API from Windows
     FryeDefs;   //common declarations used with Frye programs.

{$I FRYEREGS.INC} //<-- defs used by low-level older Fryers32 based programs

const FIPP_SUCCESS = SUCCESS; //same basic definitions
const FIPP_CANCEL  = CANCEL;  //for backwards compatiblity

//---------------------------------------------------------------------------
const FCOM_ACK  : INT16 = INT16($FFFC); //-4
const FCOM_NAK  : INT16 = INT16($FFFB); //-5
const FCOM_ILL  : INT16 = INT16($FFFA); //-6
const FCOM_POLL : INT16 = INT16($FFFF); //-1
const FCOM_QTC  : INT16 = INT16($7FFF); //32767

//---------------------------------------------------------------------------
//The following software versions know about the QT command
const FIPP_QTVersion6500 = 400;
const FIPP_QTVersionFP40 = 240;
const FIPP_QTVersionFA1x = 111;
const FIPP_QTVersionFP35 = 200;  //(all versions with FIPP)
const FIPP_QTVersion7000 = 100;  //(all versions with FIPP)
const FIPP_QTVersion8000 = 100;  //(all versions with FIPP)

// Communication Port constants
const FIPP_DEFAULT_BAUDRATE = 9600;      //Fonix instruments default to 9600 baud

//various timeout values
const FIPP_STD_POLL_TIMEOUT = 5500;         //std=5.5sec  //value is in msecs
const FIPP_LONG_POLL_TIMEOUT = 15000;       //long=15sec
const FIPP_EXTRA_LONG_POLL_TIMEOUT = 30000; //exlong=30sec
const FIPP_SUPER_LONG_POLL_TIMEOUT = 60000; //superlong=1min
const FIPP_SHORT_POLL_TIMEOUT = 1000;       //short=1sec
const FIPP_DEFAULT_NO_POLL = FIPP_STD_POLL_TIMEOUT; //default = std

//special note timeout values (for reference)
const FCOM_DEFAULT_RSP_TIMEOUT = 1100;   //default response timeout 1.1 second
const FCOM_DEFAULT_RCV_TIMEOUT = 1100;   //default receive timeout 1.1 second
const FCOM_MIN_NO_POLL_TIMEOUT = 500;    //Timeout less than 500ms are not allowed

//current known Machine Model Type Constants
const FONIX_UNKNOWN = -1;
const FONIX_6500 = 0;
const FONIX_6400 = 1;
const FONIX_7000 = 7000;
const FONIX_8000 = 8000;
const FONIX_8001 = 8001;
const FONIX_FP40 = 40;
const FONIX_FP35 = 35;
const FONIX_FA10 = 100;
const FONIX_FA12 = 102;
const FONIX_FA18 = 108;
//100-200 are audiometer machine types. 100, 102, and 108 are defined as FA10,FA12,FA18


//===============================================================================================
//Possible errors that might be returned
//Fryers Errors are -1000 series numbers
const FRYERS_GENERIC_ERROR = -1000;   //unknown fryers error - something bad happened
const FRYERS_FILE_NOT_FOUND = -1001;  //device driver file not found
const FRYERS_ENTRY_NOT_FOUND = -1002; //entry point to fryers driver not found

const FRYERS_SUCCESS = SUCCESS;       //(0) Fryers driver is loaded and entry point found

//Possible driver errors that might be returned by FryeCom.DLL (1000 series)
//These map to the same defines as the older FRYERS32 error codes
const FCOM_GENERIC_ERROR = -1000;   //unknown fryecom error - something bad happened
const FCOM_FILE_NOT_FOUND = -1001;  //device driver file not found
const FCOM_ENTRY_NOT_FOUND = -1002; //entry point to fryecom driver not found
const FCOM_BAD_DRIVER = -1003;      //unknown internal problem encountered in the Driver

//FIPP Errors use the -2000 series
const FIPP_INVALID_FORMAT = -2000;
const FIPP_IN_BOOTLOADER = -2010;

//===============================================================================================
//Fryers32 versions that may be returned
//Note: if you call through to the low-level Fryers DLL (CallFryers), 
//you will get the Fryers32 DLL version numbers back instead of the FryeCom DLL version numbers. 
//This is to allow backwards compatibility to old software that might require the Fryers Version number info.
//If you use the standard FryeCom DLL calls, you will get the FryeCom version number.
//int Last_FryersCOM_Version = 0x40; //{major plus standard - minor not used : (MSDOS only) not supported in win32 programs
const FRYERS32_FIRST_DLL_VERSION = 500; //this is the first 32 bit dll version of fryers anything earlier won't work with 32bit windows
const FRYERS32_EARLY_DLL_VERSION = 512; //this is the first good version of the 32bit dll strongly request them to update if earlier than this
const FRYERS32_LATE_DLL_VERSION = 516; //this is the previous good version of the 32bit dll lightly request them to update if earlier than this
const FRYERS32_GOOD_DLL_PORT_VERSION = 520; //this Fryers version fixes the comport problem (allow max > 9 ports)
const FRYERS32_NEW_DLL_PORT_VERSION = 620;  //this Fryers version fixes the windows 7 problem (thread sync issues)

//Current Fryers32 version number ** Keep this updated! ** Used by Fcheck program
const FRYERS32_CURRENT_DLL_VERSION = 620; //this is the long version number of the current released DLL

//NOTE: The above is *NOT* the same as the FryeCom version number.
//The FryeCom version number starts with V7.01
//(there was an pre-release beta FryeCom DLL that declared itself to be V6.00)
//===============================================================================================

//Current FryeCom version number ** Keep this updated! ** Used by Fcheck program
const FRYECOM_CURRENT_DLL_VERSION = 720; //this is the long version number of the current released DLL


//===============================================================================================
//Max Com port defines
//Note: We don't actually use FP_MAX_OLD_COM_PORT. It is here for reference only.
const F32_MaxComPort = 255;              //max com ports supported in Fryers32
const FCOM_MAX_PORTS = F32_MaxComPort+1; //max ports allowed to access via Fryers (V6.00 and above)
const FCOM_MAX_OLD5_COM_PORT = 99;     //max ports of 99 allowed to access for Fryers V5.20 to V5.40 Fryers
const FCOM_MAX_OLD4_COM_PORT = 9;  //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
const FCOM_MAX_COM_PORT = FCOM_MAX_PORTS; //we have 256 comports allowed in this application if new Fryers (6.00 or above)

//--------------------------------

//=====================================================================================================
//These are the older error codes used by the old Fryers based programs. 
//These codes should not be used anymore. See the FryeComD.h file for the updated
//error code values (FCOM_errorcode).

//common errors
const RS232_CANCEL = -1;
const RS232_SUCCESS = 0;

//Fryers errors use the 9000 series
const RS232_BAD_FRYERS_DRIVER = -9000; //bad version of Fryers Driver
const RS232_PORT_NOT_FOUND = -9001;    //Requested port not available
const RS232_PORT_NOT_OPEN = -9002;     //Requested port not open for communication
const RS232_PACKET_NOT_OPEN = -9003;   //Requested port not open for packet xfer
const RS232_NO_POLL = -9004;           //no polls from the instrument
const RS232_SEND_ERROR = -9005;        //error while trying to send the command
const RS232_NO_RESPONSE = -9006;       //no response recieved
const RS232_RESPONSE_ERROR = -9007;    //error while recieveing the response
const RS232_CMD_FAIL = -9008;          //unexpected response to a command
const RS232_ILL_RSP = -9010;           //illegal command rcvd as a response
const RS232_NAK_RSP = -9011;           //NAK rcvd as a respond
const RS232_IN_BOOTLOADER = -9012;     //tried to give non-BL cmd while in BL
const RS232_PORT_RANGE_ERROR = -9013;  //not a valid comport selection (out of range)
const RS232_NO_HARDWARE = -9014;       //no com port hardware found (emulated or real)
const RS232_UNEXPECTED_ACK = -9015;     //got ACK response when wasn't supposed to
const RS232_CHARACTER_NOT_OPEN = -9016; //using char when not in character mode

const RS232_AUTOBAUD_FAILED = -9100;  //could not find baudrate
const RS232_BAD_BAUDRATE = -9101;     //tried to set an invalid baudrate
const RS232_OLD_FRYERS_DRIVER = -9102; //early version of Fryers Driver (not a serious error)


implementation

end.

