//Fryers interface unit for Borland BCB
//This will compile under any version of Borland BCB
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 10 Oct 2010
//----------------------------------------------------
//If you have experience with the older MSDOS based Fryers TSR
//you will find this calling interface to the Fryers driver to be
//exactly the same. It was done this way on purpose to allow easy
//upgrading of old programs and to minimize the learning time
//to upgrading old systems up to Win32.
//--------------------------------------------------------------------
//Note: this is provided to allow update of older Fryers32 programs.
//You should consider migrating your new programs to use the new FryeCom interface.
//The FryeComDLL contains a backwards compatible FRYERS32 call interface
//To make the migration to FryeCom easier. However, you should really consider
//changing the call interface in your program to make use of the new 
//FryeCom call methods which are much easier to use and understand.  
//---------------------------------------------------------------------


#include <vcl\vcl.h>
#pragma hdrstop

//#include <stdio.h>
#include <windows.h>  //used to get the DLL calling API from Windows
#include "FryeDefs.h" //Common shared frye data
#include "Fryers32.h" //Fryers register definitions

//The call interface in the DLL looks like this
//typedef void __stdcall (*tCallFryers)(F_RegsType* IRegs);

HINSTANCE FryersLibHandle = NULL;
tCallFryers CallFryersProc = NULL;
bool FryersActive = false;
tHandle FRYERS32_PortHandle = 0;         //Call FRYERS32_GetFryersVersion() to update this value
char FRYERS32_DllFilename[256] = "";      //name of the DLL file being used

char FRYERS32_DLL_NAME[] = "fryers32.dll";
char FRYECOM_DLL_NAME[] = "fryecom.dll";

//----------------------------------------------------
//This is a wrapper to make the DLL call safe. It also eliminates the
//need to manage the DLL in your program since it is automatically managed here
//If this is a first time caller, the Fryers32.DLL is searched for on the normal
//search path for the computer. If found, the driver is loaded into memory and
//the CallFryers interface is looked for. If found, the procedure pointer is
//updated and the call to the Fryers driver is made. Note: The call to initialize
//the Fryers dll will take up to 200ms to perform. Also if you change the baudrate
//there may be a 200ms delay as Windows does it's thing (I have no control over that).
//Returns FRYERS_FILE_NOT_FOUND if the DLL was not found on the search path.
//returns FRYERS_ENTRY_NOT_FOUND if the CallFryers procedure call was not found.
int __stdcall CallFryers(F_RegsType* pIRegs) {
  FryersActive = true;
  if (FryersLibHandle == NULL) {
    CallFryersProc = NULL;
    strcpy(FRYERS32_DllFilename,FRYECOM_DLL_NAME);
    FryersLibHandle = LoadLibrary(FRYECOM_DLL_NAME);
    if (FryersLibHandle == NULL) {
      //if fryecom not found, try for fryers32 instead
      strcpy(FRYERS32_DllFilename,FRYERS32_DLL_NAME);
      FryersLibHandle = LoadLibrary(FRYERS32_DLL_NAME);
      if (FryersLibHandle == NULL) {
        FryersActive = false;
        return(FRYERS_FILE_NOT_FOUND);
      }
    }
  }
  if (CallFryersProc == NULL) {
    CallFryersProc = (tCallFryers)GetProcAddress(FryersLibHandle, "CallFryers");
    if (CallFryersProc == NULL) {       //check if we found the procedure we want
      FreeLibrary(FryersLibHandle); //release the DLL
      FryersLibHandle = NULL;       //and kill the variable
      FryersActive = false;
      return(FRYERS_ENTRY_NOT_FOUND);
    }//endif(CallFryersProc==NULL)
  }//endif(CallFryersProc==NULL)
  CallFryersProc(pIRegs);
  FryersActive = false;
  return(FRYERS_SUCCESS);
};

/*
//Don't use this, the DLL will automatically be unloaded when your program shuts down.
//----------------------------------------------
//For example only. Normally you should not call this.
//Windows till release the DLL properly when the program shuts down.
bool ReleaseFryers(void) {
  bool fFreeResult = FreeLibrary(FryersLibHandle);
  return(fFreeResult);
};
*/

//---------------------------------------------------------------------------
//get the last available Fryers com port
int FRYERS32_LastComPort(void) {
  int Ver;
  int Max;

  int Result;
  F_RegsType R;

  Result = FRYERS32_GetLongFryersVersion(&Ver);
  //if cmd failed, assume old style max port (9)
  if (Result != SUCCESS) return(MAX_OLD_COM_PORT);
  //check if we have the newer Fryers32 version
  if (Ver >= FRYERS32_NEW_DLL_PORT_VERSION) { //Ver610
    //if later version,
    R.AX = 0x0FFFC;  //see if function 0xFFFC is available first
    R.DX = 0; //port# is not important
    Result = CallFryers(&R);   //ax=maxport, bx=version, cx=portstate, dx=ffff(if cmd avail), di=baudrate, si=<reserved(0)>
    //verify that the cmd is valid
    if ( ((INT16)R.DX != (INT16)0xFFFF) && (Result == SUCCESS) ) {
      Max = R.AX;
      if (Max > 256) Max = MAX_NUM_PORTS;
    }else{
      Max = MAX_NEW_COM_PORT;
    }
    return(Max);
  //if really old version, we only have 9 ports available
  }else if (Ver < FRYERS32_GOOD_DLL_PORT_VERSION) { //below Ver520
    Max = MAX_OLD_COM_PORT; //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
    return(Max);
  //
  }else{ //Assume Ver520 if we get here
    Max = MAX_99_COM_PORT; //we have 99 comports allowed in this application if good Fryers (V5.20 to 6.10)
    return(Max);
  }
}

//-------------------------------------------------
// Example call to return Fryers short version number
// Here is an example of calling the Fryers driver.
// See the documentation and sample code for a detailed
//explaination on using the Fryers driver.
int FRYERS32_GetShortFryersVersion(int* Version) {
  int Result;
  F_RegsType R;

  if (Version != NULL) *Version = 0;
  R.AX = 0x0FFFF;
  R.DX = 0;
  R.CX = 0;
  Result = CallFryers(&R);
  if (Result != FRYERS_SUCCESS) return(Result);
  if ((R.DX & 0x0FFFF) != 0x0FFFF) return(RS232_BAD_FRYERS_DRIVER);
  if (Version != NULL) *Version = R.AX;
  return(Result);
}

//-------------------------------------------------
// Example call to return Fryers long version number
int FRYERS32_GetLongFryersVersion(int* Version) {
  int Result;
  F_RegsType R;

  if (Version != NULL) *Version = 0;
  R.AX = 0x0FFFE;
  R.DX = 0;
  R.CX = 0;
  R.SI = 0;
  R.DI = 0;
  Result = CallFryers(&R);
  if (Result != FRYERS_SUCCESS) return(Result);
  if ((R.DX & 0x0FFFF) != 0x0FFFF) return(RS232_BAD_FRYERS_DRIVER);
  if (Version != NULL) *Version = R.BX;
  return(Result);
}

//-----------------------------------------------------------------------
//returns empty string or "Unknown" if could not get valid version string
//returns version number as a result of the call, or failure code if negative number
//A specific com port it not required for this, so we can use com0.
//note the first byte of the version string is the string length.
//returns negative number on failure.
int FRYERS32_GetVersionString(AnsiString* Vers) {
  int Result;
  int i,Count;
  F_RegsType R;

  if (Vers != NULL) *Vers = "";   //initialize the Ansistring if available
  R.AX = 0xFFFE;
  R.DX = 0;        //ask for version information (can always call this in Windows)
  Result = CallFryers(&R);
  if (Result != SUCCESS) { //ack serious failure here
    return(Result);        //probably no DLL
  };
  //if AX<0 or DX != 0xFFFF, or AX<0x27 it is bad news. A good dll will pass all this.
  if ((R.AX <= 0) || (int(R.DX & 0xFFFF) != int(0xFFFF)) || ((R.AX & 0x00ff) < 0x27) ) {
    Result = FRYERS_GENERIC_ERROR;   //This error should not happen, but just in case...
    return(Result);                  //empty version string comes back with this error
  }
  Result = R.BX;         //BX has long version number
  if (Vers == NULL) {    //if Vers = null, we are done
    return(Result);      //just return the version number as the result
  }
  Count = R.CX;          //CX has the string length in bytes
  for (i=1; i<=Count; i++) {
    R.AX = 0xFFFD;
    R.DX = 0;            //ask for version string bytes
    R.CX = i;
    CallFryers(&R);
    if (R.AX < 0) {
      *Vers = "Unknown";             //pass back "Unknown" to identify this error
      Result = FRYERS_GENERIC_ERROR; //This error should not happen, but just in case...
      return(Result);
    }
    *Vers += char(R.AL);             //Copy the string byte to the ansistring
  }//endfor(i)
  //if successful, Result has the long version number and Vers has the version string
  return(Result);
};

//=====================================================
//If Fryers is not activated: 0xFFFF cmd returns:
//AX=short version number in hex (eg V5.20 returns as 0x52)
//BX=0
//CX=<reserved>
//DX=0xFFFF=Fryers present, else Fryers not found
//DI=0
//SI=version signon string pointer
//------------------------------------
//if Fryers is activated: 0xFFFF cmd returns:
//AX=short version number in hex (eg V5.20 returns as 0x52)
//BX=Windows Comport Handle. 0=none, nz=handle
//CX=<reserved>
//DX=0xFFFF=Fryers present, else Fryers not found
//SI=version signon string pointer
//DI=BaudClock (only valid for baudrates < 115200 high baudrates return 1).
//[Baudrate=115200/BaudClock]. Use 0xFFFE cmd to get real baudrate
//------------------------------------
//if Fryers is not activated: 0xFFFE cmd returns:
//AX=short version number in hex (eg V5.20 returns as 0x52)
//BX=long version number in binary (eg V5.20 = 520)
//CX=version signon string length in bytes
//DX=0xFFFF=Fryers present, else Fryers not found
//DI=<unchanged>
//SI=<unchanged>
//------------------------------------
//If Fryers is activated: 0xFFFE cmd returns:
//AX=short version number in hex (eg V5.20 returns as 0x52)
//BX=long version number in binary (eg V5.20 = 520)
//CX=version signon string length in bytes
//DX=0xFFFF=Fryers present, else Fryers not found
//DI=<unchanged>
//SI=<unchanged>
//------------------------------------
//if Fryers is not activated: 0xFFFD cmd returns:
//AX=signon version string character at string index in CX
//BX=<reserved>
//CX=Limited to valid signon version string index
//DX=<reserved>
//DI=<reserved>
//SI=<reserved>
//------------------------------------
//If Fryers is activated: 0xFFFD cmd returns:
//AX=signon version string character at string index in CX
//BX=<reserved>
//CX=Limited to valid signon version string index
//DX=<reserved>
//DI=TimeServiceThread handle for the selected comport
//SI=PortServiceThread handle for the selected comport
//====================================================
//Notes: Fryers commands 0xFFFFF, 0xFFFE and 0xFFFD are special
//they do not require a port selection and will not allocate
//a port object when called. They are also re-entrant.
//You can call perform the commands at anytime, anyplace in the code,
//or even in a callback function. The GetFryersVersion()
//code above can be useful to determine which version of Fryers
//is loaded (or if it is not available). The function is always
//operational and will return immediately with the results.
//The Windows Com Port Handle, TimeServiceHandle and PortServiceHandle
//handles are used during debugging to gain access to the internal variables
//The Windows FRYERS32.DLL has always supported all three commands,
//however 0xFFFD had a problem prior to V5.12 and should not be used
//with those early versions. The MSDOS versions prior to V3.00
//only supported 0xFFFF. See the Fryres documentation for details.

//<eof>


