
//Combination INI/Registry managment unit.
//Derived from public domain code.
//current interation as of 27 Sept 2010 by Mike Day
//Requires the Borland Delphi vcl ini/registry libraries.
//------------------------------------------------------------------------------
//You can manage reads and writes to the registry and or INI files
//Just by calling: REG_Value().
//There are disadvantages and advantages to both the registry and the ini file
//methods. Which way you select depends on your needs.
//The registry is fast and centralized so that it can't be lost and the
//user can't easily mess it up. However the registry is difficult to manage
//manually, and can not be easily cleaned up or backed by the user.
//The INI is easy for the user to find and manage (it goes in the program's
//directory), however that also means it is easy for the user to mess it up.
//If the ini file is missing, it will be created on the first write.
//If both ini and registry are used, the code looks in the ini first during a
//read. If the ini file or entry is not found, the code looks in the registry.
//During a write (when both are declared in the call), both are written to.
//The same with the entry delete calls (which are not currently implemented).
//The uninstall only operates on the registry. There is no code here to delete
//an ini file. That is up to the calling code to manage if it needs to do so.
//For some things, you may wish to use the ini and the registry separately.
//Use the separate declarations for such situations. There is nothing wrong with
//managing separate registry and ini stuff. In fact, it can be desirable to
//use an INI for user specific configurations that are tied to a particular
//directory. That way the ini is there in the directory.
//---------------------------------------------------------------------------
//todo:
//At some point. I need to objectize this code and remove the hardcoded keys.
//---------------------------------------------------------------------------
//Note: this code requres the use of Borland's Delphi compiler to access their
//INI/registry stuff. If you are not using the Borland compiler, you will
//either have to remove this code and the stuff that calls it, or
//write your own code that emulates this stuff.
//---------------------------------------------------------------------------

unit IniReg;

interface
uses Windows, classes, SysUtils, Registry, IniFiles;

//#include <Registry.hpp>
//#include <inifiles.hpp>
//#include <stdio.h>
//#include <dir.h>
//#include <stdlib.h>
//#include "IniReg.h"


//---------------------------------------------------------------------------
//0x10xx = read registery entry
//0x11xx = write registery entry
//0x12xx = delete registry entry
//0x20xx = read ini file entry
//0x21xx = write ini file entry
//0x22xx = delete ini file entry
//0x30xx = try reading ini file entry first, then try registry if ini not found
//0x31xx = write both ini file and registry entrys
//0x32xx = delete ini and registry entrys
const READ_REGISTRY_BOOLEAN = $1000;
const READ_REGISTRY_INTEGER = $1001;
const READ_REGISTRY_STRING = $1002;
const WRITE_REGISTRY_BOOLEAN = $1100;
const WRITE_REGISTRY_INTEGER = $1101;
const WRITE_REGISTRY_STRING = $1102;
//const DELETE_REGISTRY_VALUE $1200;
//const DELETE_REGISTRY_KEY $1201;

const READ_INI_BOOLEAN = $2000;
const READ_INI_INTEGER = $2001;
const READ_INI_STRING = $2002;
const WRITE_INI_BOOLEAN = $2100;
const WRITE_INI_INTEGER = $2101;
const WRITE_INI_STRING = $2102;
//const DELETE_INI_VALUE $2280;
//const DELETE_INI_KEY $2281;

const READ_INIREG_BOOLEAN = $3000;
const WRITE_INIREG_BOOLEAN = $3100;
const READ_INIREG_INTEGER = $3001;
const WRITE_INIREG_INTEGER = $3101;
const READ_INIREG_STRING = $3002;
const WRITE_INIREG_STRING = $3102;
//const DELETE_INIREG_VALUE $3200;
//const DELETE_INIREG_KEY $3201;

function REG_RegistryValue(How:integer; var Value; KeyName:string; ValueName:string):boolean;
function REG_RegisterUninstall(DisplayName:string; KeyName:string; UninstallString:string):boolean;
function REG_RemoveUninstall(KeyName:string):boolean;

procedure REG_SetIniFileName(FileName:string);
function REG_OpenIni(Location:string; FileName:string):boolean;
procedure REG_CloseIni;
function REG_IniValue(How:integer; var Value; SectionName:string; ValueName:string):boolean;

//Normally this is the only call you need to make to manage the ini/reg config stuff.
function REG_Value(How:integer; var Value; SectionName:string; ValueName:string):boolean;


implementation


//---------------------------------------------------------------------------
//registry variables
const reg_FryeRegistryKey = 'Frye Electronics';

//The uninstall information always goes here, so says Microsoft
const REG_UninstallKey = 'Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall';

//---------------------------------------------------------------------------
//ini variables
//type pTIniFile = ^TIniFile;
var pFIni : TIniFile = NIL;
var reg_FIniName : string = '';


//=============================================================================
//Registry handling routines
//=============================================================================

//---------------------------------------------------------------------------
//Read or write named integer value from/to the registry
//returns true if value found or write successful, returns false if failed.
//Warning if the value to write is a string, it must be declared as AnsiString.
function REG_RegistryValue(How:integer; var Value; KeyName:string; ValueName:string):boolean;
var Force : boolean;
var Registry:TRegistry;
begin
  Force := false;
  Result := false;
  //TRegistry *Registry = new TRegistry;
  Registry := TRegistry.Create;
  try
    Registry.RootKey := HKEY_LOCAL_MACHINE;
    // False because we do not want to create it if it doesn't exist
    if (Registry.KeyExists('Software')) then
    begin
      Registry.OpenKey('Software',false);
    end
    else
    begin
      Registry.OpenKey('SOFTWARE',false); //try for all caps (from old win system)
    end;
    if ((How = WRITE_REGISTRY_INTEGER)or(How = WRITE_REGISTRY_STRING)) then
    begin
      Force := true;
    end;
    Registry.OpenKey(reg_FryeRegistryKey,Force);
    Registry.OpenKey(KeyName,Force);
    if (How = WRITE_REGISTRY_INTEGER) then
    begin
      Registry.WriteInteger(ValueName, integer(Value));
      Result := true;
    end
    else if (How = READ_REGISTRY_INTEGER) then
    begin
      if (Registry.ValueExists(ValueName)) then
      begin
        integer(Value) := Registry.ReadInteger(ValueName);
        Result := true;
      end
      else
      begin
        integer(Value) := 0;
        Result := false;
      end;
    end
    else if (How = WRITE_REGISTRY_BOOLEAN) then
    begin
      Registry.WriteBool(ValueName, boolean(Value));
      Result := true;
    end
    else if (How = READ_REGISTRY_BOOLEAN) then
    begin
      if (Registry.ValueExists(ValueName)) then
      begin
        boolean(Value) := Registry.ReadBool(ValueName);
        Result := true;
      end
      else
      begin
        boolean(Value) := false;
        Result := false;
      end;
    end
    else if (How = WRITE_REGISTRY_STRING) then
    begin
      Registry.WriteString(ValueName, string(Value));
      Result := true;
    end
    else if (How = READ_REGISTRY_STRING) then
    begin
      if (Registry.ValueExists(ValueName)) then
      begin
        String(Value) := Registry.ReadString(ValueName);
        Result := true;
      end
      else
      begin
        String(Value) := '';
        Result := false;
      end;
    end;
  Except //}catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname or value name not found
    if (How = READ_REGISTRY_INTEGER) then
    begin
      integer(Value) := 0;
    end
    else if (How = READ_REGISTRY_STRING) then
    begin
      String(Value) := '';
    end;
    Result := false;
  end;
  Registry.Free; //delete(Registry);
end;

//---------------------------------------------------------------------------
//This loads the uninstall information in the registry so that the stuff can be
//removed by the standard Windows add/remove sequence.
function REG_RegisterUninstall(DisplayName:string; KeyName:string; UninstallString:string):boolean;
var Registry:TRegistry;
begin
  //TRegistry *Registry = new TRegistry;
  Registry := TRegistry.Create;
  try
    Registry.RootKey := HKEY_LOCAL_MACHINE;
    //False because we do not want to create it if it doesn't exist
    Registry.OpenKey(REG_UninstallKey,false);
    Registry.OpenKey(KeyName,true); //REG_FlashUpdateKey,true);
    Registry.WriteString('DisplayName', DisplayName);
    Registry.WriteString('UnInstallString', UninstallString);
    Result := true;
  Except //}catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname not found or write failed
    Result := false;
  end;
  Registry.free; //delete(Registry);
end;

//---------------------------------------------------------------------------
//This unloads the uninstall information from the registry after we're done
function REG_RemoveUninstall(KeyName:string):boolean;
var Registry:TRegistry;
begin
//  TRegistry *Registry = new TRegistry;
  Registry := TRegistry.Create;
  try
    Registry.RootKey := HKEY_LOCAL_MACHINE;
    //False because we do not want to create it if it doesn't exist
    Registry.OpenKey(REG_UninstallKey,false);
    Registry.DeleteKey(KeyName); //REG_FlashUpdateKey);
    //Registry->WriteString("DisplayName", DisplayName);
    //Registry->WriteString("UnInstallString", UninstallString);
    Result := true;
  Except //}catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname not found or write failed
    Result := false;
  end;
  Registry.free; //delete(Registry);
end;

//=============================================================================
//Ini file handling routines
//=============================================================================

function REG_OpenIni(Location:string; FileName:string):boolean;
var Where : string;
begin
  Where := Location+FileName;
  try
    pFIni := TIniFile.Create(Where);
    Result := true;
    Exit;
  Except //}catch (Exception &exception) {
    //pFIni := NULL;
    pFIni.Free;
  end;
  Result := false;
end;


procedure REG_CloseIni;
begin
  //if (pFIni <> NIL) then
  //begin
    pFIni.Free;
  //end;
  //pFIni := NULL;
end;

//this sets the name of the INI filename to use
//if the filename is empty, the current program name will be used with an INI tag.
//if the INI file is already open, any filename change is ignored.
procedure REG_SetIniFileName(FileName:string);
begin
  reg_FIniName := FileName;
end;

//----------------------------------------------------------------------------
//hack to add missing function in bcb1
function reg_ValueExists(SectionName:string; ValueName:string):boolean;
var TempList : TStringList;
begin
  //TStringList *TempList = new TStringList; // declare the list
  TempList := TStringList.Create;
  try //use the string list
    pFIni.ReadSection(SectionName,TempList);
    if (TempList.IndexOf(ValueName) > -1) then
      Result := true
    else Result := false;
  Except //}catch (Exception &exception){
    Result := false;
  end;
  TempList.free; // destroy the list object
end;


//---------------------------------------------------------------------------
//Read or write named integer value from/to the ini file
//returns true if value found or write successful, returns false if failed.
//Warning if the value to write is a string, it must be declared as char.
function REG_IniValue(How:integer; var Value; SectionName:string; ValueName:string):boolean;
var aFilePathName:string;
var aProgramPath:string;
var aProgramName:string;
var aTemp:string;
begin
  Result := false;
  try
    if (pFIni = NIL) then //if not open yet, use default file location
    begin
      aFilePathName := ExpandFileName(ParamStr(0));
      aProgramPath := ExtractFilePath(aFilePathName);
      if (reg_FIniName = '') then
      begin
        aProgramName := ExtractFileName(aFilePathName);
        aTemp := ChangeFileExt(aProgramName,'.INI');
        if (aTemp = '') or (aTemp = '.INI') then
        begin
          Result := false; //could not create name
          Exit;
        end;
        reg_FIniName := aTemp;
      end;
      if (REG_OpenIni(aProgramPath,reg_FIniName) = false) then
      begin
        Result := false; //couldn't open the file
        Exit;
      end;
    end;

    if (How = WRITE_INI_INTEGER) then
    begin
      pFIni.WriteInteger(SectionName,ValueName, integer(Value));
      Result := true;
    end
    else if (How = READ_INI_INTEGER) then
    begin
      if (reg_ValueExists(SectionName,ValueName)) then
      begin
        integer(Value) := pFIni.ReadInteger(SectionName,ValueName,integer(Value));
        Result := true;
      end
      else
      begin
        integer(Value) := 0;
        Result := false;
      end;
    end
    else if (How = WRITE_INI_BOOLEAN) then
    begin
      pFIni.WriteBool(SectionName,ValueName, boolean(Value));
      Result := true;
    end
    else if (How = READ_INI_BOOLEAN) then
    begin
      if (reg_ValueExists(SectionName,ValueName)) then
      begin
        boolean(Value) := pFIni.ReadBool(SectionName,ValueName,boolean(Value));
        Result := true;
      end
      else
      begin
        boolean(Value) := false;
        Result := false;
      end;
    end
    else if (How = WRITE_INI_STRING) then
    begin
      pFIni.WriteString(SectionName,ValueName, String(Value));
      Result := true;
    end
    else if (How = READ_INI_STRING) then
    begin
      if (reg_ValueExists(SectionName,ValueName)) then
      begin
        String(Value) := pFIni.ReadString(SectionName,ValueName,String(Value));
        Result := true;
      end
      else
      begin
        String(Value) := '';
        Result := false;
      end;
    end
  Except //catch (Exception &exception)
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname or value name not found
    if (How = READ_INI_INTEGER) then
    begin
      integer(Value) := 0;
    end
    else if (How = READ_INI_STRING) then
    begin
      String(Value) := '';
    end;
    Result := false;
  end;
end;

//---------------------------------------------------------------------------
//This figures out what to do from the How value
function REG_Value(How:integer; var Value; SectionName:string; ValueName:string):boolean;
begin
  if ((How and $f000) = $1000) then //0x1=reg
  begin
    Result := REG_RegistryValue(How, Value, SectionName, ValueName);
    Exit;
  end
  else if ((How and $f000) = $2000) then //0x2=ini
  begin
    Result := REG_IniValue(How, Value, SectionName, ValueName);
    Exit;
  end
  else if ((How and $f000) = $3000) then //0x3=both
  begin
    if ((How and $0f00) = 0) then //0 mask = read
    begin
      Result := REG_IniValue((How and $2fff), Value, SectionName, ValueName);
      if (Result = true) then Exit;  //if ini found, we are done, else try for registry
      Result := REG_RegistryValue((How and $1fff), Value, SectionName, ValueName);
      Exit;
    end
    else  //others are writes or deletes so do both
    begin
      Result := REG_IniValue((How and $2fff), Value, SectionName, ValueName);
      if (REG_RegistryValue((How and $1fff), Value, SectionName, ValueName) = false) then
      begin
        Result := false;
      end;
      Exit;  //if either one fails, return the failure.
    end;//endif(How=0x0f)
  end;//endif(How=0xf0)
  Result := false;
end;


end.
