//Combination INI/Registry managment unit.
//Derived from public domain code.
//current interation as of 10 June 2003 by Mike Day
//Requires the Borland BCB vcl ini/registry libraries.
//------------------------------------------------------------------------------
//You can manage reads and writes to the registry and or INI files
//Just by calling: REG_Value().
//There are disadvantages and advantages to both the registry and the ini file
//methods. Which way you select depends on your needs.
//The registry is fast and centralized so that it can't be lost and the
//user can't easily mess it up. However the registry is difficult to manage
//manually, and can not be easily cleaned up or backed by the user.
//The INI is easy for the user to find and manage (it goes in the program's
//directory), however that also means it is easy for the user to mess it up.
//If the ini file is missing, it will be created on the first write.
//If both ini and registry are used, the code looks in the ini first during a
//read. If the ini file or entry is not found, the code looks in the registry.
//During a write (when both are declared in the call), both are written to.
//The same with the entry delete calls (which are not currently implemented).
//The uninstall only operates on the registry. There is no code here to delete
//an ini file. That is up to the calling code to manage if it needs to do so.
//For some things, you may wish to use the ini and the registry separately.
//Use the separate declarations for such situations. There is nothing wrong with
//managing separate registry and ini stuff. In fact, it can be desirable to
//use an INI for user specific configurations that are tied to a particular
//directory. That way the ini is there in the directory.
//---------------------------------------------------------------------------
//todo:
//At some point. I need to objectize this code and remove the hardcoded keys.
//---------------------------------------------------------------------------
//Note: this code requres the use of Borland's BCB compiler to access their
//INI/registry stuff. If you are not using the Borland compiler, you will
//either have to remove this code and the stuff that calls it, or
//write your own code that emulates this stuff.
//---------------------------------------------------------------------------

#include <vcl\vcl.h>
#pragma hdrstop

#include <Registry.hpp>
#include <inifiles.hpp>
#include <stdio.h>
#include <dir.h>
#include <stdlib.h>
#include "IniReg.h"

//---------------------------------------------------------------------------
//registry variables
AnsiString reg_FryeRegistryKey = "Frye Electronics";

//The uninstall information always goes here, so says Microsoft
AnsiString REG_UninstallKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";

//---------------------------------------------------------------------------
//ini variables
TIniFile* pFIni = NULL;
AnsiString reg_FIniName = "";

//---------------------------------------------
//Changes the extent of a FileName (can be a fully qualified name)
//if DestName == null, or FileName == null, returns nothing.
//returns a pointer to DestName as the function result.
char* ChangeExt(char* DestName, char* FileName, char* NewExt) {
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];

  if ((DestName == NULL)||(FileName == NULL)) return(NULL);
  fnsplit(FileName,drive,dir,file,ext);
  fnmerge(DestName,drive,dir,file,NewExt);
  return(DestName);
};

//=============================================================================
//Registry handling routines
//=============================================================================

//---------------------------------------------------------------------------
//Read or write named integer value from/to the registry
//returns true if value found or write successful, returns false if failed.
//Warning if the value to write is a string, it must be declared as AnsiString.
bool REG_RegistryValue(int How, void* Value, AnsiString KeyName, AnsiString ValueName) {
  int Result;
  bool Force = false;
  TRegistry *Registry = new TRegistry;
  try{
    Registry->RootKey = HKEY_LOCAL_MACHINE;
    // False because we do not want to create it if it doesn't exist
    if (Registry->KeyExists("Software")) Registry->OpenKey("Software",false);
    else Registry->OpenKey("SOFTWARE",false); //try for all caps (from old win system)
    if ((How == WRITE_REGISTRY_INTEGER)||(How == WRITE_REGISTRY_STRING)) Force = true;
    Registry->OpenKey(reg_FryeRegistryKey,Force);
    Registry->OpenKey(KeyName,Force);
    if (How == WRITE_REGISTRY_INTEGER) {
      Registry->WriteInteger(ValueName, *(int*)Value);
      Result = true;
    }else if (How == READ_REGISTRY_INTEGER) {
      if (Registry->ValueExists(ValueName)) {
        *(int*)Value = Registry->ReadInteger(ValueName);
        Result = true;
      }else{
        *(int*)Value = 0;
        Result = false;
      }
    }else if (How == WRITE_REGISTRY_BOOLEAN) {
      Registry->WriteBool(ValueName, *(bool*)Value);
      Result = true;
    }else if (How == READ_REGISTRY_BOOLEAN) {
      if (Registry->ValueExists(ValueName)) {
        *(bool*)Value = Registry->ReadBool(ValueName);
        Result = true;
      }else{
        *(bool*)Value = 0;
        Result = false;
      }
    }else if (How == WRITE_REGISTRY_STRING) {
      Registry->WriteString(ValueName, *(AnsiString*)Value);
      Result = true;
    }else if (How == READ_REGISTRY_STRING) {
      if (Registry->ValueExists(ValueName)) {
        *(AnsiString*)Value = Registry->ReadString(ValueName);
        Result = true;
      }else{
        *(AnsiString*)Value = "";
        Result = false;
      }
    }
  }catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname or value name not found
    if (How == READ_REGISTRY_INTEGER) *(int*)Value = 0;
    else if (How == READ_REGISTRY_STRING) *(AnsiString*)Value = "";
    Result = false;
  }
  delete(Registry);
  return(Result);
};

//---------------------------------------------------------------------------
//This loads the uninstall information in the registry so that the stuff can be
//removed by the standard Windows add/remove sequence.
bool REG_RegisterUninstall(AnsiString DisplayName, AnsiString KeyName, AnsiString UninstallString) {
  int Result;
  TRegistry *Registry = new TRegistry;
  try{
    Registry->RootKey = HKEY_LOCAL_MACHINE;
    //False because we do not want to create it if it doesn't exist
    Registry->OpenKey(REG_UninstallKey,false);
    Registry->OpenKey(KeyName,true); //REG_FlashUpdateKey,true);
    Registry->WriteString("DisplayName", DisplayName);
    Registry->WriteString("UnInstallString", UninstallString);
    Result = true;
  }catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname not found or write failed
    Result = false;
  }
  delete(Registry);
  return(Result);
};

//---------------------------------------------------------------------------
//This unloads the uninstall information from the registry after we're done
bool REG_RemoveUninstall(AnsiString KeyName) {
  int Result;
  TRegistry *Registry = new TRegistry;
  try{
    Registry->RootKey = HKEY_LOCAL_MACHINE;
    //False because we do not want to create it if it doesn't exist
    Registry->OpenKey(REG_UninstallKey,false);
    Registry->DeleteKey(KeyName); //REG_FlashUpdateKey);
    //Registry->WriteString("DisplayName", DisplayName);
    //Registry->WriteString("UnInstallString", UninstallString);
    Result = true;
  }catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname not found or write failed
    Result = false;
  }
  delete(Registry);
  return(Result);
};

//=============================================================================
//Ini file handling routines
//=============================================================================

bool REG_OpenIni(AnsiString Location, AnsiString FileName) {
  AnsiString Where = Location+FileName;
  try {
    pFIni = new TIniFile(Where);
    return(true);
  }catch (Exception &exception) {
    pFIni = NULL;
  }
  return(false);
};

void REG_CloseIni(void) {
  if (pFIni != NULL)
    delete pFIni;
  pFIni = NULL;
};

//this sets the name of the INI filename to use
//if the filename is empty, the current program name will be used with an INI tag.
//if the INI file is already open, any filename change is ignored.
void REG_SetIniFileName(AnsiString FileName) {
  reg_FIniName = FileName;
};

//----------------------------------------------------------------------------
//hack to add missing function in bcb1
bool reg_ValueExists(AnsiString SectionName, AnsiString ValueName) {
  bool Result;
  TStringList *TempList = new TStringList; // declare the list
  try{ //use the string list
    pFIni->ReadSection(SectionName,TempList);
    if (TempList->IndexOf(ValueName) > -1) Result = true;
    else Result = false;
  }catch (Exception &exception){
    Result = false;
  }
  delete TempList; // destroy the list object
  return(Result);
};


//---------------------------------------------------------------------------
//Read or write named integer value from/to the ini file
//returns true if value found or write successful, returns false if failed.
//Warning if the value to write is a string, it must be declared as char.
bool REG_IniValue(int How, void* Value, AnsiString SectionName, AnsiString ValueName) {
  AnsiString aFilePathName;
  AnsiString aProgramPath;
  AnsiString aProgramName;
  char sTemp[9999];
  bool Result;
  try{
    if (pFIni == NULL) { //if not open yet, use default file location
      aFilePathName = ExpandFileName(ParamStr(0));
      aProgramPath = ExtractFilePath(aFilePathName);
      if (reg_FIniName == "") {
        aProgramName = ExtractFileName(aFilePathName);
        if (ChangeExt(sTemp,aProgramName.c_str(),".INI") == NULL)
          return(false); //could not create name
        reg_FIniName = sTemp;
      }
      if (REG_OpenIni(aProgramPath,reg_FIniName) == false)
        return(false); //couldn't open the file
    }

    if (How == WRITE_INI_INTEGER) {
      pFIni->WriteInteger(SectionName,ValueName, *(int*)Value);
      Result = true;
    }else if (How == READ_INI_INTEGER) {
      if (reg_ValueExists(SectionName,ValueName)) {
        *(int*)Value = pFIni->ReadInteger(SectionName,ValueName,*(int*)Value);
        Result = true;
      }else{
        *(int*)Value = 0;
        Result = false;
      }
    }else if (How == WRITE_INI_BOOLEAN) {
      pFIni->WriteBool(SectionName,ValueName, *(bool*)Value);
      Result = true;
    }else if (How == READ_INI_BOOLEAN) {
      if (reg_ValueExists(SectionName,ValueName)) {
        *(bool*)Value = pFIni->ReadBool(SectionName,ValueName,*(bool*)Value);
        Result = true;
      }else{
        *(bool*)Value = 0;
        Result = false;
      }
    }else if (How == WRITE_INI_STRING) {
      pFIni->WriteString(SectionName,ValueName, *(AnsiString*)Value);
      Result = true;
    }else if (How == READ_INI_STRING) {
      if (reg_ValueExists(SectionName,ValueName)) {
        *(AnsiString*)Value = pFIni->ReadString(SectionName,ValueName,*(AnsiString*)Value);
        Result = true;
      }else{
        *(AnsiString*)Value = "";
        Result = false;
      }
    }
  }catch (Exception &exception) {
    //Application->ShowException(&exception); //don't show exception,
    //just quietly exit if keyname or value name not found
    if (How == READ_INI_INTEGER) *(int*)Value = 0;
    else if (How == READ_INI_STRING) *(AnsiString*)Value = "";
    Result = false;
  }
  return(Result);
};

//---------------------------------------------------------------------------
//This figures out what to do from the How value
bool REG_Value(int How, void* Value, AnsiString SectionName, AnsiString ValueName) {
  bool Result;
  if ((How & 0xf000) == 0x1000){ //0x1=reg
    return(REG_RegistryValue(How, Value, SectionName, ValueName));
  }else if ((How & 0xf000) == 0x2000){ //0x2=ini
    return(REG_IniValue(How, Value, SectionName, ValueName));
  }else if ((How & 0xf000) == 0x3000){ //0x3=both
    if ((How & 0x0f00) == 0) { //0 mask = read
      Result = REG_IniValue((How & 0x2fff), Value, SectionName, ValueName);
      if (Result == true) return(true);  //if ini found, we are done, else try for registry
      return(REG_RegistryValue((How & 0x1fff), Value, SectionName, ValueName));
    }else{ //others are writes or deletes so do both
      Result = REG_IniValue((How & 0x2fff), Value, SectionName, ValueName);
      if (REG_RegistryValue((How & 0x1fff), Value, SectionName, ValueName) == false)
        return(false);
      return(Result);  //if either one fails, return the failure.
    }//endif(How=0x0f)
  }//endif(How=0xf0)
  return(false);
};

//<eof>


