//Combination INI/Registry managment unit.
//Derived from public domain code.
//current interation as of 10 June 2003 by Mike Day
//---------------------------------------------------------------------------
#ifndef IniRegH
#define IniRegH
//---------------------------------------------------------------------------
//0x10xx = read registery entry
//0x11xx = write registery entry
//0x12xx = delete registry entry
//0x20xx = read ini file entry
//0x21xx = write ini file entry
//0x22xx = delete ini file entry
//0x30xx = try reading ini file entry first, then try registry if ini not found
//0x31xx = write both ini file and registry entrys
//0x32xx = delete ini and registry entrys
#define READ_REGISTRY_BOOLEAN 0x1000
#define READ_REGISTRY_INTEGER 0x1001
#define READ_REGISTRY_STRING 0x1002
#define WRITE_REGISTRY_BOOLEAN 0x1100
#define WRITE_REGISTRY_INTEGER 0x1101
#define WRITE_REGISTRY_STRING 0x1102
//#define DELETE_REGISTRY_VALUE 0x1200
//#define DELETE_REGISTRY_KEY 0x1201

#define READ_INI_BOOLEAN 0x2000
#define READ_INI_INTEGER 0x2001
#define READ_INI_STRING 0x2002
#define WRITE_INI_BOOLEAN 0x2100
#define WRITE_INI_INTEGER 0x2101
#define WRITE_INI_STRING 0x2102
//#define DELETE_INI_VALUE 0x2280
//#define DELETE_INI_KEY 0x2281

#define READ_INIREG_BOOLEAN 0x3000
#define WRITE_INIREG_BOOLEAN 0x3100
#define READ_INIREG_INTEGER 0x3001
#define WRITE_INIREG_INTEGER 0x3101
#define READ_INIREG_STRING 0x3002
#define WRITE_INIREG_STRING 0x3102
//#define DELETE_INIREG_VALUE 0x3200
//#define DELETE_INIREG_KEY 0x3201

extern bool REG_RegistryValue(int How, void* Value, AnsiString KeyName, AnsiString ValueName);
extern bool REG_RegisterUninstall(AnsiString DisplayName, AnsiString KeyName, AnsiString UninstallString);
extern bool REG_RemoveUninstall(AnsiString KeyName);

extern void REG_SetIniFileName(AnsiString FileName);
extern bool REG_OpenIni(AnsiString Location, AnsiString FileName);
extern void REG_CloseIni(void);
extern bool REG_IniValue(int How, void* Value, AnsiString SectionName, AnsiString ValueName);

//Normally this is the only call you need to make to manage the ini/reg config stuff.
extern bool REG_Value(int How, void* Value, AnsiString SectionName, AnsiString ValueName);

#endif
