{ RunUnit - Version 5.22  as of 26 Jul 2006 }
{ Copyright 1989,2006 Frye Electronics, Inc. }
{ RunUnit is used in conjunction with FBAT32}
{ to read FIPP commands from the command line and convert }
{ them to real FIPP commands to send to the FippUnit }
{ 10 Oct 2010 - converted to use FryeCom DLL }
{ also changed program name to FBatCom.exe }

unit RunUnit;
interface

uses SysUtils,MMsystem,FryeDefs,FippDefs,IniReg,Fryers,FComDefs,FBatDefs,FCErrMsg,FryeTools,FryeComD,FippCore,FryeStr,LabelUnit;
{$APPTYPE CONSOLE}


procedure RunProgram;

implementation

const FBatInitKey : string = 'FBAT'; //INI file and Registry key for this program
                                     //see IniReg.cpp for more information

var Pnum : byte;
var AllSent : boolean;
var Tm,Start : integer;
var foname : Str255;
var CmdSendBufferEnd : integer;
var CmdSendBufferIndex : integer;
var CmdSendBuffer : array[0..12000] of word;
var FryeBitmap : FIPP_tFryeBitmap;
var StdLabelData  : FIPP_tStdLabelArray;   {2d pchar array to place label data in}
var ExtLabelData  : FIPP_tExtLabelArray; //ExtLabelDataType; {2d pchar array to place ext label data in}
var ErrorType : integer;

{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  //if (ErrorCode > 0) and (ErrorCode <> NoCmd) then
    //writeln(ErrorMsg(ErrorCode));
  ExitCode := ErrorCode;
  if (Fipp = NIL) then Exit;
  if Fipp.PortInitialized then
    Fipp.ClosePort();
end;

{------------------------------------------------}
procedure GetCmdLineData;
var S:str255;
var i:integer;
begin
    if ParamCount-Pnum < Fipp.CmdArray.Size then {assume zero if bad cnt}
    begin
      writeln('Error: Bad command count');
      ErrorCode := FCE_CommandFail;       {urg, not enough data provided}
      Halt(ErrorCode);
    end;
    if Fipp.CmdArray.Size > 0 then             {if more than count of zero}
    begin                                       {get the data passed}
      for i := 1 to Fipp.CmdArray.Size do
      begin
        S := ParamStr(Pnum+i);
        if not(StrToWord(S,WORD(Fipp.CmdArray.Raw[i+1]))) then
        begin
          writeln('Error: Bad data');
          ErrorCode := FCE_CommandFail;      {urg, not enough or invalid}
          Halt(ErrorCode);                            {data provided}
        end;
      end;
    end;
end;


{------------------------------------------------}
procedure GetCommandFile(what:str255);
var i : integer;
var f : text;
var Stmp : Str255;
begin
  i := 0;                                 {get the data from a file?}
  if FileSearch(What,'') = '' then
  begin
    writeln('File not found: ',What);
    ErrorCode := FCE_NoFileError;                    {rats, didn't find it}
    Halt(ErrorCode);
  end;

    assign(f,What);
    reset(f);
    while not(eof(f)) do
    begin
      readln(f,Stmp);
      if (Stmp <> '') or (Stmp[1] = '#') then                           {ignore blank lines}
      begin
        if not(StrToWord(Stmp,CmdSendBuffer[i])) then    {word from file}
        begin
          writeln('Error reading file: ',What);
          ErrorCode := FCE_FileReadError;                {rats, didn't find it}
          Halt(ErrorCode);
        end;
        inc(i);
        if i > 9999 then                              {run out of room?}
        begin
          writeln('Overflow reading file: ',What);
          ErrorCode := FCE_FileOverflowError;                   {rats, didn't work}
          Halt(ErrorCode);
        end;
      end;
    end;
  CmdSendBufferIndex := 0; {reset index to zero}
  CmdSendBufferEnd := i; {save last index}
end;


{----------------------------------------------------------}
{open the rs232 port for operation}
procedure OpenPort;
var Result : integer;
var ComPort : integer;
var ThisPort : integer;
begin
  //if no com port specified, use auto port seek
  if (UsePort = 0) then
  begin
    PortMode := PortMode or FCOM_USE_PORT_SEEK;

    //start auto seek with the last known com port used
    if (REG_RegistryValue(READ_REGISTRY_INTEGER,UsePort,FBatInitKey,'COM_PORT') = false) then
    begin
      UsePort := 1; //if registry entry not found, try com1
    end;
    ComPort := UsePort - 1;
    if (ComPort < 0) then ComPort := 0;

    if (UseBaud = 0) then
    begin
      //Start with the last known baudrate used if none given
      if (REG_RegistryValue(READ_REGISTRY_INTEGER,UseBaud,FBatInitKey,'BAUDRATE') = false) then
      begin
        UseBaud := 9600;
      end;
    end;
  end
  else
  begin
    ComPort := UsePort - 1;
  end;
  Result := Fipp.InitPort(PortMode, ComPort, -1, -1, FIPP_SOFT_RETRY, UseBaud, NIL);
  if (Result <> SUCCESS) then
  begin
    writeln('Packet com port not open');
    ErrorCode := FCE_NoPort;                           {ick, no can talk}
    Halt(ErrorCode);
  end;

  ThisPort := Fipp.ThisComPort+1;    //if port opened successfully, save it in registry
  REG_RegistryValue(WRITE_REGISTRY_INTEGER,ThisPort,FBatInitKey,'COM_PORT');
  UseBaud := Fipp.ActiveBaudrate;
  REG_RegistryValue(WRITE_REGISTRY_INTEGER,UseBaud,FBatInitKey,'BAUDRATE');

end;

procedure ClosePort;
begin
  Fipp.ClosePort();
end;


{------------------------------------------------}
{process any options that are given}
procedure GetOptions;
var S:str255;
var Stmp : Str255;
var Err:integer;
var Tmp : integer;
begin
   while true do
   begin
      if PNum > ParamCount then Exit;
      Stmp := ParamStr(Pnum);
      if (Stmp[1] <> '-') then Exit;

      //valid com port is 0->99
      if (upcase(Stmp[2]) = 'C') then   {com port given?}
      begin
        if (Stmp[3] >= '0') and (Stmp[3] <= '9') then
        begin
          UsePort := ord(Stmp[3]) and $f;
          if (Stmp[4] >= '0') and (Stmp[4] <= '9') then
          begin
            Tmp := (ord(Stmp[4]) and $f) * 10;
            UsePort := UsePort + Tmp;
          end;
        end
        else
        begin
          writeln('Invalid port number selected.');
          ErrorCode := FCE_BadConfig;
          Halt(ErrorCode);
        end;
      end;

      if (upcase(Stmp[2]) = 'B') then   {baudrate given?}
      begin
        S := Stmp;
        delete(S,1,2);
        while (length(S) > 0) and (S[1] < ' ') do delete(S,1,1);
        if not(StrToLong(S,UseBaud)) then
        begin
          writeln('Invalid baudrate given.');
          ErrorCode := FCE_BadConfig;
          Halt(ErrorCode);
        end
      end;

      if (upcase(Stmp[2]) = 'T') then   {poll timeout given?}
      begin
        S := Stmp;
        delete(S,1,2);
        while (length(S) > 0) and (S[1] < ' ') do delete(S,1,1);
        if not(StrToWord(S,UseNoPollTimeout)) then
        begin
          writeln('Invalid Poll timeout given.');
          ErrorCode := FCE_BadConfig;
          Halt(ErrorCode);
        end;
      end;

      if (upcase(Stmp[2]) = 'F') then   {output filename given?}
      begin
        inc(PNum);
        if PNum > ParamCount then
        begin
          writeln('Invalid or no output filename given.');
          ErrorCode := FCE_BadConfig;
          Halt(ErrorCode);
        end;
        foname := ParamStr(Pnum);       {yes, so pick it up}
      end;

      if (upcase(Stmp[2]) = 'N') then   {integers?}
      begin
        UseShowInt := true;
      end;

      if (upcase(Stmp[2]) = 'L') then   {delimit?}
      begin
        UseDelimit := true;
      end;

      if (upcase(Stmp[2]) = 'Q') then   {quiet?}
      begin
        UseQuiet := true;
      end;

      if (upcase(Stmp[2]) = 'D') then   {debug?}
      begin
        UseDebugMode := true;
      end;

      if (upcase(Stmp[2]) = 'A') then   {disallow ack?}
      begin
        UseNoAck := true;
      end;

      inc(Pnum);
   end;
end;

{---------------------------------------------------------------}
{Save the output data (data that was sent) - for debug mode use}
procedure SaveOutput;
var ii:word;
    fo:text;
begin
  assign(fo,'out.raw');
  rewrite(fo);
  for ii := 0 to Fipp.CmdArray.Raw[1]+3 do
  begin
    writeln(fo,Fipp.CmdArray.Raw[ii]);
  end;
  close(fo);
end;


{---------------------------------------------------------------}
{get command to send}
{note: this is dinosaur code that originally just copied a cmd line to the}
{sendarray to be sent later. It did not handle multi-cmd files.}
{I fixed this by just copying the cmd read into the file buffer so that}
{it just looks like there was a file read with a single command in it}
{The sendarray here is just used as a temporary buffer.}
function GetCommand:integer;
var Stmp : Str255;
var i:integer;
var CmdWord : WORD;
var CmdSize : WORD;
begin
    GetCommand := FCE_UnknownError; {assume failure}
    Stmp := ParamStr(Pnum);
    if not(StrToWord(Stmp,CmdWord)) then   {get the cmd}
    begin
      GetCommandFile(Stmp);
      Exit;
    end
    else
    begin
      Fipp.CmdArray.Cmd := CmdWord;
      if ParamCount > Pnum then                   {any data parms given?}
      begin
        inc(Pnum);
        Stmp := ParamStr(Pnum);
        if Fipp.CmdArray.Cmd = 96 then {special case hack for bitmap upload}
        begin
          if not(StrToWord(Stmp,BitMapType)) then Exit;  {get the type of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(StrToWord(Stmp,BitMapXpos)) then Exit;  {get the Xpos of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(StrToWord(Stmp,BitMapYpos)) then Exit;  {get the Ypos of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(StrToWord(Stmp,BitMapDest)) then Exit;  {get the dest page of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          Result := LU_GetBitmapFile(StmP);                     {get label bitmap}
          if (Result <> SUCCESS) then
          begin
            ErrorCode := Result;                    {rats, didn't find it}
            Halt(ErrorCode);
          end;
          //BuildBitmapSendArray;
          LU_ConvertBitmapToSend(FryeBitmap);
          move(FryeBitmap,Fipp.CmdArray.Raw,sizeof(FryeBitmap));
          GetCommand := SUCCESS;
        end
        else if StrToWord(Stmp,CmdSize) then {valid cmd count number?}
        begin
          Fipp.CmdArray.Size := CmdSize;
          GetCmdLineData;                               {yes, so get data}
        end
        else
        begin
          Result := LU_GetLabelFile(Fipp.CmdArray.Cmd,Stmp);  {else, try for label file}
          if (Result <> SUCCESS) then
          begin
            ErrorCode := Result;
            Halt(ErrorCode);
          end;
          if Fipp.CmdArray.Cmd = 6 then
          begin
            FS_StringToPchar(StdLabelData,LabelText,FIPP_NUM_STD_LABEL_CHAR); {convert it to a 2D pchar array}
            LU_ConvertLabelToSend(FIPP_NUM_STD_LABEL_CHAR,StdLabelData,@Fipp.CmdArray);    {stuff it into the cmd send array}
            Fipp.CmdArray.Size := FIPP_NUM_STD_LABEL_CHAR div 2; {set number of words to send}
          end
          else if Fipp.CmdArray.Cmd = 66 then
          begin
            FS_StringToPchar(ExtLabelData,CustomLab,FIPP_REG_EXT_LABEL_SIZEB); {convert it to a 2D pchar array}
            LU_ConvertLabelToSend(FIPP_REG_EXT_LABEL_SIZEB,ExtLabelData,@Fipp.CmdArray);    {stuff it into the cmd send array}
            Fipp.CmdArray.Size := FIPP_REG_EXT_LABEL_SIZEB div 2; {set the label data size in words}
          end
          else Fipp.CmdArray.Size := 0;                         {default is no data}
        end;
        GetCommand := SUCCESS;
      end
      else
      begin
        if Fipp.CmdArray.Cmd = 6 then
        begin
          LU_EnterStdLabel(LabelText); {get old style label}
          FS_StringToPchar(StdLabelData,LabelText,FIPP_NUM_STD_LABEL_CHAR); {convert it to a 2D pchar array}
          LU_ConvertLabelToSend(FIPP_NUM_STD_LABEL_CHAR,StdLabelData,@Fipp.CmdArray);    {stuff it into the cmd send array}
          Fipp.CmdArray.Size := FIPP_NUM_STD_LABEL_CHAR div 2; {set number of words to send}
        end
        else if Fipp.CmdArray.Cmd = 66 then
        begin
          LU_EnterExtLabel(CustomLab); {get new style label}
          FS_StringToPchar(ExtLabelData,CustomLab,FIPP_REG_EXT_LABEL_SIZEB); {convert it to a 2D pchar array}
          LU_ConvertLabelToSend(FIPP_REG_EXT_LABEL_SIZEB,ExtLabelData,@Fipp.CmdArray);    {stuff it into the cmd send array}
          Fipp.CmdArray.Size := FIPP_REG_EXT_LABEL_SIZEB div 2; {set the label data size in words}
        end
        else Fipp.CmdArray.Size := 0;                         {default is no data}
        GetCommand := SUCCESS; {always successful label return}
      end;
      {now copy the command to the send buffer}
      CmdSendBufferEnd := Fipp.CmdArray.Raw[1] + 1;
      for i:=0 to CmdSendBufferEnd do
      begin
        CmdSendBuffer[i] := Fipp.CmdArray.Raw[i];
      end;
      Exit;
    end;

end;


{------------------------------------------------------------------}
{copy a command from send buffer to the sendarray in preperation to send it}
function GetCmdToSend:boolean;
var i,k : integer;
var CmdLength : integer;
begin
  i := 0;
  GetCmdToSend := false; {assume failure}
  if CmdSendBufferIndex > CmdSendbufferEnd then Exit;
  Fipp.CmdArray.Raw[i] := CmdSendBuffer[CmdSendBufferIndex];
  CmdSendBufferIndex := CmdSendBufferIndex + 1;
  i := i + 1;
  if CmdSendBufferIndex > CmdSendbufferEnd then Exit;
  CmdLength := CmdSendBuffer[CmdSendBufferIndex];

  for k:= 0 to CmdLength do
  begin
    if CmdSendBufferIndex > CmdSendbufferEnd then Exit;
    Fipp.CmdArray.Raw[i] := CmdSendBuffer[CmdSendBufferIndex];
    CmdSendBufferIndex := CmdSendBufferIndex + 1;
    i := i + 1;
  end;
  GetCmdToSend := true; {got a successful cmd}
end;

{------------------------------------------------------------------}
{send the command to outside world}
procedure SendIt;
var Result : integer;
var i,n,t : integer;
var x : longint;
var f : text;
//var sMsg : tachar;
//var pMsg : string;
var sMsg : string;
begin
    //pMsg := @sMsg;
    {special case fipp cmd is local delay}
    if Fipp.CmdArray.Cmd = 128 then
    begin
      t := Fipp.CmdArray.Data[0];
      if not UseQuiet then write(' Delay:',t,',');
      FT_Delay(t);
      Exit;
    end;

    {Now Send the command}
    {uses ack ok because we will check on it here instead}
    Result := Fipp.DoCmd(FCOM_ACK_OK,UseNoPollTimeout,Fipp.CmdArray,Fipp.RspArray,NIL);
    if (Result <> 0) then
    begin
      Fipp.UpdatePortStatus();
      ErrorCode := FEM_GetErrorMsg(Result, true, ErrorType, sMsg);
      writeln(sMsg);
      Halt(ErrorCode);
    end;

    if Fipp.CmdArray.Cmd = $7fff then
    begin
      Exit; {no response if quick terminate command}
    end;

    {check on the response from the command}
    if ((Fipp.RspArray.Cmd and $7fff) <> Fipp.CmdArray.Cmd) and  {we expect a data response,}
       (Fipp.RspArray.Cmd <> FCOM_ACK) then             {or an ack response}
    begin
      if Fipp.RspArray.Cmd = FCOM_ILL then
      begin
        writeln('Error: Illegal Command:',Fipp.CmdArray.Cmd);
        ErrorCode := FCE_IllegalPacket;                  {anything else is bad}
        Halt(ErrorCode);
      end
      else
      begin
        writeln('Error: No response');
        ErrorCode := FCE_NoResponse;                {anything else is bad}
        Halt(ErrorCode);
      end;
    end
    else if ((Fipp.RspArray.Cmd = FCOM_ACK) and (UseNoAck = true)) then   {disallowed ack response?}
    begin
      writeln('Error: Unexpected Ack Response');
      ErrorCode := FCE_UnexpectedAck;
      Halt(ErrorCode);
    end;

    if foname <> '' then                         {output filename given?}
    begin
      assign(f,foname);                          {yes, so stick response}
      rewrite(f);                                 {in the specified file}
      for i := 0 to Fipp.RspArray.Raw[1]+1 do
      begin
        if UseShowInt = false then
          x := word(Fipp.RspArray.Raw[i])
        else x := smallint(Fipp.RspArray.Raw[i]);
        if (UseDelimit = true) and (i < Fipp.RspArray.Raw[1]+1) then
          write(f,x,',')
        else writeln(f,x);
      end;
      close(f);
    end;

    if not UseQuiet and (foname = '') then          {show output on screen?}
    begin
      for i := 0 to Fipp.RspArray.Raw[1]+1 do
      begin
        if UseShowInt = false then
          x := word(Fipp.RspArray.Raw[i])
          else x := smallint(Fipp.RspArray.Raw[i]);
        if (UseDelimit = true) and (i < Fipp.RspArray.Raw[1]+1) then
          write(x,',')
        else writeln(x);
      end;
    end;

    if Fipp.CmdArray.Cmd = 33 then         {always follow up with}
    begin
      if Fipp.RspArray.Data[0] <> 0 then  {a verification on cmd}
      begin
        writeln('Error: Bad command');
        ErrorCode := FCE_CommandFail;       {whoops, didn't make it}
      end;
    end;
end;


{-----------------------------------------------}
{command sequence = FBAT32 cmd count data... }

procedure RunProgram;
begin
  Start := timeGetTime;
  ErrorCode := FCE_NoCmd;
  ExitSave := ExitProc;
  ExitProc := @PrgExit;


  if ParamCount < 1 then              {if no parms, tell em how to do it}
  begin
    writeln('FBAT - Version 6.11 as of 5 Oct 2011');
    writeln('Copyright 1989,2011 Frye Electronics, Inc.');
    writeln('Format is: FBAT [-Cn] [-A] [-N] [-L] [-Tn] [-Bn] [-Q] [-F Rfilename] cmd count data');
    writeln('       or: FBAT [-Cn] [-A] [-N] [-L] [-Tn] [-Bn] [-Q] [-F Rfilename] Sfilename');
    writeln('       (Items in [] are optional.)');
    writeln(' -Cn selects com port number; default=Auto-seek port');
    writeln(' -Tn selects optional poll timeout delay (n=ms) if needed; default=5000');
    writeln(' -Bn selects baudrate (n=baudrate) if other than 9600 (default=Autobaud)');
    writeln(' -N save data as signed 16bit integers (default is 16bit unsigned)');
    writeln(' -L save data as comma delimited numbers');
    writeln(' -Q selects quiet mode (doesn''t show text on screen)');
    writeln(' -F selects output file for data');
    writeln(' -A disallow ACK as a response (generate a return error)');
    writeln(' -D enable debug mode');
    writeln(' Sfilename optional filename source for commands');
    writeln(' cmd count data : command sequence to send (see documentation)');
    ErrorCode := FCE_NoCmd;
    Halt(ErrorCode);
  end;


  PNum := 1;    //initialize number of parameters as default
  UsePORT := 0; //auto seek as default
  foname := '';  //output filename
  PortMode := FCOM_USE_BAUD_SEEK; //FBAT always uses autobaud seek now

  Tm := longint(timeGetTime);
  if UseDebugMode then
  begin
    write('GetOptions: ');
  end;
  GetOptions;    {any options given?}
  Tm := longint(timeGetTime)-Tm;
  if UseDebugMode then
  begin
    writeln(inttostr(TM)+'ms');
  end;

  if (FCOM_DllLoaded() <> SUCCESS) then
  begin
    writeln('FryeCom.DLL not found, wrong version, or damaged');
    ErrorCode := FCE_NoFryers;
    Halt(ErrorCode);
  end;

  Fipp := TclsFippCore.Create();

  Tm := timeGetTime;
  if UseDebugMode then
  begin
    write('Open Port: ');
  end;
  OpenPort;      {open port for xmission}
  Tm :=  longint(timeGetTime)-Tm;
  if UseDebugMode then
  begin
    writeln(inttostr(TM)+'ms');
  end;

  AllSent := false;
  Tm := longint(timeGetTime);
  if UseDebugMode then
  begin
    write('Get Command: ');
  end;
  GetCommand;    {get the command or file to send}
  Tm := longint(timeGetTime)-Tm;
  if UseDebugMode then
  begin
    writeln(inttostr(TM)+'ms');
  end;

While true do
begin
  if GetCmdToSend = false then break;
  if UseDebugMode then
  begin
    SaveOutput;
  end;

  Tm := timeGetTime;
  if UseDebugMode then
  begin
    write('Send the command: ');
  end;
  SendIt;        {send the command}
  Tm :=   longint(timeGetTime)-Tm;
  if UseDebugMode then
  begin
    writeln(inttostr(TM)+'ms');
  end;
end;

  Tm := longint(timeGetTime);
  if UseDebugMode then
  begin
    write('Close Port: ');
  end;
  ClosePort;
  Tm := longint(timeGetTime)-Tm;
  if UseDebugMode then
  begin
    writeln(inttostr(TM)+'ms');
  end;

  Tm := longint(timeGetTime) - Start;
  if UseDebugMode then
  begin
    writeln('All done: '+inttostr(Tm)+'ms');
  end;

  ErrorCode := 0;   {yeah, we're home free}
end;

end.


