
{blob display routines for use with test programs}
{Copyright 1992,1998,2003 Frye Electronics -- writen by Michael Day}
{V5.10 as of 2 May 2003}

unit ShowData;
interface
uses Windows,FryeDefs,FippDefs,FryeStr,FippUnit;

procedure SD_ShowCurve(pCurveFrame:ptCurveFrame);
procedure SD_ShowAnsiBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowIecBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowJisBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowAnsi92Blob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowProfileBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowIec05Blob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowUnknownBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
procedure SD_ShowBytes(var Data; Size:word; Show:WORD);
procedure SD_ShowLabel(Size:integer; pLabelData:pchar);

implementation

procedure D2write(Value:INT16);
begin
  if WORD(Value) = $8000 then
    write(' -----')
  else write(FS_Str2d(Value));
end;

procedure SD_ShowCurve(pCurveFrame:ptCurveFrame);
var i,ii:integer;
var Ts : DWORD;
    V : boolean;
begin
  write(' ',FS_HexW(word(pCurveFrame.Flags and $FFFF)),'H');
  write(' ',FS_HexW(word(pCurveFrame.Flags shr 16)),'H');
  Ts := pCurveFrame.TimeStamp;
  if FS_ValidTimeStamp(Ts) then
  begin
    write(' ',FS_GetStampDateStr(Ts,V),' ',FS_GetStampTimeStr(Ts,true,V))
  end
  else
  begin
    write(' ',FS_HexW(word(Ts and $FFFF)),'H');
    write(' ',FS_HexW(word(Ts shr 16)),'H');
    write('      ');
  end;
  D2write(pCurveFrame.Source);
  D2write(pCurveFrame.Peak);
  D2write(pCurveFrame.Output);
  write(FS_spc, FS_IntStr(pCurveFrame.Spare));
  write(FS_spc, FS_IntStr(pCurveFrame.NoiseReduction));
  writeln;

  ii := 0;
  for i:=0 to (MAX_CRV_DATA - 1) do
  begin
    write(FS_Str2d(pCurveFrame.Data[i]));
    inc(ii);
    if ii > 11 then
    begin
      writeln;
      ii := 0;
    end;
  end;
end;

(*
  begin
    //Tw2 := Fipp.CurveFrame[2]; {convert to word to keep compiler happy}
    //Tw3 := Fipp.CurveFrame[3]; {when it converts to long int}
    //Ts := longint(Tw2)+(longint(Tw3) shl 16); {time stamp}
    for i := 0 to pred(CurveFrameSize) do
    begin
      if (i >= 4) and (word(CurveFrame[i]) = $8000) then write(' -----')
      else
      begin
        case i of
         0..1: write(' ',WordToHex(word(CurveFrame[i])),'H');
            2: if ValidTimeStamp(Ts) then
               begin
                 write(' ',GetStampDateStr(Ts,V),' ',GetStampTimeStr(Ts,true,V))
               end
               else
               begin
                 write(' ',WordToHex(word(CurveFrame[2])),'H');
                 write(' ',WordToHex(word(CurveFrame[3])),'H');
                 write('      ');
               end;
            3: {nop};
            4: write(Str2d(CurveFrame[i]));
         5..6: write(Str2d(CurveFrame[i]));
            7: write(rstr(CurveFrame[7],6));
         8..MaxCurveSize-1:
               write(Str2d(CurveFrame[i]));
          else write(' ',HexW(word(CurveFrame[i])),'H');
        end;
      end;
      if (i=7) then
      begin
        writeln;
        ii := 0;
      end
      else
      begin
        inc(ii);
        if ii > 11 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
end;
*)

{blob display for ansi87/96}
procedure SD_ShowAnsiBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:integer;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=14) and (i<=17)) or
              ((i>=104) and (i<=107)) or
              ((i>=273) and (i<=276))) and
          (pBlob[i] = $8000) then write(' -----')
       else
       begin
        case i of
            0..2  : write(pBlob[i]:6);              {maj,min,blobsize}
            3..5  : write(pBlob[i]:6);              {avg freqs}
            6..8  : write(pBlob[i]:6);              {dist freqs}
               9  : write(pBlob[i]:6);              {aidtyp}
          10..13 : write(FS_Str2D(INT16(pBlob[i]))); {fogsrc,coil,calcrtg,measrtg}

          14..17 : write(' ',FS_Hexw(pBlob[i]),'H');   {sspl90 cf}
          18..20 : write(FS_Str2D(INT16(pBlob[i])));
              21 : write(pBlob[i]:6);
          22..101: write(FS_Str2D(INT16(pBlob[i])));

         102..103: write(FS_Str2D(INT16(pBlob[i])));  {avgospl90,fogavg}

         104..107: write(' ',FS_Hexw(pBlob[i]),'H');    {rsp cf}
         108..110: write(FS_Str2D(INT16(pBlob[i])));
              111: write(pBlob[i]:6);
         112..191: write(FS_Str2D(INT16(pBlob[i])));

              192: write(FS_Str2D(INT16(pBlob[i])));  {rsp limit}
         193..194: write(pBlob[i]:6);                {f1,f2}
         195..197: write(FS_Str2D(INT16(pBlob[i])));  {tdh1,thd2,thd3}
              198: if (pBlob[i]=32767) then write(' SHORT')
                    else write(FS_Str2D(INT16(pBlob[i])));  {battcur}
              199: write(pBlob[i]:6);                {batt type}
              200: write(FS_Str2D(INT16(pBlob[i])));  {eqin}
              201: write(pBlob[i]:6);                {iofreq #1}
         202..210: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
         211..212: write(pBlob[i]:6);                {attack,release}
              {ansi97 only below here}
              213: write(pBlob[i]:6);                {iofreq #2}
         214..222: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              223: write(pBlob[i]:6);                {iofreq #3}
         224..232: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              233: write(pBlob[i]:6);                {iofreq #4}
         234..242: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              243: write(pBlob[i]:6);                {iofreq #5}
         244..252: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              253: write(pBlob[i]:6);                {iofreq #6}
         254..262: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}

         263..267: write(pBlob[i]:6);                {attack[5]}
         268..272: write(pBlob[i]:6);                {release[5]}

         273..276: write(' ',FS_Hexw(pBlob[i]),'H');    {splits cf}
         277..279: write(FS_Str2D(INT16(pBlob[i])));
              280: write(pBlob[i]:6);
         281..360: write(FS_Str2D(INT16(pBlob[i])));
              361: write(FS_Str2D(INT16(pBlob[i])));  {splitsavg}

              else write(' ',FS_Hexw(pBlob[i]),'H');
        end;
       end;
       if (i=2) or (i=13) or (i=101) or (i=103) or (i=191) or
          (i=212) or (i=222) or (i=232) or (i=242) or (i=252) or (i=262) or
          (i=272) or (i=360) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;

procedure SD_ShowIecBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:word;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=187) and (i<=190))  ) and
          (pBlob[i] = $8000) then write(' -----')
       else
       begin
        case i of
           0..5  : write(pBlob[i]:6);      {maj,min,blobsize,reffreq,distfreq,aidgroup}
           6..8  : write(FS_Str2D(INT16(pBlob[i])));  {fogsrc, targetRTG,MeasRTG}

           9..12 : write(' ',FS_Hexw(pBlob[i]),'H');  {ospl90 curve}
          13..15 : write(FS_Str2D(INT16(pBlob[i])));
              16 : write(pBlob[i]:6);
          17..96 : write(FS_Str2D(INT16(pBlob[i])));

          97..100: write(' ',FS_Hexw(pBlob[i]),'H');  {FOG curve}
         101..103: write(FS_Str2D(INT16(pBlob[i])));
              104: write(pBlob[i]:6);
         105..184: write(FS_Str2D(INT16(pBlob[i])));

              185:  if (pBlob[i]=32767) then write(' SHORT')
                    else write(FS_Str2D(INT16(pBlob[i])));  {batt Current}
              186: write(pBlob[i]:6);                 {batt type}

         187..190: write(' ',FS_Hexw(pBlob[i]),'H');  {rsp curve}
         191..193: write(FS_Str2D(INT16(pBlob[i])));
              194: write(pBlob[i]:6);
         195..274: write(FS_Str2D(INT16(pBlob[i])));

         275..276: write(FS_Str2D(INT16(pBlob[i])));  {THDist, EQin}
              277: write(pBlob[i]:6);                 {IO freq}
         278..286: write(FS_Str2D(INT16(pBlob[i])));  {IO Data}
         287..288: write(pBlob[i]:6);                 {attack, Release}
              else write(' ',FS_Hexw(pBlob[i]),'H');
        end;
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (I=186) or (i=274) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;

{blob display for iec 2005}
procedure SD_ShowIec05Blob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:integer;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if (((i>=3) and (i<=17)) or
              ((i>=22) and (i<=24)) or
              ((i>=26) and (i<=105)) or
              ((i>=110) and (i<=112)) or
              ((i>=114) and (i<=193)) or
              ((i>=198) and (i<=200)) or
              ((i>=202) and (i<=281)) or
              ((i>=282) and (i<=291)) or
              ((i>=273) and (i<=351))) and
          (pBlob[i] = $8000) then write(' -----')
       else
       begin
        case i of
            0..2  : write(pBlob[i]:6);              {maj,min,blobsize}
            3..5  : write(FS_Str2D(INT16(pBlob[i])));              {osplavg, FogAvg, TcoilMasl }
            6..9  : write(FS_Str2D(INT16(pBlob[i])));              {TargetRTG, MeasRTG, AidAdj, Limit}
           10..11 : write(pBlob[i]:6);                               {F1,F2}
           12..14 : write(FS_Str2D(INT16(pBlob[i])));              {Dist1,Dist2,Dist3}
               15 : if (pBlob[i]=32767) then write(' SHORT')
                    else write(FS_Str2D(INT16(pBlob[i])));              {battcur}
           16..17 : write(FS_Str2D(INT16(pBlob[i])));              {Eqin, TCoilEtls}
           {--- end of short blob ---}

          18..21 : write(' ',FS_Hexw(pBlob[i]),'H');   {sspl90 cf}
          22..24 : write(FS_Str2D(INT16(pBlob[i])));
              25 : write(pBlob[i]:6);
          26..105: write(FS_Str2D(INT16(pBlob[i])));

         106..109: write(' ',FS_Hexw(pBlob[i]),'H');    {fog cf}
         110..112: write(FS_Str2D(INT16(pBlob[i])));
              113: write(pBlob[i]:6);
         114..193: write(FS_Str2D(INT16(pBlob[i])));

         194..197: write(' ',FS_Hexw(pBlob[i]),'H');    {rsp cf}
         198..200: write(FS_Str2D(INT16(pBlob[i])));
              201: write(pBlob[i]:6);
         202..281: write(FS_Str2D(INT16(pBlob[i])));
         {---- end of medium blob ---}

              282: write(pBlob[i]:6);                {iofreq #1 - 250Hz}
         283..291: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              292: write(pBlob[i]:6);                {iofreq #2 - 500Hz}
         293..301: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              302: write(pBlob[i]:6);                {iofreq #3 - 1000Hz}
         303..311: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              312: write(pBlob[i]:6);                {iofreq #4 - 2000Hz}
         313..321: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}
              322: write(pBlob[i]:6);                {iofreq #5 - 4000Hz}
         323..331: write(FS_Str2D(INT16(pBlob[i])));  {iodata[9]}

         332..336: write(pBlob[i]:6);                {attack[5]}
         337..341: write(pBlob[i]:6);                {release[5]}
         {---- end of long blob ---}

         342..344: write(pBlob[i]:6);                  {avgFreq[3]}
         345..347: write(pBlob[i]:6);                  {DistFreq[3]}
         348..351: write(pBlob[i]:6);                  {ear, Aidgroup, BattType, BattSize}
         {--- end of extended blob ---}

              else write(' ',FS_Hexw(pBlob[i]),'H');
        end;
       end;
       if (i=2) or (i=11) or (i=17) or (i=105) or (i=193) or
          (i=281) or (i=291) or (i=301) or (i=311) or (i=321) or
          (i=331) or (i=341) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;


procedure SD_ShowJisBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:word;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=187) and (i<=190))) and
          (pBlob[i] = $8000) then write(' -----')
       else
       begin
        case i of
           0..5  : write(pBlob[i]:6);                 {major,minor,size, reffreq, coupler, Aidgroup}
           6..8  : write(FS_Str2D(INT16(pBlob[i])));  {FogSrc, TargetRTG, MeasRTG}

           9..12 : write(' ',FS_Hexw(pBlob[i]),'H');  {ospl90 (sspl) cf}
          13..15 : write(FS_Str2D(INT16(pBlob[i])));
              16 : write(pBlob[i]:6);
          17..96 : write(FS_Str2D(INT16(pBlob[i])));

          97..100: write(' ',FS_Hexw(pBlob[i]),'H');   {fog cf}
         101..103: write(FS_Str2D(INT16(pBlob[i])));
              104: write(pBlob[i]:6);
         105..184: write(FS_Str2D(INT16(pBlob[i])));

              185:  if (pBlob[i]=32767) then write(' SHORT')
                    else write(FS_Str2D(INT16(pBlob[i])));   {batt Current}
              186: write(pBlob[i]:6);                  {batt Type}

         187..190: write(' ',FS_Hexw(pBlob[i]),'H');   {resp cf}
         191..193: write(FS_Str2D(INT16(pBlob[i])));
              194: write(pBlob[i]:6);
         195..274: write(FS_Str2D(INT16(pBlob[i])));

         275..278: write(FS_Str2D(INT16(pBlob[i])));   {distortion[3], EQin}
              279: write(pBlob[i]:6);                  {IO Freq}
         280..288: write(FS_Str2D(INT16(pBlob[i])));   {IO Data}
         289..290: write(pBlob[i]:6);                  {Attack, Release}
              else write(' ',FS_Hexw(pBlob[i]),'H');
        end;
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (I=186) or (i=274) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;


procedure SD_ShowAnsi92Blob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:integer;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=185) and (i<=188)) or
              ((i>=273) and (i<=276)) or
              ((i>=362) and (i<=365)) or
              ((i>454))) and
             (pBlob[i] = $8000) then write(' -----')
       else
       begin
         case i of
           0..2 : write(pBlob[i]:6);        {Maj, Min, Size}
           3..6 : write(FS_Str2D(INT16(pBlob[i])));  {TargetRTG, MeasRTG, NSPL90, FONG}
           7..8 : write(pBlob[i]:6);                 {Nred, Meas Settle}

           9..12: write(' ',FS_Hexw(pBlob[i]),'H');  {50db}
          13..15: write(FS_Str2D(INT16(pBlob[i])));
              16: write(pBlob[i]:6);
          17..96: write(FS_Str2D(INT16(pBlob[i])));

         97..100: write(' ',FS_Hexw(pBlob[i]),'H');  {60db}
        101..103: write(FS_Str2D(INT16(pBlob[i])));
             104: write(pBlob[i]:6);
        105..184: write(FS_Str2D(INT16(pBlob[i])));

        185..188: write(' ',FS_Hexw(pBlob[i]),'H');  {70db}
        189..191: write(FS_Str2D(INT16(pBlob[i])));
             192: write(pBlob[i]:6);
        193..272: write(FS_Str2D(INT16(pBlob[i])));

        273..276: write(' ',FS_Hexw(pBlob[i]),'H');  {80db}
        277..279: write(FS_Str2D(INT16(pBlob[i])));
             280: write(pBlob[i]:6);
        281..360: write(FS_Str2D(INT16(pBlob[i])));

        361..364: write(' ',FS_Hexw(pBlob[i]),'H');  {90db}
        365..367: write(FS_Str2D(INT16(pBlob[i])));
             368: write(pBlob[i]:6);
        369..448: write(FS_Str2D(INT16(pBlob[i])));

        449..453: write(FS_Str2D(INT16(pBlob[i])));  {I/O data [5] 50->90 : 10dB steps}

              else write(' ',FS_Hexw(pBlob[i]),'H');
         end; {case i}
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (i=272) or (i=360) or (i=448) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;

procedure SD_ShowProfileBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:integer;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=3) and (i<=6)) or
              ((i>=91) and (i<=94)) or
              ((i>=179) and (i<=182)) or
              ((i>=267) and (i<=270)) or
              ((i>=355) and (i<=358))) and
          (pBlob[i] = $8000) then write(' -----')
       else
       begin
        case i of
            0..2 : write(pBlob[i]:6);  {Maj, Min, Size}

            3..6 : write(' ',FS_Hexw(pBlob[i]),'H');   {crv 1}
            7..9 : write(FS_Str2D(INT16(pBlob[i])));
              10 : write(pBlob[i]:6);
           11..90: write(FS_Str2D(INT16(pBlob[i])));

          91..94 : write(' ',FS_Hexw(pBlob[i]),'H');   {crv 2}
          95..97 : write(FS_Str2D(INT16(pBlob[i])));
              98 : write(pBlob[i]:6);
          99..178: write(FS_Str2D(INT16(pBlob[i])));

         179..182: write(' ',FS_Hexw(pBlob[i]),'H');   {crv 3}
         183..185: write(FS_Str2D(INT16(pBlob[i])));
              186: write(pBlob[i]:6);
         187..266: write(FS_Str2D(INT16(pBlob[i])));

         267..270: write(' ',FS_Hexw(pBlob[i]),'H');   {crv 4}
         271..273: write(FS_Str2D(INT16(pBlob[i])));
              274: write(pBlob[i]:6);
         275..354: write(FS_Str2D(INT16(pBlob[i])));

         355..358: write(' ',FS_Hexw(pBlob[i]),'H');   {crv 5}
         359..361: write(FS_Str2D(INT16(pBlob[i])));
              362: write(pBlob[i]:6);
         363..442: write(FS_Str2D(INT16(pBlob[i])));

              443: write(FS_Str2D(INT16(pBlob[i])));  {eqin}
              444: write(' -----');
              445: if (pBlob[i]=32767) then write(' SHORT')
                    else write(FS_Str2D(INT16(pBlob[i])));  {battcur}
              446: write(' -----');
              447: write(pBlob[i]:6);                {batt type}
              448: write(' -----');

         449..464: write(FS_Str2D(integer(pBlob[i])));  {dist[16]}

              465: write(FS_Str2D(INT16(pBlob[i])));  {peak}
              466: write(' -----');
              467: write(FS_Str2D(INT16(pBlob[i])));  {rmsout crv2}
              468: write(' -----');
              469: write(pBlob[i]:6);                {nr at 50db}
              470: write(' -----');

              else write(' ',FS_Hexw(pBlob[i]),'H');
        end;
       end;
       if (i=2) or (i=90) or (i=178) or (i=266) or (i=354) or (i=442) or
          (i=448) or (i=464) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
end;



procedure SD_ShowUnknownBlob(BlobSize:integer; pBlob:FIPP_ptBlobArray);
var ii,i:word;
begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
        write(FS_HexW(pBlob[i]),' ');
        inc(ii);
        if ii > 13 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
end;

{if Show=0, only char is shown, if Show = 1, only hex is shown, if Show = 2, both are shown}
procedure SD_ShowBytes(var Data; Size:word; Show:word);
var ii,i:word;
var CharData : FIPP_tAuxDataArray absolute Data;
begin
    ii := 0;
    if Size > 0 then
    begin
      for i := 0 to pred(Size) do
      begin
        if Show = 0 then
          write(CharData[i])
        else if Show = 1 then
          write('$',FS_HexB(BYTE(CharData[i])),' ')
        else write('$',FS_HexB(BYTE(CharData[i])),'(',CharData[i],') ');
        inc(ii);
        if ii > 13 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
end;

{------------------------------------------------}
{This will display the Frye label}
{It expects a pchar formated 2d label character array}
{see LabelUnit for details of the label format.}
{Size = Size of the total number of characters in the label }
{(including any intermediate nulls). }
procedure SD_ShowLabel(Size:integer; pLabelData:pchar);
var i,ii:word;
    c : char;
    MaxSize : integer;
begin
  i := 1;
//  if Which = 1 then
//    MaxSize := MaxUserIDTextSize
//  else MaxSize := MaxExtLabelSize;

  while i < Size do
  begin
    ii := 0;
    c := #255;
    while (ii < 28) and (c <> #0) do
    begin
      //if Which = 1 then
      //  c := FippCmd.UserIDText[FippCmd.UserNumber][pred(i)]
      //else c := FippCmd.ExtLabelData[pred(i)];

      c := pLabelData[pred(i)];
      write(c);
      inc(ii);
      inc(i)
    end;
    writeln;
    while ii < 28 do
    begin
      inc(i);
      inc(ii);
    end;
  end;
end;


end.
