unit TestDefs;
interface
//uses FryeDefs,FippDefs,FippCore,TestFipp;

//Fipp Object declarations
{$DEFINE USE_FIPP_UNIT} //<- uncomment to enable FippUnit use

{$IFDEF USE_FIPP_UNIT}
  Uses Graphics,FryeDefs,FippCore,FippUnit;
{$ELSE}
  Uses graphics,FryeDefs,FippCore;
{$ENDIF}

{$IFDEF USE_FIPP_UNIT}
  Var Fipp:TclsFipp;
{$ELSE}
  Var Fipp:TclsFippCore; //<- if we are only using the core fipp calls
{$ENDIF}



const Test32InitKey : string = 'TEST32'; //INI file and Registry key for this program

var pfunerr : integer = 0;    //dofcmd return code
var OpenCount : integer = 0;  //number of times PortOpen has been called.
var FippError : integer = 0;  //last known Fipp error status returned
var ValidComPort : integer = -1;       //last known valid com port (-1=unknown)
var ErrorCode: integer = 0;
var StatusPresent : boolean = false; //true = status line has been printed by callback
var StatusUpdateResolution : integer = 200; //how often to update status callback in ms
{-------------------------------------------------------------------}
{These are the possible ErrorCode/PacketError values}

//Note: if autoseek, we start the seach from the last used port found in the registry
var UsePort : word = 0; //0=autoseek, 1=com1, 2=com2, etc...
var UseAutoSeek : integer = 1; //1=autoseek port (-C0), 0=don't use autoseek
var UseBaud : integer = 0; //0=autobaud, 9600=9600, etc...
var UseAutobaud : boolean = true; //default is to use autobaud unless it is disabled.
var UseNoPollTimeout : WORD = 5000; //0=no change, 5000=5sec, etc...
var UseQuiet : boolean = false;
var UseNoAck : boolean = false; //true=prohibit ack response, false=allow
var UseDebugMode : boolean = false;
var UseScript : boolean = false; //true = script cmd override (exit prg after command is done)

const KeepAliveDefault : boolean = true;   //initial default state of keepalive
var UseKeepAlive : boolean = false; //true = keep port alive between commands

const ShowIntDefault : boolean = false;   //initial default state of ShowInt
var UseShowInt : boolean = false;

const VerifyDefault : boolean = true;   //initial default state of Verify
var UseVerify : boolean = false; //verify all cmds (call cmd 33 after each command)

const DoubleCheckDefault : boolean = true;   //initial default state of DoubleCheck
var UseDoubleCheck : boolean = false;   //call get after all Set commands

const DelimitDefault : boolean = false;   //initial default state of comma Delimit
var UseDelimit : boolean = false;

const killme : boolean = false;

//const ErrorCode : integer = 0;
const Iam : integer = -1; {-1=unknown}

var BitmapTotalSize : longint;
var pImage : ^BYTE = NIL;
//type tImgArray = array[0..1999999] of word;
//var ImgBuffer : tImgArray;

var InputString : str255;


implementation

begin
//create the fipp object on start up
{$IFDEF USE_FIPP_UNIT}
  Fipp := TclsFipp.Create();
{$ELSE}
  Fipp := TclsFippCore.Create();
{$ENDIF}



end.
