
{Common misc routines used by Test32}
unit TestSubs;

interface
uses Windows,Graphics,FryeDefs,extdlgs,FCErrMsg,FippDefs,FcomDefs,FryeComD,FryeTools,FryeStr,
     IniReg,FonixSig,TestDefs; //,ShowBlob,Windows,SysUtils;

function TSUB_GotResponse:boolean;
procedure TSUB_PackErr;

function TSUB_OpenPortCallback(ComPort:integer):integer; stdcall;
function TSUB_OpenPort:boolean;

function TSUB_StatusCallback(Value:integer):integer; stdcall;
procedure TSUB_ClosePort;

procedure TSUB_LevelingStatus;


{Create an object that we can import the canvas stuff into for the bmp image work}
type TclsFippImg = class
    SavePictureDialog1: TSavePictureDialog; //used to save bitmap images to a file as BMPs
    MemImage : TBitmap;

    procedure BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);

    //-------------------------------
    constructor Create;
    destructor Destroy; override;
end;
Var FippImg:TclsFippImg;
//=================================================================

implementation

{===================================================================}
// Implementation for the Save class constructor
constructor TclsFippImg.Create;
begin
  inherited Create;
  //    InitializeCriticalSection(Csv);
  MemImage := TBitmap.Create;
end;
{===================================================================}
destructor TclsFippImg.Destroy;
begin
//  DeleteCriticalSection(Csv);
  MemImage.free;
  inherited Destroy;
end;

procedure TclsFippImg.BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);
begin
  if (MemImage.Width <> MemImgW) or (MemImage.Height <> MemImgH) then
  begin
    MemImage.Width := MemImgW;
    MemImage.Height := MemImgH;
    MemImage.Canvas.Brush.Style := bsSolid;
    MemImage.Canvas.Pen.Style := psSolid;
    MemImage.Canvas.Pen.Mode := pmCopy;
    MemImage.Canvas.Brush.Color := clWhite;
    MemImage.Canvas.Pen.Color := clWhite;
    MemImage.Canvas.Rectangle(0,0,MemImage.Width,MemImage.Height);
    MemImage.Canvas.Brush.Color := clBlack;
    MemImage.Canvas.Pen.Color := clBlack;
//    if FrameCheckBox.Checked then
//    begin
//      MemImage.Canvas.Moveto(0,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,0);
//    end;
  end;
end;

{------------------------------------------------}
//This indicates that there is a response in the response array
//It may still be an incorrect or bad response though.
function TSUB_GotResponse:boolean;
begin
  if ((Fipp.FippError = FCOM_SUCCESS) or
      (Fipp.FippError = FCOM_NAK_RESPONSE) or
      (Fipp.FippError = FCOM_ILL_RESPONSE) or
      (Fipp.FippError = FCOM_POLL_RESPONSE) or
      (Fipp.FippError = FCOM_RESPONSE_OVERRUN) or
      (Fipp.FippError = FCOM_RESPONSE_ERROR) or
      (Fipp.FippError = FCOM_CMD_FAIL) or
      (Fipp.FippError = FCOM_UNEXPECTED_ACK) ) then
  begin
    Result := true;
  end
  else
  begin
    Result := false;
  end;
end;

{------------------------------------------------}
{if a packet error occurs, we show this so the }
{use can try to figure out what went wrong.}
procedure TSUB_PackErr;
var sMsg:string;
var ErrorType:integer;
begin
  if UseQuiet = true then Exit;

  writeln;
  write('** Packet error ** ',Fipp.FippError,' -> ');
  FEM_GetErrorMsg(Fipp.FippError,true,ErrorType,sMsg);
  writeln(sMsg);
  writeln('Error - AX:',FS_hexW(Fipp.PortStatus.PacketStatus), //AX
                 ' CX:',FS_hexW(Fipp.PortStatus.PacketControl), //CX
                 ' Error:',Fipp.FippError );

  writeln('CmdArray.Cmd=',Fipp.CmdArray.Cmd,'  CmdArray.Size=',Fipp.CmdArray.Size,
          ' CmdArray.Data[0]=',Fipp.CmdArray.Data[0]);
  if (TSUB_GotResponse() = true) then
  begin
    write('RspArray.Cmd=[',FS_hexW(Fipp.RspArray.Cmd),']');
    if WORD(Fipp.RspArray.Cmd) > $7fff then write('(',integer(Fipp.RspArray.Cmd),')');
    WRITE(Fipp.RspArray.Cmd);
    writeln(' RspArray.Size=',Fipp.RspArray.Size,
            ' RspArray.Data[0]=',Fipp.RspArray.Data[0]);
    if Fipp.Verify and Fipp.CmdStatusFailed then
      writeln('Command failed - bad status (33)');
  end;
end;


{----------------------------------------------------------}
{This function is used to display status information during openport call}
function TSUB_OpenPortCallback(ComPort:integer):integer; stdcall;
var ch : char;
var sTmp:string;
begin
  if (UseQuiet = true) then
  begin
    Result := FCOM_SUCCESS;
    Exit;
  end;

  //only do this the first time
  if (OpenCount = 0) then
  begin
    Fipp.UpdatePortStatus();
    sTmp := #13+'<seeking:'+FS_IntToStr(Fipp.PortStatus.SeekState)+
            '> COM'+FS_IntToStr(Fipp.ThisComPort+1)+
            ' Baud:'+FS_IntToStr(Fipp.PortStatus.Baudrate);
    sTmp := FS_TagFill(sTmp,' ',78)+#13;
    SetLength(sTmp,78); //limit length to 78 char max to prevent scrolling
    write(sTmp);
    StatusPresent := true;
  end;

  if (FT_ConKeyWaiting() = true) then
    ch := FT_ConGetKey()
  else ch := #0;
  if (ch = #$1B) then
    Result := FCOM_CANCEL
  else Result := FCOM_SUCCESS;
end;

{----------------------------------------------------------}
{This function is used to display status information during cmd calls}
var PreviousStatusCallBackTimer : integer = 0;
var StatusCallbackTimer : integer = 0;
function TSUB_StatusCallback(Value:integer):integer; stdcall;
var ch : char;
var ErrorType:integer;
var sTmp : string;
begin
  ErrorType := FEM_NO_ERROR;
  if (UseQuiet = true) then
  begin
    Result := FCOM_SUCCESS;
    Exit;
  end;

  begin
    if (StatusUpdateResolution < 1) then StatusUpdateResolution := 1;
    StatusCallbackTimer := FT_Timer() div StatusUpdateResolution;
    if StatusCallbackTimer <> PreviousStatusCallBackTimer then
    begin
      PreviousStatusCallBackTimer := StatusCallbackTimer;
      Fipp.UpdatePortStatus();
      write(FS_Spinner());
      sTmp := 'Status - AX:'+FS_hexW(Fipp.PortStatus.PacketStatus)+ //AX
                      ' CX:'+FS_hexW(Fipp.PortStatus.PacketControl)+ //CX
                     ' Err:'+FS_IntToStr(Fipp.FippError)+' '+FEM_Msg(Fipp.FippError,ErrorType);
      sTmp := FS_TagFill(sTmp,' ',78);
      SetLength(sTmp,78); //limit length to 78 char max to prevent scrolling
      write(sTmp,#13);
      StatusPresent := true;
    end;
  end;

  if (FT_ConKeyWaiting() = true) then
    ch := FT_ConGetKey()
  else ch := #0;
  if (ch = #$1B) or (ErrorType = FEM_HARD_ERROR) then
    Result := FCOM_CANCEL
  else Result := FCOM_SUCCESS;
end;

{----------------------------------------------------------}
{open the com port for operation}
function TSUB_OpenPort:boolean;
var ComPort : integer;
var ThisPort : integer;
var ErrorType : integer;
var sMsg : string;
begin
  Result := false; //assume failure

  //If port already open, no need to do this
  if (Fipp.PortInitialized = true) then
  begin
    OpenCount := OpenCount+1;
    Result := true;
    Exit;
  end;

  UseAutoSeek := 0;
  if UseAutoBaud = true then
  begin
    UseAutoSeek := UseAutoSeek or FCOM_USE_BAUD_SEEK;
  end;

  //if no com port specified, use auto port seek
  if (UsePort = 0) then
  begin
    UseAutoSeek := UseAutoSeek or FCOM_USE_PORT_SEEK;

    //start auto seek with the last known com port used
    if (REG_RegistryValue(READ_REGISTRY_INTEGER,UsePort,Test32InitKey,'COM_PORT') = false) then
    begin
      UsePort := 1; //if registry entry not found, try com1
    end;
    ComPort := UsePort - 1;
    if (ComPort < 0) then ComPort := 0;

    if (UseBaud = 0) then
    begin
      //Start with the last known baudrate used if none given
      if (REG_RegistryValue(READ_REGISTRY_INTEGER,UseBaud,Test32InitKey,'BAUDRATE') = false) then
      begin
        UseBaud := 9600;
      end;
    end;
  end
  else
  begin
    ComPort := UsePort - 1;
  end;
  Fipp.FippError := Fipp.InitPort(UseAutoSeek, ComPort, -1, -1, FIPP_SOFT_RETRY, UseBaud, TSUB_OpenPortCallback);
  if (StatusPresent = true) then
  begin
    StatusPresent := false;
    writeln;  //goto next line to get away from the status line
  end;
  if (Fipp.FippError <> SUCCESS) then
  begin
    OpenCount := 0;
    Exit;
  end;
  //begin
    //ErrorCode := FEM_GetErrorMsg(Fipp.FippError,true,ErrorType,sMsg);
    //writeln(sMsg); //writeln('Packet com port not open');
    //ErrorCode := NoPort;                           {ick, no can talk}
    //Halt(ErrorCode);
    //Exit;
  //end;

  Fipp.GetNoPoll(Fipp.PollTimer);
  OpenCount := OpenCount + 1;
  SIG_UpdateHwSignature(false); //Collects current information to update signature info
  SIG_UpdateInstSignature(false); //Collects current information to update signature info
  ThisPort := Fipp.ThisComPort+1;    //if port opened successfully, save it in registry
  REG_RegistryValue(WRITE_REGISTRY_INTEGER,ThisPort,Test32InitKey,'COM_PORT');
  UseBaud := Fipp.ActiveBaudrate;
  REG_RegistryValue(WRITE_REGISTRY_INTEGER,UseBaud,Test32InitKey,'BAUDRATE');
  REG_RegistryValue(WRITE_REGISTRY_BOOLEAN,UseKeepAlive,Test32InitKey,'KEEP_ALIVE');
  ErrorCode := SUCCESS;
  Result := true; //mark that we were successful
end;

procedure TSUB_ClosePort;
begin
  Fipp.ClosePort();
end;

procedure TSUB_LevelingStatus;
begin
  write('State    : ');
  case Fipp.LevelState of
    0 : writeln('Leveled      (0)');
    1 : writeln('Semi-leveled (1)');
    2 : writeln('Un-leveled   (2)');
  else
    writeln(Fipp.LevelState);
  end;

  if (Fipp.LevelDirection <> INVALID_DATA16) then
  begin
    writeln('Direction: ',Fipp.LevelDirection);
  end;

  if (Fipp.AdvLevelStatus <> INVALID_DATA16) then
  begin
    write('Detail   : ');
    case Fipp.AdvLevelStatus of
      0 : writeln('Leveled      (0)');
      1 : writeln('Un-leveled   (1)');
      2 : writeln('Semi-leveled (2)');
      3 : writeln('Weak level   (3)');
      4 : writeln('Tcoil level  (4)');
      5 : writeln('Vrms level   (5)');
     -1 : writeln('Level Failed (-1)');
     -2 : writeln('Level Error  (-2)');
     -3 : writeln('Level Noisy  (-3)');
    else
      writeln('(',Fipp.AdvLevelStatus,')');
    end;
  end;

  if (Fipp.LevelMaxSpl <> INVALID_DATA16) then
  begin
    writeln('Max Spl  :',FS_DbStr(Fipp.LevelMaxSpl,false));
  end;
end;



begin
  FippImg := TclsFippImg.Create();
end.
