
{This is the common entry unit for the Test and Test32 programs}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.18 as of 16 Dec 2004 - med}
{12 Jun 2006 V5.20 -med - added new commands and adapted battery commands for 7000}
{5 Feb 2008 V5.30 - med - added abiltiy to access 99 com ports with new fryers32.dll}
{10 Oct 2010 V6.00 - med - added ability to use FryeCom DLL - now is Win32 only program}
{5 OCt 2011 V6.02 - med - fixed bug in set list command}

{$N+,E+}
Unit TrunUnit;
interface
uses Graphics,FryeDefs,FCErrMsg,FcomDefs,FippDefs,FryeComD,FryeTools,FryeStr,IniReg,
     TestDefs,TS2Unit,TS3Unit,FippUnit,FonixSig,ShowData,Windows,SysUtils,TestSubs;
{$APPTYPE CONSOLE}

procedure RunProgram;

const VerStr       : str255 = 'Fryers Test Program - Version 6.02 as of 5 Oct 2011';
const CopyrightStr : str255 = 'Copyright 1988,2011 Frye Electronics, Inc.  ';

{--> See TestDef.pas for global variables <--}

implementation

{-----------------------------}
{Exit processing code - shows error message on exit}
var ExitSave:pointer;
procedure PrgExit; far;
var ErrorType:integer;
begin
  ExitProc := ExitSave;
  if (ErrorCode <> 0) and (UseQuiet = false) then
  begin
    writeln(FEM_Msg(ErrorCode,ErrorType));
  end;
  ExitCode := ErrorType;
  Fipp.ClosePort();
end;


{---------------------------------------------------------}
procedure doport;
var OldCount:integer;
var Temp:integer;
begin
  Fipp.UpdateFcomVersion(); //make sure fcom is up to date
  if Fipp.FcomVersion < 520 then
  begin
    write('Enter new Com port to use (1-9; 0=AutoSeek) : ');
  end
  else if Fipp.FcomVersion < 610 then
  begin
    write('Enter new Com port to use (1-99; 0=AutoSeek) : ');
  end
  else
  begin
    write('Enter new Com port to use (1-255; 0=AutoSeek) : ');
  end;
  readln(temp);
  if temp < 0 then temp := 0;
  if temp > 256 then temp := 0;
  if Fipp.FcomVersion < 520 then
  begin
    if temp > 9 then temp := 0;
  end
  else if Fipp.FcomVersion < 600 then
  begin
    if temp > 99 then temp := 0;
  end
  else
  begin
    if temp > 256 then temp := 0;
  end;
  UsePort := temp;
  OldCount := OpenCount; //save the current open port counter

  Fipp.ClosePort();
  OpenCount := 0; //mark that we are no longer using the defined com port

  if TSUB_OpenPort() = true then
  begin
    ValidComPort := Fipp.ThisComPort;
    OpenCount := OpenCount+1;
  end
  else
  begin
    //if failed to find the port, but opened successfully previously
    //during this session, try to revert to last known port on failure
    //otherwise, just leave it closed
    if (OldCount > 0) and (ValidComPort >= 0) then
    begin
      UsePort := ValidComPort;
      if not(TSUB_OpenPort) then
      begin
         if (UseScript = true) then
         begin
           Halt(1);
         end;
      end;
      OpenCount := OldCount; //restore open count;
    end;
  end;
end;

{set new baudrate}
procedure dobaud;
var temp:integer;
begin
  writeln('Enter new baudrate to use');
  write('(0=Autoseek, 9600, 19200, 38400, 57600, 115200) : ');
  readln(temp);
  Fipp.NewBaudrate := temp;
  if not(Fipp.SetFonixBaudrate()) then
  begin
    writeln('Error setting baudrate ',Fipp.NewBaudrate);
  end;
end;

{set demand mode}
procedure DemandMode;
var temp:integer;
begin
  Fipp.PortMethod := FCOM_MODE_DEMAND;
  if (Fipp.SetDemandMethod() = false) then
  begin
    writeln('Error setting Demand Protocol Method: ',Fipp.PortMethod);
  end
  else
  begin
    writeln('Demand Protocol Method Enabled (',Fipp.PortMethod,')');
  end;
end;

{set poll mode}
procedure PollMode;
var temp:integer;
var Msg : string;
begin
  Fipp.PortMethod := FCOM_MODE_POLLED;
  if (Fipp.SetPolledMethod()=false) then
  begin
    Msg := FEM_Msg(Fipp.FippError,temp);
    writeln('Error setting Polled Protocol Method: ',Fipp.PortMethod);
    writeln(Msg);
  end
  else
  begin
    writeln('Polled Protocol Method Enabled (',Fipp.PortMethod,')');
  end;
end;

(*
{+++++++++++++++++++++++++++++++++++++++++++++++}
{used for special case debugging to test weird stuff}
procedure doWeird;
var tm1,tm2,tm3:integer;
begin

    while not FT_KeyWaiting  do
    begin
      FippCmd.Frequency := 2000;
      if not(FippCmd.SetFrequency()) then {nop};
      if not(FippCmd.ReleaseCmd()) then {nop};
      if FippCmd.GetMicData() then
        writeln('Current Microphone Input = ',FS_Str3D(FippCmd.MicData),'dB')
      else
        writeln('Get mic Error');
      tm1 := FippCmd.MicData;
      FippCmd.Frequency := 500;
      if not(FippCmd.SetFrequency()) then {nop};
      if not(FippCmd.ReleaseCmd()) then {nop};
      if FippCmd.GetMicData() then
        writeln('Current Microphone Input = ',FS_Str3D(FippCmd.MicData),'dB')
      else
        writeln('Get mic Error');
      tm2 := FippCmd.MicData;
      FippCmd.Frequency := 1000;
      if not(FippCmd.SetFrequency()) then {nop};
      if not(FippCmd.ReleaseCmd()) then {nop};
      if FippCmd.GetMicData() then
        writeln('Current Microphone Input = ',FS_Str3D(FippCmd.MicData),'dB')
      else
        writeln('Get mic Error');
      tm3 := FippCmd.MicData;

      writeln('Avg:',FS_Str3D(integer((longint(tm1)+tm2+tm3)div 3)),'dB');

    end;
  pfunerr := 0;
end;
{  if not QuickRelease then Exit; }
*)


procedure dobuild;
var t,i : integer;
var temp : integer;
var btemp : boolean;
begin
    TSUB_OpenPort(); //make sure port is open
    write('Enter command number: ');
    readln(temp);
    Fipp.CmdArray.Cmd := temp;
    write('Enter data count: ');
    readln(temp);
    Fipp.CmdArray.Size := temp;
    if (Fipp.CmdArray.Size > 0) and (Fipp.CmdArray.Size < FCOM_MAX_DATA_SIZE) then
    begin
      for i := 2 to Fipp.CmdArray.Size+1 do
      begin
        write('Enter data word: ');
        readln(temp);
        Fipp.CmdArray.Raw[i] := temp;
      end;
    end;
    write('Sending: ');
    write(Fipp.CmdArray.Cmd,'  ',Fipp.CmdArray.Size,'  ');
    if (Fipp.CmdArray.Size > 0) and (Fipp.CmdArray.Size < FCOM_MAX_DATA_SIZE) then
    begin
      for i := 2 to Fipp.CmdArray.Size+1 do
      begin
        write(Fipp.CmdArray.Raw[i],'  ');
      end;
    end;
    writeln;
    if not(Fipp.SendCmd()) then
    begin
      TSUB_PackErr();
      //writeln('Error - AX:',FS_hexW(Fipp.PortStatus.PacketStatus), //AX
      //               ' CX:',FS_hexW(Fipp.PortStatus.PacketControl), //CX
      //              ' Err:',Fipp.FippError );
      Exit;
    end;

    if (Fipp.CmdArray.Cmd <> $7fff) or (fipp.PortMethod <> FCOM_MODE_POLLED) then
    begin
      write('Response: ');
      write('RspArray.Cmd=[',FS_hexW(Fipp.RspArray.Cmd),']');
      if word(Fipp.RspArray.Cmd) > $7fff then write('(',integer(Fipp.RspArray.Cmd),')');
      WRITE(Fipp.RspArray.Cmd);
      t := integer(Fipp.RspArray.Cmd);
      T := ABS(T);
      case t of
        0:write(' POL ');
        4:write(' ACK ');
        5:write(' NAK ');
        6:write(' ILL ');
      end;
      writeln(' RspArray.Size = ',Fipp.RspArray.Size);
    end
    else
    begin
      writeln('Quick Release');
    end;
    writeln('Status - AX:',FS_hexW(Fipp.PortStatus.PacketStatus), //AX
                    ' CX:',FS_hexW(Fipp.PortStatus.PacketControl), //CX
                   ' Err:',FS_hexW(Fipp.FippError) );

    if (Fipp.CmdArray.Cmd <> $7fff) or (fipp.PortMethod <> FCOM_MODE_POLLED) then
    begin
      btemp := UseShowInt;
      if ((Fipp.CmdArray.Cmd = 111) or (Fipp.CmdArray.Cmd = 110)) then UseShowInt := true;
      if (Fipp.RspArray.Size > 0) and (Fipp.RspArray.Size < FCOM_MAX_DATA_SIZE) then
      begin
        write('Data = ');
        for i := 2 to Fipp.RspArray.Size+1 do
        begin
          if UseShowInt then
            write(smallint(Fipp.RspArray.Raw[i]),', ')
          else write(Fipp.RspArray.Raw[i],', ');
        end;
      end;
      UseShowInt := btemp;
    end;
  writeln;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure domon; {M}
var Count : integer;
var ErrorType : integer;
var LastTimerCount:integer;
var Status : integer;
begin
  TSUB_OpenPort(); //make sure port is open
  Fipp.SetCallback(TSUB_StatusCallback); //set the lowlevel callback to show Status
  writeln('Status Monitor : Press "ESCape" key to exit.');

  ErrorType := FEM_NO_ERROR;
  StatusUpdateResolution := 100;    //update only once every 100ms
  while FOREVER do
  begin
    Fipp.CmdArray.Cmd := 33;
    Fipp.CmdArray.Size := 0;
    Fipp.FippError := Fipp.DoCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL, Fipp.CmdArray, Fipp.RspArray, TSUB_StatusCallback);
    FEM_Msg(Fipp.FippError,ErrorType);
    Status := TSUB_StatusCallback(Fipp.ThisComPort); //show status at least once
    if (Status = FCOM_CANCEL) or (Fipp.FippError = FCOM_CANCEL) or (ErrorType = FEM_HARD_ERROR) then break;
  end;
  writeln;
  Fipp.SetCallback(NIL); //clear the lowlevel callback
end;

{-----------------------------------------------}
procedure doverify;
begin
  if InputString[2] = '-' then
    UseVerify := false
  else UseVerify := true;
  Fipp.Verify := UseVerify; //not(Fipp.Verify);
  if Fipp.Verify then
    writeln('Automatic Command Status Verify enabled')
  else
    writeln('Automatic Command Status Verify off');
  writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dodebug;
begin
  UseDebugMode := not(UseDebugMode);
  if UseDebugMode then
    writeln('Debugging enabled')
  else
    writeln('Debugging off');
  writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dopolltime;
var OldTimer:integer;
var LTemp:longint;
begin
    writeln;
    write('Current Poll Timeout = ',Fipp.PollTimer,'mS'    );
    writeln;
    write  ('Enter new Poll Timeout (in mS): ');
    readln(Ltemp);
    Fipp.PollTimer := Ltemp;
    Fipp.SetNoPoll(Fipp.PollTimer);

    Fipp.GetNoPoll(OldTimer);
    Fipp.PollTimer := OldTimer;
    write('New Poll Timeout = ',Fipp.PollTimer,' (mS)'    );
    writeln;
    writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
{This mechanism is no longer supported. Only used on the M340 (custom 6500)}
{The code is left here for achival reference only.}
//procedure dofwakeup;
//const Signal : array[0..3] of char = (^D, ^W, ^C, ^M);
//begin
//  if not SendWakeup(Signal,FIPPrec) then
//    writeln('* Timeout Error *');
//end;

{-----------------------------------------------}
{show help info}

const maxf = 999;

procedure dohelp; {dof90}{(var pfunerr:integer)}
begin
  writeln;
            { x                          x                           x                     e'}
{1} writeln(' 0/21=Set/Get Source Amp    70/71=Set/Get Option Param  13=Do RelAtt Select    ');
{2} writeln(' 1/22=Set/Get Dist Mode     75/76=Set/Get Test Ear      14=Do Battery          ');
{3} writeln(' 2/23=Set/Get Frequency     77/78=Set/Get Source Type   15=Do IO Test*         ');
{4} writeln(' 3/24=Set/Get OES State*    82/81=Set/Get Avg Freqs     16=Do (Start/Stop) Test');
{5} writeln(' 4/26=Set/Get Noise Red     84/83=Set/Get Meas Delay    17=Do Level            ');
{6} writeln(' 5/27=Set/Get Smoothing     88/87=Set/Get CIC State*    38=Do Reset            ');
{7} writeln(' 7/35=Set/Get Probe State*  90/91=Set/Get Avg Settle    64=Do Line Feeds       ');
{8} writeln(' 8/30=Set/Get Weighting     97/98=Set/Get A/R Params    65=Do Print            ');
{9} writeln(' 9/25=Set/Get Curve Frame                                                      ');
{10}writeln('10/34=Set/Get IO Mode       18=Get Rel Att Data     79/179=Set/Get Battery Info');
{11}writeln('11/37=Set/Get Src Mode      19=Get Battery Data                                ');
{12}writeln('12/36=Set/Get Analysis Mode 20=Get IO Data           92/93=Set/Get Printer Type');
{13}writeln('39/44=Set/Get TelCoil Mode  29=Get Level State       66/86=Set/Get Extnd Label ');
{14}writeln('40/41=Set/Get Rel Att Freq  31=Get Mic Input             6=Set Std Label       ');
{15}writeln('43/45=Set/Get Zeta State*   32=Get Dist Percent         89=Set Label Storage   ');
{16}writeln('47/46=Set/Get Insitu*       42=Get Last Curve       96/120=Set/Get Bitmap      ');
{17}writeln('48/49=Set/Get Automatic     57=Get RefMic Input      56/80=Set/Get Power State ');
{18}writeln('50/51=Set/Get Limit Value   61=Get Blob                                        ');
{19}writeln('52/53=Set/Get RefMic State  94=Get HFA Data             28=Get Version         ');
{20}writeln('54/55=Set/Get Active State                              33=Get Cmd Status      ');
{21}writeln('59/60=Set/Get Test State    "M"=More commands           95=Get Software Info   ');
{22}writeln('*=Deprecated                "K"=Keep port alive tgl');
{23}writeln('"H"=Help "M"=More "X"=Exit "B"=BuildCmd "V"=VrfyTgl "C"=ComPort');
{24}{writeln(' ');}
  pfunerr := 0;
end;

procedure domore;
begin
  writeln;
            { x                          x                           x                     e'}
{1} writeln('62/63=Set/Get Key Control   150/151=Set/Get User #      67=Do Error            ');
{2} writeln('72/58=Set/Get Key Code      166/167=Set/Get User ID     85=Do Measurement      ');
{3} writeln('73/74=Set/Get Poll Delay    192/193=Set/Get User Mode                          ');
{5} writeln('104/103=Set/Get Clock                                   68=Set Spectrum        ');
{6} writeln('106/105=Set/Get Output Dev  152/153=Set/Get Fit Type    69=Set Phase           ');
{7} writeln('108/107=Set/Get Impulse Rej 154/155=Set/Get Vent Type   99=Set Blob            ');
{8} writeln('112/113=Set/Get Crv Select  156/157=Set/Get Aid Tubing 147=Set Leveling State  ');
{9} writeln('114/115=Set/Get Crv Status  158/159=Set/Get Aid Chan.                          ');
{10}writeln('116/117=Set/Get Unaided     160/161=Set/Get Aid Lim.   176=Do Custom test      ');
{11}writeln('121/122=Set/Get Static Tone 162/163=Set/Get Ref Method 177=Do Parameters       ');
{12}writeln('123/124=Set/Get Aid Type    164/165=Set/Get Fit Param  178=Do Target           ');
{13}writeln('125/126=Set/Get Bias Tone   168/169=Set/Get Skew                               ');
{14}writeln('129/130=Set/Get Wrbl Select 170/171=Set/Get Scrn Mode  100=Get Device ID Count ');
{15}writeln('132/133=Set/Get Rcv Timeout 172/173=Set/Get Coupler    101=Get Long Device ID  ');
{16}writeln('134/135=Set/Get Fit Rule    174/175=Set/Get Analysis   102=Get Device Data     ');
{17}writeln('136/137=Set/Get Filter      180/181=Set/Get Parameter  109=Get Signal Info     ');
{18}writeln('138/139=Set/Get Compression 182/183=Set/Get Crv Group  110=Get Raw Sample Data ');
{19}writeln('140/141=Set/Get Client Age  184/185=Set/Get AGC Freq   111=Get Mic Cal Data    ');
{20}writeln('142/143=Set/Get Trans. Loc  186/187=Set/Get Input Port 131=Get Aid Delay Data  ');
{21}writeln('145/146=Set/Get Level List  188/189=Set/Get Polar Angle  "N"=Toggle show as int');
{22}writeln('148/149=Set/Get Aux Port*   190/191=Set/Get Diff Freq    "L"=Tgl comma delimit ');
{23}writeln('"X"=Exit "A"=Baudrate "O"=Monitor "T"=Timeout "B"=BuildCmd "H"=Help');
{24}writeln(' ');
  pfunerr := 0;
end;
{writeln('"X"=Exit "O"=Monitor "T"=Timeout "S"=ExtSwBox');}

{Commands currently not supported by the Test program (too complex) }

  {96,VARLEN,RS232Com_SetBitmap}        {set bitmap (printer)    }
  {110,3,RS232Com_GetRawSampleData}     {get raw sample data     }
  {111,2,RS232Com_GetMicCalibation}     {get mic cal info        }
  {118,VARLEN,RS232Coup_SetList}        {load user list (undocumented)}
  {119,1,RS232Coup_GetList}             {get user list (undocumented)}
  {120,6,RS232Com_GetBitmap}            {get screen/printer bitmap}
  {125,VARLEN,RS232Coup_SetBiasTone}    {set bias tone selection <future>}
  {126,0,RS232Coup_GetBiasTone}         {get bias tone selection <future>}
  {127,VARLEN,NULL}                     {<reserved for packet control>}
  {128,VARLEN,NULL}                     {<reserved for packet control>}
  {129,1,RS232Com_SetWarbleSelect}      {set warble selection    }
  {130,0,RS232Com_GetWarbleSelect}      {get warble selection    }

{-----------------------------------------------}
{special case letter commands}
procedure DoLetterCmd;
var temp:boolean;
begin
  if length(InputString) = 0 then Exit;
  case InputString[1] of
    'X','Q': begin
               killme := true;
               pfunerr := 0;
             end;
    'H','?': dohelp;
    'M': domore;
    'O': domon;
    'B': dobuild;
    'A': dobaud;
    'E': demandMode;
    'P': pollMode;

    'D': UseDoubleCheck := not(UseDoubleCheck);
    'N': UseShowInt := not(UseShowInt);
    'K': UseKeepAlive := not(UseKeepAlive);
    'L': UseDelimit := not(UseDelimit);
    'V': doverify;

   // 'W': doweird;
    'T': dopolltime;
    'G': dodebug;
    'C': doport;
    {//'S': doswitch;}
  end;
end;


{-----------------------------------------------}
{returns true if it is a number otherwise returns false}
function Cleanup(var Data:str255):boolean;
var i : integer;
var UseHex : boolean;
  function ValidNum:boolean;
  begin
    ValidNum := true;
    if Data[i] in['0','1','2','3','4','5','6','7','8','9','0','-','+','.'] then Exit;
    if UseHex then
      if Data[i] in ['A','B','C','D','E','F'] then Exit;
    ValidNum := false;
  end;
begin
  CleanUp := false;
  if length(Data) = 0 then Exit;
  while Data[1] < '!' do
  begin
    delete(Data,1,1);
    if length(Data) = 0 then Exit;
  end;
  for i := 1 to length(Data) do
    Data[i] := upcase(Data[i]);
  if not(Data[1] in['0','1','2','3','4','5','6','7','8','9','0','$']) then Exit;
  if Data[1] = '$' then
    UseHex := true
  else UseHex := false;

  if length(Data) > 1 then
  begin
    i := 2;
    while ValidNum do
      inc(i);
    if length(Data) > pred(i) then
      Data[0] := char(pred(i));
  end;
  CleanUp := true;
end;

{-----------------------------------------------}
procedure RunProgram;
var pt:boolean;
    ErrorType:integer;
    Num : integer;
    s,Pstr : str255;
    c : char;
    pcnt,Err,StartPort,itmp:integer;
    sMsg : string;
    sTmp : string;
    sTmp2 : string;
var cS : pchar;
var TL : longint;
var Baud : longint;
var CurrentPortMode : integer;
begin
  ErrorCode := 255;
  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  SetConsoleCtrlHandler(nil,false);
  UseKeepAlive := KeepAliveDefault;

  writeln(VerStr);      {writeln('Fryers RS232 Test Program - Version 5.0x as of  23 Aug 2002');}
  write(CopyrightStr);  {write('Copyright 1988,2002 Frye Electronics, Inc.  ');}
  writeln('(Win32 Version)');

  Fipp.UpdateFcomVersion(); //make sure version is up to date
  if (REG_RegistryValue(READ_REGISTRY_BOOLEAN,UseKeepAlive,Test32InitKey,'KEEP_ALIVE') = false) then
    UseKeepAlive := KeepAliveDefault;
  if (REG_RegistryValue(READ_REGISTRY_BOOLEAN,UseShowInt,Test32InitKey,'SHOW_INT') = false) then
    UseShowInt := ShowIntDefault;
  if (REG_RegistryValue(READ_REGISTRY_BOOLEAN,UseDoubleCheck,Test32InitKey,'DOUBLE_CHECK') = false) then
    UseDoubleCheck := DoubleCheckDefault;
  if (REG_RegistryValue(READ_REGISTRY_BOOLEAN,UseVerify,Test32InitKey,'CMD_VERIFY') = false) then
    UseVerify := VerifyDefault;
  if (REG_RegistryValue(READ_REGISTRY_BOOLEAN,UseDelimit,Test32InitKey,'SHOW_COMMAS') = false) then
    UseDelimit := DelimitDefault;

  UseDoubleCheck := true;
  UsePort := 0;
  pcnt := ParamCount;
  UseAutoSeek := 0; //false;
  StartPort := 0;
  Baud := 0;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    if upcase(Pstr[1]) = 'C' then
    begin
      if (Pstr[2] >= '0') or (Pstr[2] <= '9') then
      begin
        itmp := ord(Pstr[2]) and $f;
        if (Pstr[3] >= '0') or (Pstr[3] <= '9') then
        begin
          itmp := (itmp * 10) + (ord(Pstr[3]) and $f);
        end;
        StartPort := itmp;
      end;
      if StartPort > 99 then StartPort := 1;
      UsePort := StartPort;
    end
    else
    begin
      case upcase(Pstr[1]) of
      'B': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             case TL div 10 of
               960 : Baud := 9600;
               1920 : Baud := 19200;
               2880 : Baud := 28800;
               3840 : Baud := 38400;
               5760 : Baud := 57600;
               11520 : Baud := 115200;
               23040 : Baud := 230400;
               else
               begin
                 if TL > 0 then
                   Baud := TL
                 else Baud := 0;
               end; //endelse
             end;//endcase
           end; //end('B')

      'K': if Pstr[2] = '-' then
           UseKeepAlive := false
         else UseKeepAlive := true;

      'D': if Pstr[2] = '-' then
           UseDoubleCheck := false
         else UseDoubleCheck := true;

      'N': if Pstr[2] = '-' then
           UseShowInt := false
         else UseShowInt := true;

      'L':if Pstr[2] = '-' then
           UseDelimit := false
         else UseDelimit := true;

      'V': if Pstr[2] = '-' then
           UseVerify := false
         else UseVerify := true;

      'S': UseScript := true;
      'A': UseAutobaud := false;
      'T': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             Fipp.PollTimer := TL;
           end;
     end;
   end;
   dec(Pcnt);
  end;
  //if UseScript = true then UseDefinedCmd := true;
  if (Baud = 0) then UseAutobaud := true; //must have a valid baudrate

  if (FCOM_DllLoaded() <> SUCCESS) then
  begin
    ErrorCode := FEM_GetErrorMsg(Fipp.FippError,true,ErrorType,sMsg);
    writeln(sMsg);
    if (UseScript = true) then
    begin
      Halt(ErrorCode);
    end;
  end;

  if (UseKeepAlive = true) then
  begin
    if (TSUB_OpenPort() = false) then
    begin
      if (UseScript = true) then
      begin
        Halt(1);
      end;
    end
    else
    begin
      Fipp.GetFonixVersion(); //try to get the instrument model (ignore errors)
      SIG_UpdateHwSignature(true); //Collects current information to update signature info
    end;
  end;

  Fipp.Verify := UseVerify;
  Fipp.DoubleCheck := UseDoubleCheck;

  repeat
    sTmp := FS_IntToStr(Fipp.ThisComPort+1)+':'+FS_IntToStr(Fipp.ActiveBaudRate)+')';
    if UseKeepAlive = true then
      write('(K',sTmp)
    else write('(C',sTmp);
    if (Fipp.Verify = true) then
      sTmp := 'V+'
    else sTmp := 'V+';
    write(sTmp);

    Fipp.GetPortMode(CurrentPortMode);
    if (CurrentPortMode = 1) then sTmp2 := 'p'
    else if (CurrentPortMode = 2) then sTmp2 := 'd'
    else if (CurrentPortMode = 0) then sTmp2 := 'c'
    else sTmp2 := '?';
    //Add this if we ever get the FonixID unit translated to Pascal. For now, just show the model number
    //FID_GetInstrumentName(FD_Signature.InstrumentType, FD_Signature.InstrumentSubType, FD_Signature.InstrumentModel, sTmp);
    if (FD_Signature.InstrumentModel > 0) then
      sTmp := FS_IntToStr(FD_Signature.InstrumentModel)
    else sTmp := 'Unknown';
    write('[',sTmp,']',sTmp2,' ');
    write('Enter function to perform (H for help) : ');

    InputString := ' ';
    readln(InputString);
    if Cleanup(InputString) then
    begin
      val(InputString,Num,err);
      if err <> 0 then Num := -199;
    end
    else Num := -1;

    killme := false;
    Fipp.CmdStatusFailed := false;
    pfunerr := succ(Num);
    begin
      case Num of
       -1 : DoLetterCmd; //go do special letter command
        0 : dof0;
        1 : dof1;
        2 : dof2;
        3 : dof3;
        4 : dof4;
        5 : dof5;
        6 : dof6;
        7 : dof7;
        8 : dof8;
        9 : dof9;
        10 : dof10;
        11 : dof11;
        12 : dof12;
        13 : dof13;
        14 : dof14;
        15 : dof15;
        16 : dof16;
        17 : dof17;
        18 : dof18;
        19 : dof19;
        20 : dof20;
        21 : dof21;
        22 : dof22;
        23 : dof23;
        24 : dof24;
        25 : dof25;
        26 : dof26;
        27 : dof27;
        28 : dof28;
        29 : dof29;
        30 : dof30;
        31 : dof31;
        32 : dof32;
        33 : dof33;
        34 : dof34;
        35 : dof35;
        36 : dof36;
        37 : dof37;
        38 : dof38;
        39 : dof39;
        40 : dof40;
        41 : dof41;
        42 : dof42;
        43 : dof43;
        44 : dof44;
        45 : dof45;
        46 : dof46;
        47 : dof47;
        48 : dof48;
        49 : dof49;
        50 : dof50;
        51 : dof51;
        52 : dof52;
        53 : dof53;
        54 : dof54;
        55 : dof55;
        56 : dof56;
        57 : dof57;
        58 : dof58;
        59 : dof59;
        60 : dof60;
        61 : dof61;
        62 : dof62;
        63 : dof63;
        64 : dof64;
        65 : dof65;
        66 : dof66;
        67 : dof67;
        68 : dof68;
        69 : dof69;
        70 : dof70;
        71 : dof71;
        72 : dof72;
        73 : dof73;
        74 : dof74;
        75 : dof75;
        76 : dof76;
        77 : dof77;
        78 : dof78;

        79 : dof79;
        80 : dof80;
        81 : dof81;
        82 : dof82;
        83 : dof83;
        84 : dof84;
        85 : dof85;
        86 : dof86;
        87 : dof87;
        88 : dof88;
        89 : dof89;
        90 : dof90;
        91 : dof91;
        92 : dof92;
        93 : dof93;
        94 : dof94;
        95 : dof95;
        96 : dof96;
        97 : dof97;
        98 : dof98;
        99 : dof99;
       100 : dof100;
       101 : dof101;
       102 : dof102;
       103 : dof103;
       104 : dof104;
       105 : dof105;
       106 : dof106;
       107 : dof107;
       108 : dof108;
       109 : dof109;
       110 : dof110;
       111 : dof111;   {<get Cal Data>}
       112 : dof112;
       113 : dof113;
       114 : dof114;
       115 : dof115;
       116 : dof116;
       117 : dof117;
       118 : dof118;   {<set list> }
       119 : dof119;   {<get list> }
       120 : dof120;   {<get bitmap>}
       121 : dof121;
       122 : dof122;
       123 : dof123;
       124 : dof124;
       125 : dof125;
       126 : dof126;
       {127: <reserved> - packet control}
       {128: <reserved> - packet control}
       129 : dof129;
       130 : dof130;
       131 : dof131;
       132 : dof132;
       133 : dof133;
       134 : dof134;
       135 : dof135;
       136 : dof136;
       137 : dof137;
       138 : dof138;
       139 : dof139;
       140 : dof140;
       141 : dof141;
       142 : dof142;
       143 : dof143;
       144 : dof144; //<reserved> - factory automation - do calibration}
       145 : dof145;
       146 : dof146;
       147 : dof147;
       148 : dof148;
       149 : dof149;
       150 : dof150;
       151 : dof151;
       152 : dof152;
       153 : dof153;
       154 : dof154;
       155 : dof155;
       156 : dof156;
       157 : dof157;
       158 : dof158;
       159 : dof159;
       160 : dof160;
       161 : dof161;

       162 : dof162;
       163 : dof163;
       164 : dof164;
       165 : dof165;
       166 : dof166;
       167 : dof167;
       168 : dof168;
       169 : dof169;
       170 : dof170;
       171 : dof171;
       172 : dof172;
       173 : dof173;
       174 : dof174;
       175 : dof175;
       176 : dof176;
       177 : dof177;
       178 : dof178;
       179 : dof179;
       180 : dof180;
       181 : dof181;
       182 : dof182;
       183 : dof183;
       184 : dof184;
       185 : dof185;
       186 : dof186;
       187 : dof187;
       188 : dof188;
       189 : dof189;
       190 : dof190;
       191 : dof191;
       192 : dof192;
       193 : dof193;

        999 : begin {nop} killme := true; pfunerr := 0; end; {end program}
        //201: dofwakeup; //<-no longer supported (special case 6500 cmd) ->
        199 : begin {nop} killme := true; pfunerr := 0; end; {end program}
      else
        writeln('Invalid function');
      end;
    end;
    //if keepalive is false, close the port until we need it.
    if UseKeepAlive = false then Fipp.ClosePort();
    if (pfunerr > 0) and (Num <= succ(maxf)) then
      TSUB_PackErr;
    if UseScript = true then break;
    if Num <> -1 then
      writeln;
    if UseScript = true then break;
  until Killme or (Num > 999);
  ErrorCode := 0;
  Fipp.ClosePort;
  //Note: Keepalive, comport and Baudrate are only saved after a successful open of the com port
  //see OpenPort command.
  REG_RegistryValue(WRITE_REGISTRY_BOOLEAN,UseShowInt,Test32InitKey,'SHOW_INT');
  REG_RegistryValue(WRITE_REGISTRY_BOOLEAN,UseDelimit,Test32InitKey,'SHOW_COMMAS');
  REG_RegistryValue(WRITE_REGISTRY_BOOLEAN,UseDoubleCheck,Test32InitKey,'DOUBLE_CHECK');
  REG_RegistryValue(WRITE_REGISTRY_BOOLEAN,UseVerify,Test32InitKey,'CMD_VERIFY');

end;

begin
  fillchar(FD_Signature,sizeof(FD_Signature),0);
end.



