
{This is an extension of the TSunit for the Test and Test32 programs}
{It was added on because TSunit ran out of code space for 16bit systems}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.16 as of 26 July 2004 - med}
{12 Jun 2006 V5.20 -med added new commands and adapted battery commands for 7000}

{$N+,E+}
Unit TS2unit;
interface
uses Windows,SysUtils,FryeDefs,FCErrMsg,TestDefs,FippDefs,FonixSig,
     FryeComD,FryeStr,FryeTools,TestSubs,ShowData,LabelUnit;
{$APPTYPE CONSOLE}

{command procedures}
procedure dof0;   {set source amp}
procedure dof1;   {set distortion}
procedure dof2;   {set frequency}
procedure dof3;   {set OES state - obsolete; see cmd 172/173}
procedure dof4;   {set noise reduction}
procedure dof5;   {set smoothing}
procedure dof6;   {set label}
procedure dof7;   {set probe state - obsolete; see cmds 59/60}
procedure dof8;   {set weighting - obsolete; see cmds 12/36/136/137 }
procedure dof9;   {set curve frame}
procedure dof10;  {io mode}
procedure dof11;    {set telecoil state}
procedure dof12;       {set Analysis mode (was gain state)}
procedure dof13; {do relatt}
procedure dof14;      {set batt test mode (was do batt)}
procedure dof15;   {do io}
procedure dof16; {do test - obsolete - see 54/55}
procedure dof17;  {do level}
procedure dof18;   {rel Attack data}
procedure dof19;     {get batt}
procedure dof20;     {get io data}
procedure dof21; {get source amp}
procedure dof22;   {get dist mode}
procedure dof23;     {get freq}
procedure dof24;      {get OES state - obsolete; see cmds 172/173}
procedure dof25;        {get curve frame}
procedure dof26;         {get noise red}
procedure dof27;         {get smoothing}
procedure dof28;    {version}
procedure dof29;       {get level state}
procedure dof30;   {get weighting - obsolete; see cmds 12/36/136/137}
procedure dof31;       {get mic input value}
procedure dof32;      {get distortion reading}
procedure dof33;    {get cmd status}
procedure dof34;   {get io mode}
procedure dof35;   {get probe state - obsolete; see cmds 59/60}
procedure dof36;   {get analysis mode (was gain state)}
procedure dof37;    {get telecoil state}
procedure dof38;    {do reset}
procedure dof39;   {set tcoil mode }
procedure dof40;   {set rel att frq}
procedure dof41;  {get att/rel test freq}
procedure dof42;   {get last measured curve}
procedure dof43;   { set new zeta state - obsolete}
procedure dof44; {get tel coil mode}
procedure dof45;   { get Zeta state - obsolete}
procedure dof46;   {get insitu mode - obsolete}
procedure dof47;   {set insitu mode - obsolete}
procedure dof48;   { set new automatic state }
procedure dof49;   { get automatic state }
procedure dof50;   { set new limit value }
procedure dof51;   { get Ouput Limit value }
procedure dof52;   { set new refmic state }
procedure dof53;   { get RefMic state }
procedure dof54; {set active mode}
procedure dof55; {Get Active mode}
procedure dof56; {do Power control (was do sleep)}
procedure dof57; {get ref mic value}
procedure dof58; {get key scan code}
procedure dof59; {Set machine state}
procedure dof60; {Get machine state}
procedure dof61; {Get BLOB}
procedure dof62; {set control lock}
procedure dof63; {get key control}
procedure dof64; {Do line feeds}
procedure dof65; {do print }
procedure dof66;    {set extended label}
procedure dof67;    {do error}
procedure dof68; {Set spectrum array}
procedure dof69; {Set phase array}
procedure dof70; {Set test params (was option params)}
procedure dof71; {Get test params (was option params)}
procedure dof72; {set key scan code}
procedure dof73; {set POLL DELAY}
procedure dof74; {get POLL DELAY}
procedure dof75; {set test ear}
procedure dof76; {get test ear}
procedure dof77;   { set new operation state }
procedure dof78;   { get operating state }
procedure dof79; {set batt type}
procedure dof80; {Get power status}
procedure dof81; {get avg freqs}
procedure dof82; {set avg freqs}
procedure dof83; {get measurement settle delay}
procedure dof84; {set measurement settle DELAY}
procedure dof85; {do measurement}
procedure dof86;    {get extended label}
procedure dof87;      {get CIC state - obsolete; see 172/173}
procedure dof88;      {Set CIC state - obsolete; see 172/173}
procedure dof89;    {set default label}
procedure dof90; {set avg DELAY time}
procedure dof91; {get avg delay time}
procedure dof92; {set printer type}
procedure dof93; {get printer Type}
procedure dof94; {get HFA measurement}
procedure dof95; {get software info}
procedure dof96; {set printer label bitmap}
procedure dof97; {set A&R Params}
procedure dof98; {get attack and release}
procedure dof99; {Set BLOB}

{--> See TS2Unit for cmds 100 and above <--}

implementation


{------------------------------------------------}
procedure dof0;   {set source amp}
var tmp:single;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSourceAmp()) then Exit;
  writeln('(21) Current source = ',Fipp.SourceAmp div 100,'dB');
  write('Enter new Source Amp value (50, 60, etc. 0=off) : ');
  readln(tmp);
  if tmp > 300 then Exit;
  Fipp.SourceAmp := trunc(tmp * 100);
  if not(Fipp.SetSourceAmp()) then Exit;
  writeln('(0) New source = ',FS_DbStr(Fipp.SourceAmp,true));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof1;   {set distortion}
var Temp : integer;
begin
  begin
    if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetDistmode()) then Exit;
    write('(22) Current Distortion mode = ');
    case Fipp.DistMode of
      0 : writeln('None  (0)');
      1 : writeln('2nd   (1)');
      2 : writeln('3rd   (2)');
      3 : writeln('Total (3)');
    else
      writeln(Fipp.DistMode);
    end;
    write('Enter new Distortion mode value (0=Off, 1=2nd, 2=3rd, 3=Tot): ');
    readln(temp);
    Fipp.Distmode := temp;
    if not(Fipp.SetDistmode()) then Exit;
    write('(1) New Distortion mode = ');
    case Fipp.DistMode of
      0 : writeln('None  (0)');
      1 : writeln('2nd   (1)');
      2 : writeln('3rd   (2)');
      3 : writeln('Total (3)');
    else
      writeln(Fipp.DistMode);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof2;    {set frequency}
var Temp:integer;
begin
    if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetFrequency()) then Exit;
    write('(23) Current Frequency = ');
    if Fipp.Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Fipp.Frequency,'Hz');
    write('Enter new Frequency : ');
    readln(temp);
    Fipp.Frequency := temp;
    if not(Fipp.SetFrequency()) then Exit;
    write('(2) New Frequency = ');
    if Fipp.Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Fipp.Frequency,'Hz');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof3;  {obsolete - see set coupler state (172/173}
var Temp:integer;
begin
    if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetOESstate()) then Exit;
    writeln('<- Obsolete command - see commands 172 and 173 ->');
    writeln('(24) Current OES state = ',FS_OnOff(Fipp.OESstate));
    write('Enter new OES state (0=off 1=on) : ');
    readln(temp);
    Fipp.OESstate := temp;
    if not(Fipp.SetOESstate()) then Exit;
    writeln('(3) New OES state = ',FS_OnOff(Fipp.OESstate));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof4;   {set noise reduction}
var Temp:integer;
begin
    if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetNoiseRedCount()) then Exit;
    writeln('(24) Current Noise Reduction Count = ',Fipp.NoiseRedCount);
    write('Enter new Noise Reduction Count (0, 2, 4, 8, 16) : ');
    readln(temp);
    Fipp.NoiseRedCount := temp;
    if not(Fipp.SetNoiseRedCount()) then Exit;
    writeln('(4) New Noise Reduction Count = ',Fipp.NoiseRedCount);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof5;   {set smoothing}
var Temp:integer;
begin
    if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetSmoothState()) then Exit;
    write('(27) Current Smoothing = ',Fipp.SmoothState);
    case Fipp.SmoothState of
     0: writeln(' (OFF)');
     1: writeln(' (100Hz) <- obsolete parameter ->');
     2: writeln(' (Log)');
    end;
    write('Enter new Smoothing (0=off 1=100Hz, 2=Log) : ');
    readln(temp);
    Fipp.SmoothState := temp;
    if not(Fipp.SetSmoothState()) then Exit;
    write('(5) New Smoothing State = ',Fipp.SmoothState);
    case Fipp.SmoothState of
     0: writeln(' (OFF)');
     1: writeln(' (100Hz) <- obsolete parameter ->');
     2: writeln(' (Log)');
    end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof6;    {set label}
begin
    if (TSUB_OpenPort() = false) then Exit;
  LU_EnterStdLabel(LabelText);   {enter the label into LabelText}
  FS_StringToPchar(fipp.StdLabelData,LabelText,FIPP_NUM_STD_LABEL_CHAR); {convert it to a 2D pchar array}
  Fipp.ConvertLabelToSend(FIPP_NUM_STD_LABEL_CHAR,fipp.StdLabelData);    {stuff it into the cmd send array}
  Fipp.CmdArray.Size := FIPP_NUM_STD_LABEL_CHAR div 2; {set number of words to send}
  if not(Fipp.SetStdLabel()) then Exit;    {Send the label}
  writeln;
  writeln('(6) * Label Sent *');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof7; {set probe state - obsolete - see cmds 59/60}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetProbeState()) then Exit;
  writeln('<- Obsolete command - see commands 59 and 60 ->');
  writeln('(35) Current Probe State = ',FS_OnOff(Fipp.ProbeState));
  write('Enter new Probe State (0=off 1=on) : ');
  readln(temp);
  Fipp.ProbeState := temp;
  if not(Fipp.SetProbeState()) then Exit;
  writeln('(7) New Probe State = ',FS_onoff(Fipp.ProbeState));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof8;  {set weighting - obsolete see cmds 12/36/136/137}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetWeightState()) then Exit;
    writeln('<- Obsolete command - see commands 12, 36, 136 and 137 ->');
    write('(30) Current Weight State = ');
    case Fipp.WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power ');
      2 : writeln('(2) Weighted Gain');
    else
      writeln(Fipp.WeightState);
    end;
    write('Enter new Weight State (0=Flat 1=Power 2=Gain) : ');
    readln(temp);
    Fipp.WeightState := temp;
    if not(Fipp.SetWeightState()) then Exit;
    write('(8) New Weight State = ');
    case Fipp.WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power ');
      2 : writeln('(2) Weighted Gain');
    else
      writeln(Fipp.WeightState);
    end;
  pfunerr := 0;
end;

{-------}
procedure dof9;                         {set curve frame}
type tCrv = array[0..MaxCurveSize] of INT16;
type ptCrv = ^tCrv;
var i,ii : integer;
    temp:integer;
    What:string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    pCrv : ptCrv;
begin
  if (TSUB_OpenPort() = false) then Exit;
    write('Enter Curve Number to Send (0-13) : ');
    readln(temp);
    Fipp.CurveNumber := temp;
    What := 'curve'+FS_IntStr(Fipp.CurveNumber)+'.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      reset(fc);
      pCrv := ptCrv(@Fipp.CurveFrame);
      for i := 0 to pred(MaxCurveSize) do
      begin
        readln(fc,pCrv[i]);
        if eof(fc) then break;
      end;
      close(fc);
    end;
    if not(Fipp.SetCurveFrame()) then Exit;
    write('Crv ',Fipp.CurveNumber,':');
    SD_ShowCurve(@Fipp.CurveFrame);
  pfunerr := 0;
end;


{-----}
procedure dof10;              {io mode}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
     if Fipp.GetIOmode() = false then Exit;
     write('(34) Current IO Test Frequency = ');
     if Fipp.IOFrequency = 0 then writeln('Composite (0Hz)')
     else writeln(Fipp.IOfrequency);
     if Fipp.IOgain = 0 then writeln('  In Amplitude mode (0)')
     else writeln('  In Gain mode (1)');
     if (Fipp.IOModeCount > 2) then
     begin
       writeln('Current IO Start Delay  = ',Fipp.IOStartMs,' (mS)');
       writeln('Current IO Sweep Settle = ',Fipp.IOSweepMs,' (mS)');
     end;

     write('Enter new IO Test Frequency : ');
     readln(temp);
     Fipp.IOFrequency := temp;
     write('Enter new IO Gain mode (0=Amplitude 1=Gain) : ');
     readln(temp);
     Fipp.IOgain := temp;
     if (Fipp.IOModeCount > 2) then
     begin
       write('Enter new Start Delay (milliseconds): ');
       readln(temp);
       Fipp.IOStartMS := temp;
       write('Enter new Sweep Settle (milliseconds) : ');
       readln(temp);
       Fipp.IOSweepMs := temp;
     end;

     if not(Fipp.SetIOmode()) then Exit;

     write('(10) New IO Test Frequency = ');
     if Fipp.IOFrequency = 0 then writeln('Composite (0Hz)')
     else writeln(Fipp.IOfrequency);
     if Fipp.IOgain = 0 then writeln('  In Amplitude mode (0)')
     else writeln('  In Gain mode (1)');
     if (Fipp.IOModeCount > 2) then
     begin
       writeln('New IO Start Delay  = ',Fipp.IOStartMs,' (mS)');
       writeln('New IO Sweep Settle = ',Fipp.IOSweepMs,' (mS)');
     end;
  pfunerr := 0;
end;

function SrcMethodStr(SrcMethod:integer):str255;
begin
  if (SrcMethod = 0) then
    Result := '(0) dBSPL'
  else if (SrcMethod = 1) then
    Result := '(1) Tcoil'
  else if (SrcMethod = 2) then
    Result := '(2) Vrms'
  else Result := '('+FS_IntToStr(SrcMethod)+')';
end;

{------}
procedure dof11;    {set telecoil state}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSourceMethod()) then Exit;
  writeln('(37) Current Source Method = ', SrcMethodStr(Fipp.SourceMethod)); //was telecoilstate
  write('Enter new Source Method (0=dBSPL, 1=Tcoil, 2=Vrms) : ');
  readln(temp);
  Fipp.SourceMethod := temp;
  if not(Fipp.SetSourceMethod()) then Exit;
  writeln('(11) New Source Method = ', SrcMethodStr(Fipp.SourceMethod)); //was telecoilstate
  pfunerr := 0;
end;

{-----}
procedure dof12;  {Set Measurement Analysis Display Mode (gain/spl/3rd oct)}
var Temp:integer;
begin
    if not(Fipp.GetAnalysisMode()) then Exit;
    write('(36) Current Analysis Mode = ');
    case Fipp.AnalysisMode of  //Was GainState
      0 : writeln('Amplitude (100Hz FFT SPL)');
      1 : writeln('Gain (100Hz FFT Gain)');
      2 : writeln('3rd Oct SPL');
    else
      writeln(Fipp.AnalysisMode); //was gainstate
    end;
    write('Enter New Analysis Mode (0=100Hz SPL, 1=Gain, 2=3rd Oct) : ');
    readln(temp);
    Fipp.AnalysisMode := temp;
    if not(Fipp.SetAnalysisMode()) then Exit;  //was gainstate
    write('(12) New Analysis Mode = ');
    case Fipp.AnalysisMode of  //was GainState
      0 : writeln('Amplitude (100Hz FFT SPL)');
      1 : writeln('Gain (100Hz FFT Gain)');
      2 : writeln('3rd Oct SPL');
    else
      writeln(Fipp.AnalysisMode);  //was gainstate
    end;
  pfunerr := 0;
end;

{-------}
procedure dof13; {do relatt}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  writeln('Current Release Attack State = ',FS_onoff(Fipp.RelAttState));
  write('Enter new Release Attack State (0=OFF 1=ON) : ');
  readln(temp);
  Fipp.RelAttState := temp;
  if not(Fipp.DoRelAttSelect()) then Exit;
  writeln('(13) New Release Attack State = ',FS_onoff(Fipp.RelAttState));
  pfunerr := 0;
end;

{--------}
procedure dof14;            {do batt}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  {make sure we know what instrument is out there with getFonixVersion}
  if (Fipp.GetFonixVersion() = false) then Exit;

  {First try to turn on the battery test to see if the feature is available}
  Fipp.CmdArray.Size := 1;
  Fipp.CmdArray.Data[0] := 1;
  if (Fipp.SetBatteryTest() = false) then
  begin
    {no parameters allowed, so set length to 0 and try again}
    Fipp.BatteryTestEnable := INVALID_DATA16;
    Fipp.CmdArray.Size := 0;
    if Fipp.SetBatteryTest() then Exit;
    writeln('Battery test done');
  end
  else
  begin
    write('(14) Enter battery test state (0=OFF 1=ON) : ');
    readln(temp);
    Fipp.BatteryTestEnable := temp;
    if not(Fipp.SetBatteryTest()) then Exit;
  end;
  pfunerr := 0;
end;

{-------}
procedure dof15;   {do io}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  writeln('Current IO select state = ',FS_onoff(Fipp.IOstate));
  write('Enter new IO Select State (0=OFF 1=ON) : ');
  readln(temp);
  Fipp.IOstate := temp;
  if not(Fipp.DoIOSelect()) then Exit;
  if Fipp.IOstate <> 0 then writeln('IO measurement has been performed');
  writeln('New IO select state = ',FS_onoff(Fipp.IOstate));
  pfunerr := 0;
end;

{-------}
procedure dof16; {do test - obsolete see 54/55}
begin
  if (TSUB_OpenPort() = false) then Exit;
  writeln('<- Deprecated command - see commands 54 and 55 ->');
  if not(Fipp.DoTest()) then Exit;
  writeln('(16) Test (Start/Stop) has been initiated.');
  pfunerr := 0;
end;

{------}
procedure dof17;  {do level}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.DoLevel()) then Exit;
  writeln('(17) Leveling in progress...');
  if not(Fipp.GetLevelState()) then Exit;
  writeln('Current Leveling = ');
  TSUB_LevelingStatus();
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof18;   {rel Attack data}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRelAttData()) then Exit;
  writeln('Attack time: ',Fipp.AttackTime,'Ms  Release Time: ',Fipp.ReleaseTime,
          'Ms   at ',Fipp.RelAttFreq,'Hz');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof19;     {get batt}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetBatteryData()) then Exit;
  writeln('Battery current   = ',FS_Str3D(Fipp.BatteryCurrent),' ma');
  WRITELN('Battery Type      = ','   ',Fipp.BatteryType);
  if Fipp.RspArray.Size > 2 then
    writeln('Battery Voltage   = ',FS_Str2d(Fipp.BatteryVolt),' V');
  if Fipp.RspArray.Size > 3 then
    WRITELN('Battery Impedence = ',FS_Str2d(Fipp.BatteryImp),' Ohms');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof20;     {get io data}
var i:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetIOdata()) then Exit;
  write('IO Curve: ',Fipp.IOcurve[0]);
  for i := 1 to 9 do write(FS_Str2d(integer(Fipp.IOcurve[i])));
  writeln;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof21; {get source amp}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSourceAmp()) then Exit;
  writeln('(21/0) Current Source Amplitude = ',FS_DbStr(Fipp.SourceAmp,true));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof22;   {get dist mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetDistMode()) then Exit;
  write('(22/1) Current Distortion mode = ');
  case Fipp.DistMode of
    0 : writeln('None  (0)');
    1 : writeln('2nd   (1)');
    2 : writeln('3rd   (2)');
    3 : writeln('Total (3)');
  else
    writeln(Fipp.DistMode);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof23;     {get freq}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFrequency()) then Exit;
  write('(23/2) Current Frequency = ');
  if Fipp.Frequency = 0 then
    writeln('Composite (0Hz)')
  else
    writeln(Fipp.Frequency,'Hz');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof24;      {get OES state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetOESstate()) then Exit;
  writeln('<- Obsolete command - see commands 172 and 173 ->');
  writeln('OES is ',FS_onoff(Fipp.OESstate));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof25;        {get curve frame}
type tCrv = array[0..MaxCurveSize] of INT16;
type ptCrv = ^tCrv;
var i,ii : integer;
    Temp : integer;
    N : longint;
    fc:text;
    pCrv : ptCrv;
begin
  if (TSUB_OpenPort() = false) then Exit;
    pCrv := @Fipp.CurveFrame;
    write('Enter Curve Number to Get (0-13) : ');
    readln(temp);
    Fipp.CurveNumber := temp;
    if not(Fipp.GetCurveFrame()) then Exit;
    write('Crv ',Fipp.CurveNumber,':');
    SD_ShowCurve(@Fipp.CurveFrame);
    assign(fc,'curve'+FS_IntStr(Fipp.CurveNumber)+'.DAT');
    rewrite(fc);
    for i := 0 to pred(Fipp.CurveFrameSize) do
    begin
      if UseShowInt = true then
        N := smallint(pCrv[i])
      else N := word(pCrv[i]);
      if (UseDelimit = true) and (i < pred(Fipp.CurveFrameSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof26;         {get noise red}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetNoiseRedCount()) then Exit;
  writeln('(26/4) Current Noise Reduction Count = ',Fipp.NoiseRedCount);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof27;         {get smoothing}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSmoothState()) then Exit;
  write('(27/5) Smoothing is: ',Fipp.SmoothState);
  case Fipp.SmoothState of
   0: writeln(' (OFF)');
   1: writeln(' (100Hz)');
   2: writeln(' (Log)');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof28;    {version}
var s:str255;
    ps : array[0..256] of char;
    bt:boolean;
begin
  writeln;
  if (TSUB_OpenPort() = false) then Exit;
   bt := (Fipp.GetFonixVersion());
   if not bt then bt := (Fipp.GetFonixVersion()); {try again if didn't make it}
   if bt then
   begin
    SIG_UpdateHwSignature(false); //Collects current information to update signature info
    //DeviceType := FD_Signature.InstrumentModel;
    s := FS_IntStr(FD_Signature.SoftwareVersion div 100) + '.';
    if FD_Signature.SoftwareVersion mod 100 < 10 then s := s + '0';
    S := s + FS_IntStr(FD_Signature.SoftwareVersion mod 100);
    writeln('Version: ',s,'      ');
    writeln('Options: ',FS_hexL(FD_Signature.StdOptions));
    writeln('Custom : ',FS_hexL(FD_Signature.CstOptions));
    if word(FD_Signature.InstrumentModel) = $8000 then
      write('Machine: ',0,' (6500)')
    else
      write('Machine: ',FD_Signature.InstrumentModel);

    if FD_Signature.InstrumentBaseType = 35 then
    begin
      if FD_Signature.InstrumentSubType = 1 then
        write('  (FP35-vga)')
      else
        write('  (FP35)');
    end
    else if (FD_Signature.InstrumentBaseType = 40) then
    begin
      if (FD_Signature.InstrumentSubType and 1 = 1) then write('  (FP40-D)')
      else write('  (FP40)');
    end
    else if (FD_Signature.InstrumentBaseType >= 100) and (FD_Signature.InstrumentBaseType < 200) then
        write('  (FA',FD_Signature.InstrumentBaseType-90,')')
    else if WORD(FD_Signature.InstrumentBaseType) = $FFFF then
      write('  (Fake)')
    else if (FD_Signature.InstrumentModel = 0) then  //if model = 0, then this may not be a valid instrument number
      write('  (?)');                     //so show the ? to indicate we aren't sure
    writeln;
    if word(FD_Signature.InstrumentSubType) = $8000 then
      writeln('SubType: ',0)
    else
    begin
      write('SubType: ',FD_Signature.InstrumentSubType);
      if FD_Signature.InstrumentBaseType = 40 then
      begin
        case FD_Signature.InstrumentSubType and $06 of
          0: write('  Portable');  {original fp40}
          1: write('  Desktop');   {original fp40}
          2: write('  Portable (LCD)'); {94 version}
          3: write('  Desktop (LCD)');  {94 version}
          4: write('  Portable (VGA)'); {94 version}
          5: write('  Desktop (VGA)');  {94 version}
        end;
      end;
      writeln;
    end;
    if (Fipp.FonixVersionSize > 7) then
    begin
      writeln('Model  : ',FD_Signature.InstrumentModel);
    end;
    //DeviceType := fipprec.version[5];
   end
   else
   begin
     writeln('** Warning ** Communication failure **');
   end;
   writeln('-----------------------');
   //UpdateFryersInfo(FIPPrec);
   S := FS_GetVersionString(Fipp.PortStatus.FcomVersion,2); //FverStr();
   writeln('Fryers :  Version ',s);
   write('Using  :  COM',succ(Fipp.ThisComPort));
   write('  at ',Fipp.ActiveBaudRate,' Baud');
   if UseAutoBaud then write(' (Autobaud)');
   writeln;
   if Fipp.PortStatus.FComVersion < 600 then
   begin
     writeln('-> The version of the Fryers driver you are using is out of date <-');
   end;
   writeln;

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof29;       {get level state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetLevelState()) then Exit;
  writeln('(29) Current Leveling = ');
  TSUB_LevelingStatus();

//  case Fipp.LevelState of
//    0 : writeln('Leveled      (0)');
//    1 : writeln('Semi-leveled (1)');
//    2 : writeln('Un-leveled   (2)');
//  else
//    writeln(Fipp.LevelState);
//  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof30;   {get weighting - obsolete}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetWeightState()) then Exit;
    writeln('<- Obsolete command - see commands 12, 36, 136 and 137 ->');
    write('(30/8) Current Weight State = ');
    case Fipp.WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power');
      2 : writeln('(2) Weighted Gain');
    else
      writeln('(',Fipp.WeightState,')');
    end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof31;       {get mic input value}
begin
  begin
    if not(Fipp.GetMicData()) then Exit;
    writeln('Current Microphone Input = ',FS_Str3D(Fipp.MicData),'dB');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof32;      {get distortion reading}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetDistPercent()) then Exit;
  writeln('Current Distortion = ',FS_Str3D(Fipp.DistPercent),'%');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof33;    {get cmd status}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCmdStatus()) then Exit;
  writeln('Command Result Status = ',Fipp.CmdStatus);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof34;   {get io mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetIOmode()) then Exit;
  write('(34/10) Current IO Test Frequency = ');
  if Fipp.IOFrequency = 0 then writeln('Composite (0Hz)')
  else writeln(Fipp.IOfrequency);
  if Fipp.IOgain = 0 then writeln('  In Amplitude mode (0)')
  else writeln('  In Gain mode (1)');
  if (Fipp.IOModeCount > 2) then
  begin
    writeln('Current IO Start Delay  = ',Fipp.IOStartMs,' (mS)');
    writeln('Current IO Sweep Settle = ',Fipp.IOSweepMs,' (mS)');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof35;   {get probe state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetProbeState()) then Exit;
  writeln('<- Obsolete command - see commands 59 and 60 ->');
  Writeln('(35/7) Probe State is ',FS_onoff(Fipp.ProbeState));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof36;   {get Measurement Analysis Display Mode (gain/spl/3rd oct)}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAnalysisMode()) then Exit;  {was GainState}
  write('Curve data is shown as ');
  case Fipp.AnalysisMode of
    0 : writeln('0 - Amplitude (100Hz FFT SPL)');
    1 : writeln('1 - Gain (100Hz FFT Gain)');
    2 : writeln('2 - 3rd Oct SPL');
  else
    writeln(Fipp.AnalysisMode);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof37;   {get Source Method - was get telecoil state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSourceMethod()) then Exit;
  writeln('(37/11) Current TeleCoil State = ',SrcMethodStr(Fipp.SourceMethod));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof38;    {do reset}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.DoReset()) then Exit;
  writeln('Reset has been performed');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof39;   {set tcoil mode }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTelCoilMode()) then Exit;
  write('Current Telecoil mode = ');
  case Fipp.TelCoilMode of
    0 : writeln('Composite (0)');
    1 : writeln('ANSI      (1)');
    2 : writeln('IEC       (2)');
  else
    writeln('** Invalid Telecoil mode **');
  end;
  write('Enter new TelCoil Mode (0=Composite, 1=ANSI, 2=IEC): ');
  readln(temp);
  Fipp.TelCoilMode := temp;
  if not(Fipp.SetTelCoilMode()) then Exit;
  write('Current Telecoil mode = ');
  case Fipp.TelCoilMode of
    0 : writeln('Composite (0)');
    1 : writeln('ANSI      (1)');
    2 : writeln('IEC       (2)');
  else
    writeln('** Invalid Telecoil mode **');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof40;   {set rel att frq}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRelAttFreq()) then Exit;
  writeln('Current Attack Release Test Frequency = ',Fipp.RelAttFreq,'Hz');
  writeln('Frequencies: 1600,2000,2500,0');
  write('Enter new Attack Release Test Frequency : ');
  readln(temp);
  Fipp.RelAttFreq := temp;
  if not(Fipp.SetRelAttFreq()) then Exit;
  writeln('New Attack Release Test Frequency = ',Fipp.RelAttFreq,'Hz');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof41;  {get att/rel test freq}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRelAttFreq()) then Exit;
  writeln('Current Attack Release Test Frequency = ',Fipp.RelAttFreq,'Hz');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof42;   {get last measured curve}
type tCrv = array[0..MaxCurveSize] of INT16;
type ptCrv = ^tCrv;
var i,ii : integer;
    N : longint;
    fc:text;
    pCrv : ptCrv;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetLastCurve()) then Exit;
  pCrv := @Fipp.CurveFrame;
  write('Curve:');
  SD_ShowCurve(@Fipp.CurveFrame);
  assign(fc,'LCURVE.DAT');
  rewrite(fc);
  for i := 0 to pred(Fipp.CurveFrameSize) do
  begin
    if (UseShowInt = true) then
      N := smallint(pCrv[i])
    else N:= word(pCrv[i]);
    if (UseDelimit = true) and (i < pred(Fipp.CurveFrameSize)) then
      write(fc,N,',')
    else writeln(fc,N);
  end;
  close(fc);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof43;   { set new zeta state  - obsolete}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetZetaState()) then Exit;
  writeln('<- Obsolete command - Zeta test is no longer supported ->');
  writeln('Current Zeta State = ',FS_OnOff(Fipp.ZetaState));
  write('Enter new Zeta State (0=off 1=on) : ');
  readln(temp);
  Fipp.ZetaState := temp;
  if not(Fipp.SetZetaState()) then Exit;
  writeln('New Zeta State = ',FS_onoff(Fipp.ZetaState));
  pfunerr := 0;
end;



{-----------------------------------------------}
procedure dof44; {get tel coil mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTelCoilMode()) then Exit; {always returns true}
  write('Current Telecoil mode = ');
  case Fipp.TelCoilMode of
   0 : writeln('Composite (0)');
   1 : writeln('ANSI      (1)');
   2 : writeln('IEC       (2)');
  else
    writeln('** Invalid Telecoil mode **');
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof45;   { get Zeta state - obsolete }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetZetaState()) then Exit;
  writeln('<- Obsolete command - Zeta test is no longer supported ->');
  Writeln('Zeta State is ',FS_onoff(Fipp.ZetaState));
  pfunerr := 0;
end;


{-----}
procedure dof46;   {get insitu mode - obsolete }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetInsitu()) then Exit;
  writeln('<- Obsolete command - no longer supported ->');
  writeln('Current Insitu is = ',FS_onoff(Fipp.Insitu[0]));
  write  ('Output Correction = ');
  case Fipp.Insitu[1] of
    0: writeln('None');
    1: writeln('OES + Insertion gain');
    2: writeln('OES only');
    3: writeln('Insertion gain only');
  end;
  write  ('Source Correction = ');
  case Fipp.Insitu[2] of
    0: writeln('None');
    1: writeln('ITE');
    2: writeln('BTE');
    3: writeln('ITC');
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof47;   {set insitu mode - obsolete }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  writeln('<- Obsolete command - no longer supported ->');
  writeln('Current Insitu is = ',FS_onoff(Fipp.Insitu[0]));
  write  ('Output Correction = ');
  case Fipp.Insitu[1] of
    0: writeln('None');
    1: writeln('OES + Insertion gain');
    2: writeln('OES only');
    3: writeln('Insertion gain only');
  end;
  write  ('Source Correction = ');
  case Fipp.Insitu[2] of
    0: writeln('None');
    1: writeln('ITE');
    2: writeln('BTE');
    3: writeln('ITC');
  end;

  write('Enter new Insitu State (0=OFF 1=ON) : ');
  readln(temp);
  Fipp.Insitu[0] := temp;
  write('Enter new Output correction (0=none,1=OES+INS,2=OES,3=INS) : ');
  readln(temp);
  Fipp.Insitu[1] := temp;
  write('Enter new Source correction (0=none,1=ITE,2=BTE,3=ITC) : ');
  readln(temp);
  Fipp.Insitu[2] := temp;

  if not(Fipp.SetInsitu()) then Exit;

  writeln('    New Insitu is = ',FS_onoff(Fipp.Insitu[0]));
  write  ('Output Correction = ');
  case Fipp.Insitu[1] of
    0: writeln('None');
    1: writeln('OES + Insertion gain');
    2: writeln('OES only');
    3: writeln('Insertion gain only');
  end;
  write  ('Source Correction = ');
  case Fipp.Insitu[2] of
    0: writeln('None');
    1: writeln('ITE');
    2: writeln('BTE');
    3: writeln('ITC');
  end;
  pfunerr := 0;
end;


{------}
procedure dof48;   { set new automatic state }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;


  if not(Fipp.GetAutoState()) then Exit;
  //send the results back immediatly to see if it is ok
  if not(Fipp.SetAutoState()) then
  begin
    //if failed, assume it is because it doesn't support 2 parameters (old fp35 bug)
    Fipp.AutoStateSize := 1;  //so force size to one parameter
  end;

  write('Current Automatic State = (',Fipp.AutoState,') ');
  case Fipp.AutoState of
    0: writeln('Manual');
    1: writeln('Automatic');
  else writeln;
  end;
  if (Fipp.AutoStateSize > 1) then
  begin
    writeln('Duration: ',Fipp.AutoStepDuration,'mS');
  end;

  write('Enter new Operation State (0=Manual 1=Automatic) : ');
  readln(temp);
  Fipp.AutoState := temp;
  if (Fipp.AutoStateSize > 1) then
  begin
    write('Enter new step duration (milliseconds) : ');
    readln(temp);
    Fipp.AutoStepDuration := temp;
  end;

  if not(Fipp.SetAutoState()) then Exit;

  write('New Automatic State = (',Fipp.AutoState,') ');
  case Fipp.AutoState of
    0: writeln('Manual');
    1: writeln('Automatic');
  else writeln;
  end;
  if (Fipp.AutoStateSize > 1) then
  begin
    writeln('Duration: ',Fipp.AutoStepDuration,'mS');
  end;
  pfunerr := 0;
end;



{-------}
procedure dof49;   { get automatic state - }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAutoState()) then Exit;
  write('Current Automatic State = (',Fipp.AutoState,') ');
  case Fipp.AutoState of
    0: writeln('Manual');
    1: writeln('Automatic');
  end;
  if (Fipp.AutoStateSize > 1) then
  begin
    writeln('Duration: ',Fipp.AutoStepDuration,'mS');
  end;
  pfunerr := 0;
end;


{------}
procedure dof50;   { set new limit value }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetLimitValue()) then Exit;
  writeln('Current Output Limit Value = ',FS_Str2D(Fipp.LimitValue),'dB');
  write('Enter new Output Limit Value : ');
  readln(temp);
  Fipp.LimitValue := temp*100;
  if not(Fipp.SetLimitValue()) then Exit;
  writeln('New Ouput Limit Value = ',FS_Str2D(Fipp.LimitValue),'dB');
  pfunerr := 0;
end;



{----------}
procedure dof51;   { get Ouput Limit value - }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetLimitValue()) then Exit;
  Writeln('Output Limit Value is ',FS_Str2D(Fipp.LimitValue),'dB');
  pfunerr := 0;
end;


{---------}
procedure dof52;   { set new refmic state }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRefMicState()) then Exit;
  writeln('Current RefMic State = ',FS_OnOff(Fipp.RefMicState));
  write('Enter new RefMic State (0=off 1=on) : ');
  readln(temp);
  Fipp.RefMicState := temp;
  if not(Fipp.SetRefMicState()) then Exit;
  writeln('New RefMic State = ',FS_onoff(Fipp.RefMicState));
  pfunerr := 0;
end;


{-------}
procedure dof53;   { get RefMic state - }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRefMicState()) then Exit;
  Writeln('RefMic State is ',FS_onoff(Fipp.RefMicState));
  pfunerr := 0;
end;

{---------}
procedure dof54; {set active mode}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetActiveStatus()) then Exit;
  writeln('Current Active State = ',FS_OnOff(Fipp.ActiveStatus));
  write('Enter new Active State (0=off 1=on) : ');
  readln(temp);
  Fipp.ActiveStatus := temp;
  if not(Fipp.SetActiveStatus()) then Exit;
  writeln('New Active State = ',FS_onoff(Fipp.ActiveStatus));
  pfunerr := 0;
end;


{---------}
procedure dof55; {Get Active mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetActiveStatus()) then Exit;
  Writeln('Active State is ',FS_onoff(Fipp.ActiveStatus));
  pfunerr := 0;
end;


function PowerStateStr(value:integer):str255;
begin
  if (Value = 2) then
    Result := 'Power is OFF (2)'
  else if (Value = 1) then
    Result := 'Sleep mode (1)'
  else if (Value = 0) then
    Result := 'Power in ON (0)'
  else Result := '?('+FS_IntToStr(Value)+')';
end;

{----------}
{Note: the 6500 is no longer a supported instruement}
{The sleep function is only partially support here.}
{See the older MSDOS version of Test32 for code example of the wakeup function.}
procedure dof56; {Set Power / (do sleep:6500) }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;

  //special case handling for 6500 instruments (cmd is for stop comm not power)
  if (FD_Signature.InstrumentBaseType < 10)or(FD_Signature.InstrumentModel = 6500) then
  begin
// wakeup is no longer supported, only do sleep will work with the 6500 in this code.
//    write('Enter power command (0=Wake up, 1=Sleep) : ');
//    readln(temp);
    temp := 1; //force to sleep function only.
    if (temp = 1) then
    begin
      if Fipp.DoSleep() = false then Exit; //turn off communication
      writeln('Sleep has been performed.');
      writeln('This funciton turns off the RS232 interface.');
      writeln('Press reset on the 6500 to wake it up again.');
    end
    else
    begin
      writeln('Wakeup function is no longer supported (requires ASCII support)');
      writeln('See old MSDOS version of Test32 for this feature.');
    end;
    pfunerr := 0;
    Exit;
  end;

  if not(Fipp.GetPowerStatus()) then Exit;
  writeln('Current Power State : ',PowerStateStr(Fipp.PowerState));

  //if FP40 or instrument does not support the timeout parameters of the
  //Set Power cmd (uses only one parameter) do it this way
  //Note: If you power down the FP40, it will no longer function.
  if (FD_Signature.InstrumentBaseType = 40)or(Fipp.PowerCmdSize < 2) then
  begin
    write('Enter power command (0=Wake up, 1=Power Save, 2=Power Off) : ');
    readln(temp);
    Fipp.PowerState := temp;
    Fipp.PowerCmdSize := 1; //only one parameter allowed for FP40
    if not(Fipp.SetPower()) then Exit;
    writeln('Power command performed');
    pfunerr := 0;
    Exit;
  end;

  //full command support, so we can do it this way
  write('Enter power command (0=Wake up, 1=Power Save, 2=Power Down) : ');
  readln(temp);
  Fipp.PowerState := temp;
  if (Fipp.PowerState > 0) then
  begin
    //Doing it this way insures that the variable cmd size works.
    //and so that we don't have to enter the timeouts all the time.
    Fipp.PowerCmdSize := 1;
  end
  else
  begin
    write('Enter Screen Saver Timeout (in Seconds) : ');
    readln(temp);
    Fipp.StandbyTimeout := temp;
    if (Fipp.PowerCmdSize > 3) then Fipp.PowerCmdSize := 3; //limit cmd size to 3 parameters
    if (FD_Signature.InstrumentBaseType = 35) and (FD_Signature.SoftwareVersion < 620) then
      Fipp.PowerDownTimeout := INVALID_DATA16; //disable power down on older FP35 instruments
    if (Fipp.PowerCmdSize > 2) and (Fipp.PowerDownTimeout >= 0) then
    begin
      write('Enter Power Down Timeout (in Seconds) : ');
      readln(temp);
      Fipp.PowerDownTimeout := temp;
    end
    else
    begin
      Fipp.PowerDownTimeout := INVALID_DATA16; //Powerdown is Not supported
    end;
  end;
  if not(Fipp.SetPower()) then Exit;
  writeln('Power command performed');
  pfunerr := 0;
end;



{-----}
procedure dof57; {get ref mic value}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRefMicData()) then Exit;
  writeln('Current RefMic Input = ',FS_Str3D(Fipp.RefMicData),'dB');
  pfunerr := 0;
end;


{------}
procedure dof58; {get key scan code}
begin
  if not(Fipp.GetKeyScanCode()) then Exit;
  Writeln('KeyBoard Scan Code is ',Fipp.KeyScanCode);
  pfunerr := 0;
end;



{------}
function MajorStateStr(MS:word):str255;
begin
    case MS of
      0: MajorStateStr := ' (Open/Logo Screen)';
      1: MajorStateStr := ' (Coupler Screen)';
      2: MajorStateStr := ' (ANSI87 Test)';
      3: MajorStateStr := ' (IEC Test)';
      4: MajorStateStr := ' (JIS Test)';
      5: MajorStateStr := ' (ISI Test)';
      6: MajorStateStr := ' (Probe Ins.Gain)';
      7: MajorStateStr := ' (TCoil Test)';
      8: MajorStateStr := ' (Zeta Test)';
      9: MajorStateStr := ' (XAR Test)';    {fixed att/rel}
     10: MajorStateStr := ' (VAR Test)';    {variable att/rel}
     11: MajorStateStr := ' (IO Test)';
     12: MajorStateStr := ' (ANSI92 Test)';
     13: MajorStateStr := ' (AVG Test)';
     14: MajorStateStr := ' (Multi-curve)';
     15: MajorStateStr := ' (CIC Test)';
     16: MajorStateStr := ' (Main Menu)';
     17: MajorStateStr := ' (DSIN Test)';
     18: MajorStateStr := ' (ANSI96 Test)';
     19: MajorStateStr := ' (Profiler Test)';
     20: MajorStateStr := ' (Probe Multi-Crv)';
     21: MajorStateStr := ' (Message Display)';
     22: MajorStateStr := ' (Local Menu)';
     23: MajorStateStr := ' (Probe SPL)';
     24: MajorStateStr := ' (Probe AI)';
     25: MajorStateStr := ' (Probe Audiogram)';
     26: MajorStateStr := ' (Coupler Target)';
     27: MajorStateStr := ' (Ear Simulator)';
     28: MajorStateStr := ' (Phase Delay)';
     29: MajorStateStr := ' (Target Edit)';
     30: MajorStateStr := ' (Probe Navigation)';
     31: MajorStateStr := ' (Probe I/O)';
     32: MajorStateStr := ' (Calibration)';
     33: MajorStateStr := ' (ANSI03 Test)';
     34: MajorStateStr := ' (Oscope Test)';
     35: MajorStateStr := ' (Battery Test)';
     36: MajorStateStr := ' (Visible Speech)';
     37: MajorStateStr := ' (IEC 2005)';
     else MajorStateStr := ' (unknown)';
    end;
end;

procedure ShowMajors;
begin
  writeln('Major State: 0=Open,    1=Coupler,  2=ANSI87,     3=IEC,    4=JIS,');
  writeln('  5=ISI,     6=Probe,   7=Tcoil,    8=Zeta,       9=StdAR, 10=VarAR,');
  writeln(' 11=IO,     12=ANSI92, 13=Avg,     14=Multi-Crv,  15=ACIC, 16=Main Menu,');
  writeln(' 17=DSIN,   18=ANSI96, 19=Profile, 20=Probe Multicrv,      21=Message,');
  writeln(' 22=Local Menu,        23=Prb SPL, 24=Prb AI,     25=Probe Aud,');
  writeln(' 26=Coupler Target,    27=Ear Sim, 28=Phase Dly,  29=Target Edit,');
  writeln(' 30=Probe Nav,       31=Probe I/O, 32=Calibration,33=ANSI03,');
  writeln(' 34=Oscope,          35=Battery,   36=Vis Speech, 37=IEC 2005');
end;

procedure dof59; {Set machine state}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetMachineState()) then Exit;
  ShowMajors;
  write('Current Test state is -  Major State: ',Fipp.MajorMachineState,
                               '  Minor State: ',Fipp.MinorMachineState,' ');

  write(MajorStateStr(Fipp.MajorMachineState));
  writeln;
  write('Enter new major state: ');
  readln(temp);
  Fipp.MajorMachineState := temp;
  write('Enter new minor state: ');
  readln(temp);
  Fipp.MinorMachineState := temp;

  if not(Fipp.SetMachineState()) then Exit;
  Fipp.ReleaseCmd();
  if not(Fipp.GetMachineState()) then Exit;
  write('New Test state is -  Major State: ',Fipp.MajorMachineState,
                             '  Minor State: ',Fipp.MinorMachineState,' ');
  write(MajorStateStr(Fipp.MajorMachineState));
  writeln;
  pfunerr := 0;
end;


{------}
procedure dof60; {Get machine state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetMachineState()) then Exit;
  write('Major State: ',Fipp.MajorMachineState,' ');
  write(MajorStateStr(Fipp.MajorMachineState));
  writeln;
  writeln('Minor State: ',Fipp.MinorMachineState);
  pfunerr := 0;
end;



{------}
procedure dof61; {Get BLOB}
var fc:text;
    i,ii:integer;
    N:longint;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetBlob()) then Exit;

  if      Fipp.Blob[0] = 2 then SD_ShowAnsiBlob(Fipp.BlobSize,@Fipp.Blob)
  else if Fipp.Blob[0] = 3 then SD_ShowIecBlob(Fipp.BlobSize,@Fipp.Blob)
  else if Fipp.Blob[0] = 4 then SD_ShowJisBlob(Fipp.BlobSize,@Fipp.Blob)
  else if Fipp.Blob[0] = 12 then SD_ShowAnsi92Blob(Fipp.BlobSize,@Fipp.Blob)
  else if Fipp.Blob[0] = 15 then SD_ShowAnsiBlob(Fipp.BlobSize,@Fipp.Blob)  {CIC is same as ansi}
  else if Fipp.Blob[0] = 18 then SD_ShowAnsiBlob(Fipp.BlobSize,@Fipp.Blob)  {ansi96 is like ansi87}
  else if Fipp.Blob[0] = 33 then SD_ShowAnsiBlob(Fipp.BlobSize,@Fipp.Blob)  {ansi03 is like ansi96}
  else if Fipp.Blob[0] = 37 then SD_ShowIec05Blob(Fipp.BlobSize,@Fipp.Blob)
  else SD_ShowUnknownBlob(Fipp.BlobSize,@Fipp.Blob);
  writeln;
  assign(fc,'BLOB.DAT');
  rewrite(fc);
  if Fipp.BlobSize > 0 then
  begin
    for i := 0 to pred(Fipp.BlobSize) do
    begin
      if UseShowInt = true then
        N := smallint(Fipp.Blob[i])
      else N:= word(Fipp.Blob[i]);
      if (UseDelimit = true) and (i < pred(Fipp.BlobSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
  end;
  close(fc);
  pfunerr := 0;
end;

{------}
procedure dof62; {set control lock}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetControlLock()) then Exit;
  write('Current Control Lock State = ');
  case Fipp.ControlLock of
    0 : writeln('0 - Local Instrument control');
    1 : writeln('1 - RS232 control, Display enabled');
    2 : writeln('2 - RS232 control, Display disabled');
    3 : writeln('3 - RS232 control, Display blanked');
  else
    writeln(Fipp.ControlLock);
  end;
  writeln('Enter new Control Lock State  (0=Local) ');
  write('(1=RS232:DispEn, 2=RS232:DispOff, 3=RS232:NoDisp) : ');
  readln(temp);
  Fipp.ControlLock := temp;
  if not(Fipp.SetControlLock()) then Exit;
  write('New Control Lock State = ');
  case Fipp.ControlLock of
    0 : writeln('0 - Local Instrument control');
    1 : writeln('1 - RS232 control, Display enabled');
    2 : writeln('2 - RS232 control, Display disabled');
    3 : writeln('3 - RS232 control, Display blanked');
  else
    writeln(Fipp.ControlLock);
  end;
  pfunerr := 0;
end;

{--------}
procedure dof63; {get key control}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetControlLock()) then Exit;
  Write('Control Lock State is: ');
  case Fipp.ControlLock of
    0 : writeln('0 - Local Instrument control');
    1 : writeln('1 - RS232 control, Display enabled');
    2 : writeln('2 - RS232 control, Display disabled');
    3 : writeln('3 - RS232 control, Display blanked');
  else
    writeln(Fipp.ControlLock);
  end;
  pfunerr := 0;
end;



{------}
procedure dof64; {Do line feeds}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter line feeds to perform : ');
  readln(temp);
  Fipp.PrintFeeds := temp;
  if not(Fipp.DoLineFeeds()) then Exit;
  writeln(Fipp.PrintFeeds,' - Line feeds have been performed');
  pfunerr := 0;
end;


procedure ShowPrintHow;
begin
  if (FD_Signature.InstrumentModel < 2) then {6400 or 6500}
  begin
    writeln('1=Label, 2=Top, 3=Top+Label, 4=Bot, 5=Bot+Label, 6=Top+Bot, 7=Top+Bot+Label');
  end
  else {all others}
  begin
     writeln('0=label off, 1=Label on;  2=Print (Label off), 3=Print (Label on)');
  end;
end;
{----------}
procedure dof65; {do print }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  begin
    //Try to get current printer control selector
    if not(Fipp.GetPrinterSelect()) then
    begin
      //if cannot read the printer control selector, then ask the user for it.
      if (FD_Signature.InstrumentModel < 2) then {6400 or 6500}
      begin
         writeln('1=Label, 2=Top, 3=Top+Label, 4=Bot, 5=Bot+Label, 6=Top+Bot, 7=Top+Bot+Label');
      end
      else {all others}
      begin
       writeln('0=label off, 1=Label on;  2=Print (Label off), 3=Print (Label on)');
      end;
      write('Enter Print command:  ');
      readln(temp);
      Fipp.PrintControl := temp;
    end;
    if not(Fipp.DoPrint()) then Exit;
    writeln('Print has been performed');
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof66;    {set extended label}
var Temp:integer;
var Size : integer;
var c : char;
begin
  if (TSUB_OpenPort() = false) then Exit;

  writeln;
  write('Enter Extended label to read (0=Current, 1=Factory, 2=Stored, 3=Current UserID): ');
  readln(temp);
  Fipp.LabelType := temp;
  if temp = 3 then Fipp.LabelLines := 10
  else Fipp.LabelLines := 0;
  if not(Fipp.GetExtendedLabel()) then Exit;
  c := #255;
  if (LU_LabelIsBlank(FIPP_REG_EXT_LABEL_SIZEB,fipp.ExtLabelData) = false) then
  begin
    SD_ShowLabel(FIPP_REG_EXT_LABEL_SIZEB,fipp.ExtLabelData);
    if (Fipp.LabelLines = 10) then
    begin
      Size := (Fipp.LabelLines - 8) * FIPP_NUM_LABEL_LINE_CHAR;
      SD_ShowLabel(Size,Fipp.UserIDText[Fipp.UserNumber]);
    end;
    writeln;
    writeln('Press 1 to send this label, press 2 to enter a new label,');
      write('press 3 to enter a new ID only, or any other key to cancel: ');
  end
  else
  begin
    writeln;
    writeln('-> No label text found <-');
    writeln;
    writeln('Press 2 to enter a new label,');
      write('press 3 to enter a new ID only, or any other key to cancel: ');
  end;
  c := FT_ConGetKey();
  writeln;

  if (c = '1') then
  begin
    Fipp.LabelLines := 8;
    Fipp.ConvertLabelToSend(FIPP_REG_EXT_LABEL_SIZEB,fipp.ExtLabelData);    {stuff it into the cmd send array}
    Fipp.CmdArray.Size := FIPP_REG_EXT_LABEL_SIZEB div 2; {set the label data size in words}
    if not(Fipp.SetExtendedLabel()) then Exit;    {Send the label}
  end
  else if (c = '2') then
  begin
    writeln('Enter Label Information');
    Fipp.LabelLines := 8;
    LU_EnterStdLabel(LabelText);   {enter the label into LabelText}
    FS_StringToPchar(fipp.ExtLabelData,LabelText,FIPP_REG_EXT_LABEL_SIZEB); {convert it to a 2D pchar array}
    Fipp.ConvertLabelToSend(FIPP_REG_EXT_LABEL_SIZEB,fipp.ExtLabelData);    {stuff it into the cmd send array}
    Fipp.CmdArray.Size := FIPP_REG_EXT_LABEL_SIZEB div 2; {set the label data size in words}
    if not(Fipp.SetExtendedLabel()) then Exit;    {Send the label}
  end
  else if (c = '3') then
  begin
    Fipp.LabelLines := 10;
    LU_EnterUserID(CustomLab);   {enter the new UserID}
    FS_StringToPchar(Fipp.UserIDText[Fipp.UserNumber],CustomLab,FIPP_MAX_USERID_TEXT); {convert it to a 2D pchar array}
    Size := FIPP_MAX_USERID_TEXT;
    Fipp.ConvertLabelToSend(FIPP_REG_EXT_LABEL_SIZEB,fipp.ExtLabelData);        {stuff label into the cmd send array}
    Fipp.ConvertUserIdTosend(true,FIPP_MAX_USERID_TEXT,Fipp.UserIDText[Fipp.UserNumber]);  {stuff userID into the cmd send array}
    if not(Fipp.SetExtendedLabel()) then Exit;    {Send the label}
  end;
  writeln;
  writeln('* Label Sent *');
  pfunerr := 0;
end;

{-----------------------------------------------}
//Note: some instruments only use the Extended Full label to read/set the customer ID
//Other allow the use of the the set/get User ID commands to set the user ID.
procedure dof86;    {get extended label}
var Temp:integer;
var Size : integer;
var Lines : integer;
var pLabelData : pchar;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter Extended label to read (0=Current, 1=Factory, 2=Stored): ');
  readln(temp);
  Fipp.LabelType := temp;
  Fipp.LabelLines := 10; //first see if we can read full extended label
  if (Fipp.GetExtendedLabel() = true) then
  begin
    write('Enter Extended label style (0=Label only, 1=Label+User ID): ');
    readln(temp);
    if (temp = 0) then Lines := 0
    else Lines := Fipp.LabelLines;
  end
  else
  begin
    //can't read full ext label, so try for older ext label method
    Fipp.LabelLines := 0;
    Lines := 0;
    if (Fipp.GetExtendedLabel() = false) then Exit;
  end;

  writeln('Current Label Information');
  writeln;

  Size := FIPP_REG_EXT_LABEL_SIZEB;
  SD_ShowLabel(Size,Fipp.ExtLabelData);
  if ((Lines > 8) and (Fipp.LabelLines > 8)) then
  begin
    Size := (Fipp.LabelLines - 8) * FIPP_NUM_LABEL_LINE_CHAR;
    SD_ShowLabel(Size,Fipp.UserIDText[Fipp.UserNumber]);
  end;
  writeln;
  pfunerr := 0;
end;

{-----------------------------------------------}
function LabelMethodStr(LabelMethod:integer):str255;
begin
  case LabelMethod of
   0 : LabelMethodStr := 'Store and use current label and ID';
   1 : LabelMethodStr := 'Store and use factory default label';
   2 : LabelMethodStr := 'Read and use stored printer label';
   3 : LabelMethodStr := 'Read and use factory default label';
   4 : LabelMethodStr := 'Store and use current label bitmap';
   5 : LabelMethodStr := 'Store and use factory label bitmap';
   6 : LabelMethodStr := 'Read and use stored label bitmap';
   7 : LabelMethodStr := 'Read and use factory label bitmap';
   8 : LabelMethodStr := 'Disable Label Time Stamp';
   9 : LabelMethodStr := 'Enable Label Time Stamp';
  else LabelMethodStr := '?';
  end;
end;

procedure dof89;    {set default label}
var Temp:integer;
var i : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  for i := 0 to 7 do
    writeln(i,' = ',LabelMethodStr(i));
  write('Select label storage action: ');
  readln(temp);
  Fipp.PrinterLabelStorage := temp;
  if not(Fipp.SetPrinterLabelStorage()) then Exit;
  Fipp.LabelType := 0;
  if not(Fipp.GetExtendedLabel()) then Exit;
  writeln('Current Label Information');
  writeln;
  SD_ShowLabel(FIPP_REG_EXT_LABEL_SIZEB,Fipp.ExtLabelData);
  writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof67;    {do error}
const MAX_ERROR_MSG_LINES = 20; {up to 20 lines can be displayed}
const What : string = 'ErrorMsg.txt';
var i,j,k:integer;
var fc:text;
var ErrorText : string;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if (FD_Signature.InstrumentModel < 10) then
  begin
    if not(Fipp.DoError()) then Exit;
    writeln('Error flash has been performed');
  end
  else
  begin
    if not(Fipp.GetControlLock()) then Exit;
    if Fipp.ControlLock <> 2 then
    begin
      writeln;
      writeln('* Remember to use cmd 62:2 to lock the display to *');
      writeln('* prevent the message from being immediately erased. *');
      writeln('* and don''t forget to unlock the display when done. *');
      writeln('* You will get a blank display if you don''t unlock it *');
      writeln('* before exiting the message window. *');
      writeln('* Also the FP35 keyboard will be locked until it is unlocked. *');
    end;
    k := 0;
    if FileExists(What) = false then
    begin
      writeln('File not found:',What);
      writeln('To display an error message, create the text file.');
    end
    else
    begin
      assign(fc,What);
      reset(fc);
      for i := 0 to MAX_ERROR_MSG_LINES do
      begin
        readln(fc,ErrorText);
        if (length(ErrorText) = 0) then
        begin
          Fipp.CmdArray.DataByte[k] := 0; {always trail with a null}
        end
        else
        begin
          for j := 1 to length(ErrorText) do
          begin
            Fipp.CmdArray.DataByte[k] := byte(ErrorText[j]);
            inc(k);
            Fipp.CmdArray.DataByte[k] := 0; {always trail with a null}
          end;
        end;
        if eof(fc) then break;
        inc(k);
      end;
      Fipp.CmdArray.DataByte[k] := 0; {always trail with a null}
      inc(k);
      close(fc);
    end;
    Fipp.CmdArray.Size := k div 2;
    if not(Fipp.DoError()) then Exit;

  end;
  pfunerr := 0;
end;

{------}
procedure dof68; {Set spectrum}
var What : string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    ii:word;
    i : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    What := 'Spectrum.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      writeln('Loading specturm data from SPECTRUM.DAT file');
      reset(fc);
      for i := 0 to pred(fipp_MaxSpectrumPos) do
      begin
        readln(fc,Fipp.Spectrum[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find SPECTRUM.DAT file');
      Exit;
    end;

    if not(Fipp.SetSpectrum()) then Exit;
    ii := 0;
    for i := 0 to pred(fipp_MaxSpectrumPos) do
    begin
      write(FS_IntStr(Fipp.Spectrum[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;

  pfunerr := 0;
end;

{------}
procedure dof69; {Set phase}
var what:string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    i,ii:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    What := 'Phase.DAT';
    if FileExists(what) then
    begin
      assign(fc,What);
      writeln('Loading phase data from PHASE.DAT file');
      reset(fc);
      for i := 0 to pred(fipp_MaxPhasePos) do
      begin
        readln(fc,Fipp.PhaseTable[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find PHASE.DAT file');
      Exit;
    end;

    if not(Fipp.SetPhaseTable()) then Exit;
    ii := 0;
    for i := 0 to pred(fipp_MaxPhasePos) do
    begin
      write(FS_IntStr(Fipp.PhaseTable[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;
  pfunerr := 0;
end;


{=================}
procedure ShowTestParameters;
var i : integer;
begin
  {  Writeln('Option State is    =   ',Options[0]); }
    writeln('Option selects are === 1: ',Fipp.TestParameters[1]);
    if Fipp.TestParametersSize > 0 then
    begin
      for i := 2 to pred(Fipp.TestParametersSize) do
      begin
        writeln('                               ',i,': ',Fipp.TestParameters[i]);
      end;
    end;
end;


{------}
procedure dof70; {Set option params}
var what:string[80];
var fc:text;
var Temp:integer;
var i:word;
begin
  if (TSUB_OpenPort() = false) then Exit;
    writeln('Major: 2=ANSI87, 3=IEC94, 4=JIS, 5=ISI, 12=ANSI92, 15=ACIC, 17=DSIN,');
    writeln('      18=ANSI96, 20=PROF, 33=ANSI03, 37=IEC05');
//    writeln('Major: 2=ANSI87, 3=IEC, 4=JIS, 12=ANSI92, 15=ACIC, 17=DSIN,');
//    writeln('      18=ANSI96, 20=PROFILE');
    write('Enter Major State Options to set: ');
    readln(temp);
    Fipp.TestParameters[0] := temp;
    if not(Fipp.GetTestParameters()) then Exit;
    write('Current ');
    ShowtestParameters;
    writeln;
    if Fipp.TestParametersSize > 0 then
    begin
      What := 'OptParm'+FS_IntStr(Fipp.TestParameters[0])+'.DAT';
      if FileExists(What) then
      begin
        assign(fc,What);
        reset(fc);
        //pCrv := ptCrv(@Fipp.CurveFrame);
        for i := 0 to pred(Fipp.TestParametersSize) do
        begin
          readln(fc,fipp.TestParameters[i]);
          if eof(fc) then break;
        end;
        close(fc);
      end
      else
      begin
        for i := 1 to pred(Fipp.TestParametersSize) do
        begin
          write('Enter new option parameter ',i,':');
          readln(temp);
          Fipp.TestParameters[i] := temp;
        end;
      end;
    end;
    if not(Fipp.SetTestParameters()) then Exit;
    if not(Fipp.GetTestParameters()) then Exit;
    writeln;
    write('    New ');
    ShowTestParameters();

  pfunerr := 0;
end;

{------}
procedure dof71; {Get option params}
var what:string[80];
var fc:text;
var Temp:integer;
var i,N:word;
begin
  if (TSUB_OpenPort() = false) then Exit;

    writeln('Major: 2=ANSI87, 3=IEC94, 4=JIS, 5=ISI, 12=ANSI92, 15=ACIC, 17=DSIN,');
    writeln('      18=ANSI96, 20=PROF, 33=ANSI03, 37=IEC05');
    write('Enter Major State Options to get: ');
    readln(temp);
    Fipp.TestParameters[0] := temp;
    if not(Fipp.GetTestParameters()) then Exit;
    write('        ');
    ShowTestParameters;
    What := 'OptParm'+FS_IntStr(Fipp.TestParameters[0])+'.DAT';
    assign(fc,What);
    rewrite(fc);
    for i := 0 to pred(Fipp.TestParametersSize) do
    begin
      if UseShowInt = true then
        N := smallint(fipp.TestParameters[i])
      else N := word(fipp.TestParameters[i]);
      if (UseDelimit = true) and (i < pred(Fipp.TestParametersSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);

  pfunerr := 0;
end;

{---------}
procedure dof72; {set key scan code}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetKeyScanCode()) then Exit;
  writeln('Current KeyBoard Scan Code = ',Fipp.KeyScanCode);
  write('Enter new KeyBoard Scan Code: ');
  readln(temp);
  Fipp.KeyScanCode := temp;
  if not(Fipp.SetKeyScanCode()) then Exit;
  writeln('New KeyBoard Scan Code = ',Fipp.KeyScanCode);
  pfunerr := 0;
end;

{---------}
procedure dof73; {set POLL DELAY}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetPollDelay()) then Exit;
  writeln('Current Poll Delay = ',Fipp.PollDelay,' (Default = 40mS)');
  if (Fipp.PollDelayCount > 1) then
  begin
    writeln('Current Poll Holdoff: ',Fipp.PollHoldoff,' (Default = 10mS)');
  end;
  write('Enter new Poll Delay Time (mS): ');
  readln(temp);
  Fipp.PollDelay := temp;
  if (Fipp.PollDelayCount > 1) then
  begin
    write('Enter new Poll Holdoff time (mS): ');
    readln(temp);
    Fipp.PollHoldoff := temp;
  end;
  if not(Fipp.SetPollDelay()) then Exit;
  writeln('New Poll Delay = ',Fipp.PollDelay);
  if (Fipp.PollDelayCount > 1) then
  begin
    writeln('New Poll Holdoff: ',Fipp.PollHoldoff);
  end;
  pfunerr := 0;
end;



{---------}
procedure dof74; {get POLL DELAY}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetPollDelay()) then Exit;
  writeln('Poll Delay: ',Fipp.PollDelay);
  if (Fipp.PollDelayCount > 1) then
  begin
    writeln('Poll Holdoff: ',Fipp.PollHoldoff);
  end;
  pfunerr := 0;
end;


procedure ShowWhichEar(TestEar:integer);
begin
  if Fipp.EarConfig < 0 then
  begin
    case Fipp.TestEar of
     0:writeln(' (Left)');
     1:writeln(' (Right)');
    end;
  end
  else
  begin
    case Fipp.TestEar of
     0:writeln(' (None)');
     1:writeln(' (Left)');
     2:writeln(' (Right)');
     3:writeln(' (Bone)');
    end;
  end;
end;

{---------}
procedure dof75; {set test ear}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Fipp.EarConfig := -1;
  if not(Fipp.GetTestEar()) then Exit;
  write('Current Test Ear = ',Fipp.TestEar);
  ShowWhichEar(Fipp.TestEar);
  if Fipp.EarConfig < 0 then
    write('Enter new Test Ear (0=Left, 1=Right): ')
  else write('Enter new Test Ear (0=None, 1=Left, 2=Right): ');
  readln(temp);
  Fipp.TestEar := temp;
  if not(Fipp.SetTestEar()) then Exit;
  write('New Test Ear = ',Fipp.TestEar);
  ShowWhichEar(Fipp.TestEar);
  pfunerr := 0;
end;



{---------}
procedure dof76; {get test ear}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTestEar()) then Exit;
  write('Test Ear : ',Fipp.TestEar);
  ShowWhichEar(Fipp.TestEar);
  pfunerr := 0;
end;

procedure ShowSrcType(SrcType:integer);
begin
  case SrcType of
    0: write('Pure tone sweep');
    1: write('Composite (chirp)');
    2: write('Fast tone sweep');
    3: write('Single tone');
    4: write('Short (burst) tone sweep');
    5: write('Composite noise');
    6: write('Digital Speech');
    7: if (FD_Signature.InstrumentModel = 0) then
         write('Icra (6500)')
       else write('Dig FS Speech');
    8: write('Intermod Dist.');
    9: write('Pulse Tone');
    10: write('Long Tone Sweep');
    11: write('Composite w/100Hz');
  end;
end;

{------}
procedure dof77;   { set new src type - was set operation state }
var temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSrcType()) then Exit;
  write('Current Source Type = (',Fipp.SrcType,') ');
  ShowSrcType(Fipp.SrcType);
  writeln;
  writeln;
  writeln('0=Pure tone, 1=Composite(chirp),  2=Fast tone sweep,  3=Single tone(probe),');
  writeln('4=Short,     5=Composite(noise),  6=Dig Speech,       7=Dig FS (6500=Icra),');
  writeln('8=ImDist,   10=Long Tone sweep,  11=Composite w/100Hz');
  write('Enter new Source Type: ');
  readln(temp);
  Fipp.SrcType := temp;
  if not(Fipp.SetSrcType()) then Exit;
  write('New Source Type = (',Fipp.SrcType,') ');
  ShowSrcType(Fipp.SrcType);
  writeln;
  pfunerr := 0;
end;



{-------}
procedure dof78;   { get src type - was get operating state}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetSrcType()) then Exit;
  write('Current Source Type = (',Fipp.SrcType,') ');
  ShowSrcType(Fipp.SrcType);
  writeln;
  pfunerr := 0;
end;



{---------}
procedure dof79; {set batt type}
var temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  {First determine how to make the command work with the different instruments}
  if FD_Signature.InstrumentBaseType = 40 then
  begin
    //FP40 does not support cmd 179, so set to single paramter mode
    Fipp.BatteryInfoSize := 1;
    Fipp.BatteryFormat := 1;
    Fipp.BatterySize := INVALID_DATA16;
  end
  else
  begin
    if not(Fipp.GetBatteryInfo()) then Exit;
    Fipp.BatteryFormat := Fipp.BatteryInfoSize;
    writeln('Current Battery Type = ',Fipp.BatteryType);
  end;

  write('  Enter new Battery Type : ');
  readln(temp);
  Fipp.BatteryType := temp;

  if (((Fipp.BatteryFormat = 2)or(Fipp.BatteryFormat = 3)) and (Fipp.BatterySize <> INVALID_DATA16)) then
  begin
    writeln('Current Battery Size = ',Fipp.BatterySize);
      write('  Enter new Battery Size : ');
    readln(temp);
    if (Temp < 0) then Temp := INVALID_DATA16;
    Fipp.BatterySize := temp;
  end;

  if (Fipp.BatteryFormat = 3) then
  begin
    writeln('Current Battery MAH = ',Fipp.BatteryMAH);
    write('  Enter new Battery MAH : ');
    readln(temp);
    if (Temp < 0) then Temp := INVALID_DATA16;
    Fipp.BatteryMAH := temp;
  end;

  if (Fipp.BatteryFormat >= 4) and (Fipp.BatteryType = FIPP_BATTERY_CUSTOM) then
  begin
    writeln('Current Battery Volts = ',Fipp.BatteryVolt);
    write('  Enter new Battery Volts : ');
    readln(temp);
    if (Temp < 0) then Temp := INVALID_DATA16;
    Fipp.BatteryVolt := temp;

    if (Fipp.BatteryFormat >= 5) then
    begin
    writeln('Current Battery Impedance = ',Fipp.BatteryImp);
      write('  Enter new Battery Impedance : ');
      readln(temp);
      if (Temp < 0) then Temp := INVALID_DATA16;
      Fipp.BatteryImp := temp;
    end;
  end;

  //Note: BatteryFormat contains send array size
  if not(Fipp.SetBatteryType()) then Exit;
  pfunerr := 0;
end;

{------}
procedure dof80; {Get power status}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetPowerStatus()) then Exit;
    if word(Fipp.PowerVoltage) <> $8000 then
      write('Power Volts: ',FS_Str2d(Fipp.PowerVoltage),'V');
    writeln('  Power Flags: ',FS_hexw(Fipp.PowerFlags),'H');
    if (Fipp.PowerFlags and $0080) <> 0 then
    begin
      if (Fipp.PowerFlags and $0002) <> 0 then writeln('Battery is fully charged');
      if (Fipp.PowerFlags and $1000) <> 0 then writeln('Battery is nearly empty');
      if (Fipp.PowerFlags and $0004) <> 0 then writeln('Battery in overcharge mode');
      if (Fipp.PowerFlags and $0010) <> 0 then writeln('Battery charger is ON');
      if (Fipp.PowerFlags and $0080) <> 0 then writeln('Charger status is valid');
    end;
    if (Fipp.PowerFlags and $0020) =  0 then writeln('External Power is ON');
    if (Fipp.PowerFlags and $2000) <> 0 then writeln('Instrument is in Standby mode');
    if (Fipp.PowerFlags and $4000) <> 0 then writeln('Instrument is asleep (power down)');
    if (Fipp.PowerFlags and $8000) <> 0 then writeln('Screen Saver is enabled');
    if (Fipp.PowerFlags and $8000) =  0 then writeln('Screen Saver is disabled');
    writeln;
    if (Fipp.PowerState = 0) then writeln('PowerState = Active (0)')
    else if (Fipp.PowerState = 1) then writeln('PowerState = Screen Saver Mode (1)')
    else if (Fipp.PowerState = 2) then writeln('PowerState = Sleep Mode (2)')
    else writeln('PowerState = ',Fipp.PowerState);

    if Fipp.StandbyTimeout = 0 then
      writeln('Screen Saver Standby Timeout: OFF')
    else if Fipp.StandbyTimeout > 0 then
      writeln('Screen Saver Standby Timeout: ',FS_IntStr(Fipp.StandbyTimeout),' Minutes');
    if Fipp.PowerDownTimeout = 0 then
      writeln('Power Saver Timeout: OFF')
    else if Fipp.PowerDownTimeout > 0 then
      writeln('Power Saver Timeout: ',FS_IntStr(Fipp.PowerDownTimeout),' Minutes');
  pfunerr := 0;
end;


{-----------------------------------------------------------------------------}
  function AvgFrqStr(Select:word):str255;
  begin
    case Select of
     0: AvgFrqStr := ' 800,1250,2000';
     1: AvgFrqStr := '1000,1600,2500';
     2: AvgFrqStr := '1250,2000,3150';
     3: AvgFrqStr := '1600,2500,4000';
     4: AvgFrqStr := '2000,3150,5000';
     5: AvgFrqStr := ' 500,1000,2000';
    end;
  end;
  function DistFrqStr(Select:word):str255;
  begin
    case Select of
     0: DistFrqStr := ' 400, 650,1000';
     1: DistFrqStr := ' 500, 800,1600';
     2: DistFrqStr := ' 650,1000,1600';
     3: DistFrqStr := ' 800,1250,2000';
     4: DistFrqStr := '1000,1250,2000';
     5: DistFrqStr := ' 250, 500,1000';
    end;
  end;
  function AvgTypeStr(Select:word):str255;
  begin
    case Select of
     0: AvgTypeStr := '(SPA)';
     1: AvgTypeStr := '(HFA)';
     2: AvgTypeStr := '(SPA)';
     3: AvgTypeStr := '(SPA)';
     4: AvgTypeStr := '(SPA)';
     5: AvgTypeStr := '(IEC)';
    end;
  end;


procedure ShowAvgFreqs(Select:smallint; ShowValues:boolean);
begin
  begin
    if ShowValues then
    begin
      if Select < 0 then writeln('(CST) Custom Values')
      else writeln(AvgTypeStr(Select),' Values');
      writeln('    [Freqs: ',FS_IntStr(Fipp.AvgFreqValues.F1),',',FS_IntStr(Fipp.AvgFreqValues.F2),',',FS_IntStr(Fipp.AvgFreqValues.F3),' Hz]');
      writeln('    [ Dist: ',FS_IntStr(Fipp.AvgFreqValues.D1),',',FS_IntStr(Fipp.AvgFreqValues.D2),',',FS_IntStr(Fipp.AvgFreqValues.D3),' Hz]');
    end
    else
    begin
      if (Select < 6) and (Select >= 0) then
      begin
        writeln('  ',AvgTypeStr(Select),' Selection');
        writeln('    [Freqs: ', AvgFrqStr(Select),' Hz]');
        writeln('    [ Dist: ',DistFrqStr(Select),' Hz]');
      end
      else if Select = -1 then
        writeln('    [Custom Frequencies]')
      else writeln;
    end;
  end;
end;

{---------}
procedure dof81; {get avg freqs}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAvgFreqs()) then Exit;
    write(' Avg Freqs: ',Fipp.AvgFreqs,'  ');
  ShowAvgFreqs(Fipp.AvgFreqs,Fipp.UseAvgFreqValues);
  pfunerr := 0;
end;


{---------}
procedure dof82; {set avg freqs}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    {UseAvgFreqValues := false;}
    if not(Fipp.GetAvgFreqs()) then Exit;
    write('Current Avg Freqs = ',Fipp.AvgFreqs,'  ');
    ShowAvgFreqs(Fipp.AvgFreqs,Fipp.UseAvgFreqValues);

    write('Enter new Avg Freq Selection (0-5),(-1=Custom),(6=New Custom): ');
    readln(temp);
    if Temp > 5 then
    begin
      write('Enter new F1 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.F1 := temp;
      write('Enter new F2 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.F2 := temp;
      write('Enter new F3 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.F3 := temp;
      write('Enter new D1 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.D1 := temp;
      write('Enter new D2 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.D2 := temp;
      write('Enter new D3 (Hz) ');
      readln(temp);
      Fipp.AvgFreqValues.D3 := temp;
      Fipp.UseAvgFreqValues := true;
      Fipp.AvgFreqs := -1;
    end
    else
    begin
      Fipp.AvgFreqs := temp;
      Fipp.UseAvgFreqValues := false;
    end;
    if not(Fipp.SetAvgFreqs()) then Exit;
    write('New Avg Freqs = ',Fipp.AvgFreqs,'      ');
    ShowAvgFreqs(Fipp.AvgFreqs,Fipp.UseAvgFreqValues);
  pfunerr := 0;
end;


{---------}
procedure dof83; {get measurment settle delay}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetSettleTime()) then Exit;
    if Fipp.SettleCmdSize = 1 then
    begin
      writeln('Measurment Settle Time: ',Fipp.FreqSettleTime,' (mS)');
    end;
    if Fipp.SettleCmdSize >= 3 then
    begin
      writeln('Frequency Settle Time = ',Fipp.FreqSettleTime,' (mS)');
      writeln('Amplitude Settle Time = ',Fipp.AmpSettleTime,' (mS)');
      writeln('Start Delay Time = ',Fipp.MeasureStartTime,' (mS)');
    end;
    if (Fipp.SettleCmdSize >= 4) then
    begin
      if (Fipp.IoStartDelayTime <> INVALID_DATA16) then
        writeln('Io Start Delay Time = ',Fipp.IoStartDelayTime,' (mS)');
      if (Fipp.IoAmpSettleTime <> INVALID_DATA16) then
        writeln('Io Amplitude Settle Time = ',Fipp.IoAmpSettleTime,' (mS)');
    end;
    if Fipp.SettleCmdSize >= 6 then
    begin
      writeln('Burst On Time: ',Fipp.BurstOnTime,' (mS)');
    end;
  pfunerr := 0;
end;

{---------}
procedure dof84; {set measurment settle DELAY}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetSettleTime()) then Exit;
    if Fipp.SettleCmdSize = 1 then
    begin
      writeln('Current Measurement Settle Time = ',Fipp.FreqSettleTime,' (mS)');
    end;
    if (Fipp.SettleCmdSize >= 3) then
    begin
      writeln('Current Frequency Settle Time = ',Fipp.FreqSettleTime,' (mS)');
      writeln('Current Amplitude Settle Time = ',Fipp.AmpSettleTime,' (mS)');
      writeln('Current Start Delay Time = ',Fipp.MeasureStartTime,' (mS)');
    end;
    if (Fipp.SettleCmdSize >= 4) then
    begin
      writeln('Current I/O Settle Time = ',Fipp.IoAmpSettleTime,' (mS)');
      writeln('Current I/O Start Delay Time = ',Fipp.IoStartDelayTime,' (mS)');
    end;
    if (Fipp.SettleCmdSize >= 6) then
    begin
      writeln('Current Burst On Time = ',Fipp.BurstOnTime,' (mS)');
    end;

    if (Fipp.SettleCmdSize <= 1) then
    begin
      write  ('Enter new Measurment Settle Time (mS): ');
      readln(temp);
      Fipp.FreqSettleTime := temp;
      if not(Fipp.SetSettleTime()) then Exit;
      writeln('New Measurment Settle Time = ',Fipp.FreqSettleTime);
    end
    else if (Fipp.SettleCmdSize >= 3) then
    begin
      write  ('Enter new Frequency Settle Time (mS): ');
      readln(temp);
      Fipp.FreqSettleTime := temp;
      write  ('Enter new Amplitude Settle Time (mS): ');
      readln(temp);
      Fipp.AmpSettleTime := temp;
      write  ('Enter new Start Delay Time (mS): ');
      readln(temp);
      Fipp.MeasureStartTime := temp;
      if (Fipp.SettleCmdSize >= 4) then
      begin
        write  ('Enter new I/O Settle Time (mS): ');
        readln(temp);
        Fipp.IoAmpSettleTime := temp;
        write  ('Enter new I/O Start Delay Time (mS): ');
        readln(temp);
        Fipp.IoStartDelayTime := temp;
      end;
      if (Fipp.SettleCmdSize >= 6) then
      begin
        write  ('Enter new Burst On Time (mS): ');
        readln(temp);
        Fipp.BurstOnTime := temp;
      end;
      if not(Fipp.SetSettleTime()) then Exit;
      if Fipp.SettleCmdSize = 1 then
      begin
        writeln('New Measurement Settle Time = ',Fipp.FreqSettleTime,' (mS)');
      end;
      if (Fipp.SettleCmdSize >= 3) then
      begin
        writeln('New Frequency Settle Time = ',Fipp.FreqSettleTime);
        writeln('New Amplitude Settle Time = ',Fipp.AmpSettleTime);
        writeln('New Start Delay Time = ',Fipp.MeasureStartTime);
      end;
      if (Fipp.SettleCmdSize >= 4) then
      begin
        writeln('New I/O Settle Time = ',Fipp.IoAmpSettleTime);
        writeln('New I/O Start Delay Time = ',Fipp.IoStartDelayTime);
      end;
      if (Fipp.SettleCmdSize >= 6) then
      begin
        writeln('New Burst On Time = ',Fipp.BurstOnTime,' (mS)');
      end;
    end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof85; {do measurment}
var tmp:real;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetFrequency()) then Exit;
    if not(Fipp.GetSourceAmp()) then Exit;
    write('Current Frequency = ');
    if Fipp.Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Fipp.Frequency,'Hz');
    writeln('Current source = ',Fipp.SourceAmp div 100,'dB');
    writeln;

    write('Enter new Frequency (Composite = 0) : ');
    readln(temp);
    Fipp.Frequency := temp;
    write('New Frequency = ');
    if Fipp.Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Fipp.Frequency,'Hz');

    write('Enter new Source Amp value (50, 60, etc. 0=off) : ');
    readln(tmp);
    if tmp > 300 then Exit;
    Fipp.SourceAmp := trunc(tmp * 100);
    writeln('New Source Amplitude = ',FS_DbStr100(Fipp.SourceAmp,true));

    write  ('Enter Measurment Settle Time (mS): ');
    readln(temp);
    Fipp.DoMeasureSettleTime := temp;

    if not(Fipp.DoMeasurement()) then Exit;

    writeln('Microphone Input = ',FS_Str3D(Fipp.MeasureMicData),'dB');

  pfunerr := 0;
end;



{-----------------------------------------------}
procedure dof87;      {get CIC state - obsolete - see cmds 172/173}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCICstate()) then Exit;
  writeln('<- Obsolete command - see commands 172 and 173 ->');
  writeln('CIC is ',FS_onoff(Fipp.CICstate));
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof88;   {set CIC state - obsolete - see cmds 172/173}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCICstate()) then Exit;
  writeln('<- Obsolete command - see commands 172 and 173 ->');
  writeln('Current CIC state = ',FS_OnOff(Fipp.CICstate));
  write('Enter new CIC state (0=off 1=on) : ');
  readln(temp);
  Fipp.CICstate := temp;
  if not(Fipp.SetCICstate()) then Exit;
  writeln('New CIC state = ',FS_OnOff(Fipp.CICstate));
  pfunerr := 0;
end;


{---------}
procedure dof90; {set avg DELAY time}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAvgDelayTime()) then Exit;
  writeln('Current Average Start Delay Time = ',Fipp.AvgStartTime,' (mS)');
  writeln('Current Average      Settle Time = ',Fipp.AvgSettleTime,' (mS)');
  writeln;
  write  ('Enter new Average Start Delay Time (mS): ');
  readln(temp);
  Fipp.AvgStartTime := temp;
  write  ('Enter new Average      Settle Time (mS): ');
  readln(temp);
  Fipp.AvgSettleTime := temp;
  if not(Fipp.SetAvgDelayTime()) then Exit;
  writeln;
  writeln('New Average Start Delay Time = ',Fipp.AvgStartTime,' (mS)');
  writeln('New Average      Settle Time = ',Fipp.AvgSettleTime,' (mS)');
  pfunerr := 0;
end;


{---------}
procedure dof91; {get avg delay time}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAvgDelayTime()) then Exit;
  writeln('Average Start Delay Time : ',Fipp.AvgStartTime,' (mS)');
  writeln('Average Settle Time      : ',Fipp.AvgSettleTime,' (mS)');
  pfunerr := 0;
end;



procedure ShowPrinterSelector;
begin
  writeln('Bit0=Int(0)/Ext(1), Bit1=Mono(0)/Color(1), Bit2=HPCL(0)/Epson(1),');
  writeln('Bit3=Uncompressed(0)/Compressed(1)');
end;
procedure ShowPrintSetup;
begin
  writeln('Bit0=Label Off(0)/Label On(1), Bit1=Timestamp Off(0)/Timestamp On(1)');
end;

{---------}
procedure dof92; {set printer type}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetPrinterSelect()) then Exit;
  writeln;
  ShowPrinterSelector();
  writeln('-> Current Printer Type  = ',Fipp.PrinterSelector, ' ($',FS_HexW(Fipp.PrinterSelector),')');
  if (Fipp.PrintInfoCount > 1) then
  begin
    writeln;
    ShowPrintSetup();
    writeln('-> Current Printer Setup = ',Fipp.PrinterSetup, ' ($',FS_HexW(Fipp.PrinterSetup),')');
  end;
  if (Fipp.PrintInfoCount > 2) then
  begin
    writeln;
    writeln('-> Current Print Darkness = ',Fipp.PrintDarkness);
  end;
  writeln;
  write  ('Enter new Printer Type : ');
  readln(temp);
  Fipp.PrinterSelector := temp;
  if Fipp.PrintInfoCount > 1 then
  begin
    write  ('Enter new Printer Setup : ');
    readln(temp);
    Fipp.PrinterSetup := temp;
  end;
  if Fipp.PrintInfoCount > 2 then
  begin
    write  ('Enter new Print Darkness : ');
    readln(temp);
    Fipp.PrintDArkness := temp;
  end;

  if not(Fipp.SetPrinterSelect()) then Exit;
  writeln;
  writeln('-> New Printer Type = ',Fipp.PrinterSelector, ' ($',FS_HexW(Fipp.PrinterSelector),')');
  if Fipp.PrintInfoCount > 1 then
    writeln('-> New Printer Setup = ',Fipp.PrinterSetup, ' ($',FS_HexW(Fipp.PrinterSetup),')');
  if Fipp.PrintInfoCount > 2 then
    writeln('-> New Print Darkness = ',Fipp.PrintDarkness);
  pfunerr := 0;
end;


{---------}
procedure dof93; {get printer Type}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetPrinterSelect()) then Exit;
  writeln;
  ShowPrinterSelector();
  writeln('-> Printer Type : ',Fipp.PrinterSelector);
  if (Fipp.PrintInfoCount > 1) then
  begin
    writeln;
    ShowPrintSetup();
    writeln('-> Printer Setup : ',Fipp.PrinterSetup);
  end;
  if (Fipp.PrintInfoCount > 2) then
  begin
    writeln;
    writeln('-> Print Darkness = ',Fipp.PrintDarkness);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof94; {get HFA measurement}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetHFAMeasurement()) then Exit;
  writeln('HFA: ',FS_Str3D(Fipp.HFAData),'dB');
  pfunerr := 0;
end;

function GetSerialNumberString(S:str255):str255;
begin
  if length(FS_sTrim(S)) = 0 then
    S := '?';
  GetSerialNumberString := S;
end;

function GetCalibrationStatus(CalStatus:integer):str255;
begin
  if CalStatus = 0 then Result := 'Calibrated [0]'
  else Result := 'Error ['+FS_IntToStr(CalStatus)+']';
end;

procedure dof95; {get software info}
var fc:text;
var Result : boolean;
{var Serial:string[80]; }
{var MfgDate : string[80];}
begin
    if (TSUB_OpenPort() = false) then Exit;
  //if first time called, update hw info as well as instruemnt info
  if (Fipp.FonixVersionSize = 0) then
  begin
    Result := SIG_UpdateInstSignature(true); //Collects current information to update signature info
  end
  else
  begin
    Result := Fipp.GetInstrumentInformation();
    if (Result = false) then Exit;
    SIG_UpdateInstSignature(false); //Collects current information to update signature info
  end;

    writeln(' Instrument Base : ',FD_Signature.InstrumentBaseType);
    writeln('Software Version : ',FD_Signature.SoftwareVersion);
    writeln('        Language : ',FD_Signature.Language);
    writeln('  Loader Version : ',FD_Signature.BootVersion);
    writeln('   EErom Version : ',FD_Signature.NvsVersion);
    writeln('   Serial Number : ',GetSerialNumberString(FD_Signature.SerialNumber));
    writeln('    Manufactured : ',FS_GetUnpackedFryeDateToStr(FD_Signature.MfgDate));
    writeln('    Hardware Cal : ',FS_GetUnpackedFryeDateToStr(FD_Signature.HwCalDate));
    writeln('    Software Cal : ',FS_GetUnpackedFryeDateToStr(FD_Signature.SwCalDate));
  if (Fipp.InstrumentInfoSize > 15) then
  begin
    writeln('      Cal Status : ',GetCalibrationStatus(Fipp.InstrumentInfo.CalStatus));
    writeln('   Sw Build Date : ',FS_GetPackedFryeDateToStr(Fipp.InstrumentInfo.SwBuildDate));
    writeln('    Build Number : ',Fipp.InstrumentInfo.SwBuildNumber);
  end;
  if (Fipp.InstrumentInfoSize > 19) then
  begin
    writeln(' Cpu Temperature : ',FS_TemperatureStr(Fipp.InstrumentInfo.CpuTemperature));
    writeln('     Hw Cal Temp : ',FS_TemperatureStr(Fipp.InstrumentInfo.HwCalTemperature));
    writeln('    Sys Cal Temp : ',FS_TemperatureStr(Fipp.InstrumentInfo.SysCalTemperature));
  end;
  if (Fipp.InstrumentInfoSize > 22) then
  begin
    writeln('   Cpu Board Rev : ',Fipp.InstrumentInfo.CpuBoardRevNumber);
  end;

  assign(fc,'SOFTWARE.DAT');
  rewrite(fc);
  writeln(fc,FD_Signature.InstrumentBaseType);
  writeln(fc,FD_Signature.SoftwareVersion);
  writeln(fc,FD_Signature.Language);
  writeln(fc,FD_Signature.BootVersion);
  writeln(fc,FD_Signature.NvsVersion);
  writeln(fc,FD_Signature.SerialNumber);
  writeln(fc,FT_PackCalDate(FD_Signature.MfgDate));
  writeln(fc,FT_PackCalDate(FD_Signature.HwCalDate));
  writeln(fc,FT_PackCalDate(FD_Signature.SwCalDate));
  writeln(fc,Fipp.InstrumentInfo.CalStatus);
  writeln(fc,Fipp.InstrumentInfo.SwBuildDate);
  writeln(fc,Fipp.InstrumentInfo.SwBuildNumber);
  writeln(fc,Fipp.InstrumentInfo.CpuTemperature);
  writeln(fc,Fipp.InstrumentInfo.HwCalTemperature);
  writeln(fc,Fipp.InstrumentInfo.SysCalTemperature);
  writeln(fc,Fipp.InstrumentInfo.CpuBoardRevNumber);
  close(fc);
  pfunerr := 0;
end;


{---------}
procedure dof96; {set printer label bitmap}
var s : str255;
begin
  if (TSUB_OpenPort() = false) then Exit;
  s := 'LABEL.BMP';
  if LU_GetBitmapFile(s) = 0 then
  begin
    LU_ConvertBitmapToSend(Fipp.FryeBitmap);
    if not Fipp.SetBitmap() then Exit;
    writeln('Bitmap: ',S,' sent to printer label');
  end;
  pfunerr := 0;
end;

{---------}
function ARTestTypeStr(Test:integer):str255;
begin
  case Test of
    0 : ARTestTypeStr := '(XAR)';
    1 : ARTestTypeStr := '(VAR)';
    2 : ARTestTypeStr := '(ANSI96)';
  else ARTestTypeStr := '(?)';
  end;
end;

procedure ShowARParams;
begin
  begin
    writeln('  A/R Test Type  : ',Fipp.ARParams[0],ARTestTypeStr(Fipp.ARParams[0]));
    writeln('  A/R Frequency  : ',Fipp.ARParams[1],' (Hz)');
    writeln('  Attack Window  : ',Fipp.ARParams[2]);
    writeln('  Release Window : ',Fipp.ARParams[3]);
  end;
end;

{---------}
procedure dof97; {set A&R Params}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetARparams()) then Exit;
  writeln('Current Attack and Release Parameters:');
  ShowARparams;
  writeln;
  write  ('Enter new Test Type: ');
  readln(temp);
  Fipp.ARParams[0] := temp;
  write  ('Enter new Test Frequency: ');
  readln(temp);
  Fipp.ARParams[1] := temp;
  write  ('Enter new Attack Window:');
  readln(temp);
  Fipp.ARParams[2] := temp;
  write  ('Enter new Release Window:');
  readln(temp);
  Fipp.ARParams[3] := temp;
  if not(Fipp.SetARparams()) then Exit;
  writeln;
  ShowARParams;
  pfunerr := 0;
end;

{---------}
procedure dof98; {get attack and release}
begin
  if not(Fipp.GetARparams()) then Exit;
  ShowARparams;
  pfunerr := 0;
end;

{------}
procedure dof99; {Set BLOB}
var fc:text;
    ii:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  writeln;
  assign(fc,'BLOB.DAT');
  reset(fc);
  Fipp.BlobSize := 0;
  while not(eof(fc)) do
  begin
    Readln(fc,Fipp.BLOB[Fipp.BlobSize]);
    inc(Fipp.BlobSize);
  end;
  close(fc);
  if not(Fipp.SetBlob()) then Exit;
  writeln('Blob has been uploaded to instrument');
  pfunerr := 0;
end;



end.
