
{This is an extension of the TS2unit for the Test and Test32 programs}
{It was added on because TS2unit ran out of code space for 16bit systems}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.18 as of 12 Dec 2004 - med}
{12 Jun 2006 V5.20 -med added new commands and adapted battery commands for 7000}

{$N+,E+}
{$APPTYPE CONSOLE}
Unit TS3unit;
interface
uses graphics,FryeDefs,TestDefs,FippDefs,FryeTools,FcomDefs,FryeStr,ShowData,LabelUnit,FippUnit,
     TS2Unit,TestSubs,Windows,SysUtils;


{command procedures}
procedure dof100; {get device id count}
procedure dof101; {get long device id}
procedure dof102; {get device data}
procedure dof103; {get realtime clock}
procedure dof104; {set realtime clock}
procedure dof105; {get output transducer selection}
procedure dof106; {set output transducer selection}
procedure dof107; {get impulse rejection}
procedure dof108; {set impulse rejection}
procedure dof109; {get signal info}
procedure dof110; {get raw capture data}
procedure dof111; {get mic cal data}
procedure dof112; {set curve selection}
procedure dof113; {get curve selection}
procedure dof114; {set curve status}
procedure dof115; {get curve status }
procedure dof116; {set unaided curve selection}
procedure dof117; {get unaided curve selection}
procedure dof118; {Set List}
procedure dof119; {Get List}
procedure dof120; {Get Bitmap}
procedure dof121; {set curve selection}
procedure dof122; {get static tone selection}
procedure dof123; {set aid type}
procedure dof124; {get aid type selection}
procedure dof125; {set bias tone Params}
procedure dof126; {get bias tone parameters}
{127 = reserved for external control}
{128 = reserved for external control}
procedure dof129; {set warble type}
procedure dof130; {get warble selection}
procedure dof131; {get delay measurements}
procedure dof132; {set Rcv Timeout}
procedure dof133; {get Rcv Timeout}
procedure dof134; {set Fit Rule}
procedure dof135; {get Fit Rule}
procedure dof136; {set Filter}
procedure dof137; {get Filter}
procedure dof138; {set Compression threshold}
procedure dof139; {get Compression threshold}
procedure dof140; {Set ClientAge}
procedure dof141; {get ClientAge}
procedure dof142; {Set Transducer location}
procedure dof143; {get transducer location}
procedure dof144; {Do Cal Adj}
procedure dof145; {Set leveling list}
procedure dof146; {Get leveling list}
procedure dof147; {Set leveling status}
procedure dof148; {Set aux port}
procedure dof149; {Get aux port}
procedure dof150; {Set user Number}
procedure dof151; {Get user Number}

procedure dof152; {Set Fit Type     fp35 V3.20}
procedure dof153; {Get Fit Type     fp35 V3.20}
procedure dof154; {Set Vent Type    fp35 V3.20}
procedure dof155; {Get Vent Type    fp35 V3.20}
procedure dof156; {Set Tubing Type  fp35 v3.20}
procedure dof157; {Get Tubing Type  fp35 V3.20}
procedure dof158; {Set Aid Channels fp35 V3.20}
procedure dof159; {Get Aid Channels fp35 V3.20}
procedure dof160; {Set Aid Limiting fp35 V3.20}
procedure dof161; {Get Aid Limiting fp35 V3.20}

procedure dof162; {Set Ref Method fp35 v3.70}
procedure dof163; {Get Ref Method fp35 v3.70}

procedure dof164; {Set Fit Param    fp35 v3.20}
procedure dof165; {Get Fit Param    fp35 v3.20}

procedure dof166; {Set UserID text}
procedure dof167; {Get UserID text}
procedure dof168; {Set skew}
procedure dof169; {Get skew}
procedure dof170; {Set ScreenMode}
procedure dof171; {Get ScreenMode}
procedure dof172; {Set Coupler}
procedure dof173; {Get Coupler}

procedure dof174; {Set Analysis type}
procedure dof175; {Get Analysis type}
procedure dof176; {do custom test}
procedure dof177; {do Save}
procedure dof178; {Do Target}
procedure dof179; {Get battery information}
procedure dof180; {Set stored parameter}
procedure dof181; {Get stored parameter}
procedure dof182; {Set Curve Group}
procedure dof183; {Get Curve Group}
procedure dof184; {Set Agc Freq Select}
procedure dof185; {Get Agc Freq Select}
procedure dof186; {Set Input Select}
procedure dof187; {Get Input Select}
procedure dof188; {Set Angle}
procedure dof189; {Get Angle}
procedure dof190; {Set Diff Freq}
procedure dof191; {Get Diff Freq}
procedure dof192; {Set User mode}
procedure dof193; {Get User Mode}

{255 = reserved for external control}
{256 = reserved for external control}

implementation


{---------}
procedure dof100; {get device id count}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetLastIdDevice()) then Exit;
  writeln('Number of Devices: ',(Fipp.LastIdDevice+1));
  pfunerr := 0;
end;

{---------}
procedure dof101; {get long device id}
var i : integer;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write  ('Enter Device number read Long ID from: ');
  readln(temp);
  Fipp.DeviceIDNumber := temp;
  if not(Fipp.GetLongDeviceID()) then Exit;
  writeln('Family: $',FS_HexB(Fipp.LongDeviceID.Family));
  write('Serial: $');
    for i := 0 to 5 do
      write(FS_HexB(Fipp.LongDeviceID.Serial[i]));
  writeln;
  writeln('   CRC: $',FS_HexB(Fipp.LongDeviceID.Crc));
  pfunerr := 0;
end;

{---------}
procedure dof102; {get device data}
var i,t:word;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    write  ('Enter Device number to read from: ');
    readln(temp);
    Fipp.DeviceIDNumber := temp;
    write  ('Enter Device selection to read from: ');
    readln(temp);
    Fipp.DeviceSelection := temp;
    if not(Fipp.GetDeviceData()) then Exit;
    for i := 0 to Fipp.DeviceDataSize-1 do
    begin
      write('$',FS_HexW(Fipp.DeviceDataArray[i]),' ');
    end;
    writeln;
  pfunerr := 0;
end;

{---------}
procedure ShowRealTimeClock;
begin
    writeln('Milliseconds:',Fipp.RealTimeClockData.Millisecond);
    writeln('     Seconds:',Fipp.RealTimeClockData.Second);
    writeln('     Minutes:',Fipp.RealTimeClockData.Minute);
    writeln('       Hours:',Fipp.RealTimeClockData.Hour);
    writeln('   DayOfWeek:',Fipp.RealTimeClockData.DayOfWeek); //spare/DayOfWeek);
    writeln('         Day:',Fipp.RealTimeClockData.Day);
    writeln('       Month:',Fipp.RealTimeClockData.Month);
    writeln('        Year:',Fipp.RealTimeClockData.Year);
end;

procedure dof103; {get realtime clock}
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetRealTimeClock()) then Exit;
    ShowRealTimeClock;
    assign(fc,'REALTIME.DAT');
    rewrite(fc);
    writeln(fc,Fipp.RealTimeClockData.Millisecond);
    writeln(fc,Fipp.RealTimeClockData.Second);
    writeln(fc,Fipp.RealTimeClockData.Minute);
    writeln(fc,Fipp.RealTimeClockData.Hour);
    writeln(fc,Fipp.RealTimeClockData.DayOfWeek); //spare/DayOfWeek);
    writeln(fc,Fipp.RealTimeClockData.Day);
    writeln(fc,Fipp.RealTimeClockData.Month);
    writeln(fc,Fipp.RealTimeClockData.Year);
    close(fc);
  pfunerr := 0;
end;

{---------}
procedure dof104; {set realtime clock}
var what:str255;
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
    What := 'REALTIME.DAT';
    if FileExists(what) then
    begin
      assign(fc,What);
      writeln('Loading real time clock data from REALTIME.DAT file');
      reset(fc);
      readln(fc,Fipp.RealTimeClockData.Millisecond);
      readln(fc,Fipp.RealTimeClockData.Second);
      readln(fc,Fipp.RealTimeClockData.Minute);
      readln(fc,Fipp.RealTimeClockData.Hour);
      readln(fc,Fipp.RealTimeClockData.DayOfWeek); //spare/DayOfWeek);
      readln(fc,Fipp.RealTimeClockData.Day);
      readln(fc,Fipp.RealTimeClockData.Month);
      readln(fc,Fipp.RealTimeClockData.Year);
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find REALTIME.DAT file');
      Exit;
    end;
    ShowRealTimeClock;
    if not(Fipp.SetRealTimeClock()) then Exit;
  pfunerr := 0;
end;

function OutputDeviceStr(Device:integer):string;
begin
  case Device of
    0: //NO_DEVICE = 0,   //unknown transducer
      Result := 'Unknown';
    1: //SPEAKER_DEVICE = 1,  //SF spkr (was sf at 45 degrees - which is now obsolete)
      Result := 'Speaker';
    2: //ONE_INSERT_EARPHONE_DEVICE = 2,
      Result := 'One Insert';
    3: //TWO_INSERT_EARPHONE_DEVICE = 3,
      Result := 'Two Insert';
    4: //VIBRATOR_DEVICE = 4, //not currently used
      Result := 'Vibrator';
    5: //TDH39_EARPHONE_DEVICE = 5, //not used to measure, just math
      Result := 'TDH39';
  else
    Result := '?';
  end;
end;

function OutputSelectStr(Select:integer):string;
begin
  result := '($'+FS_HexW(Select)+')';
end;

{---------}
procedure dof105; {get output transducer selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetOutputDevice()) then Exit;
  writeln('Output Selection : ',Fipp.OutputSelect,' ',OutputSelectStr(Fipp.OutputSelect));
  if (Fipp.OutputDeviceSize > 1) then
  begin
    writeln('Output Transducer: ',Fipp.OutputDevice,' - ',OutputDeviceStr(Fipp.OutputDevice));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof106; {set output transducer selection}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetOutputDevice()) then Exit;
  writeln('Current Output Selection : ',Fipp.OutputSelect,' ',OutputSelectStr(Fipp.OutputSelect));
  if (Fipp.OutputDeviceSize > 1) then
  begin
    writeln('Current Output Transducer: ',Fipp.OutputDevice,' - ',OutputDeviceStr(Fipp.OutputDevice));
  end;
  write('Enter new output selection : ');
  readln(temp);
  Fipp.OutputSelect := temp;
  if (Fipp.OutputDeviceSize > 1) then
  begin
    writeln('0=Unknown, 1=Speaker, 2=One Insert, 3=Two Insert, 4=Vibrator, 5=TDH39');
    write('Enter new Transducer selection : ');
    readln(temp);
    Fipp.OutputDevice := temp;
  end;
  if not(Fipp.SetOutputDevice()) then Exit;
  writeln('New Output Selection : ',Fipp.OutputSelect,' ',OutputSelectStr(Fipp.OutputSelect));
  if (Fipp.OutputDeviceSize > 1) then
  begin
    writeln('New Output Transducer: ',Fipp.OutputDevice,' - ',OutputDeviceStr(Fipp.OutputDevice));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof107; {get impulse rejection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetImpulseRej()) then Exit;
  writeln('(107) Current Impulse Rejection = ',FS_DbStr100(Fipp.ImpulseRej,true));
  pfunerr := 0;
end;

{---------}
procedure dof108; {set impulse rejection}
var tmp:single;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetImpulseRej()) then Exit;
  writeln('(107) Current Impulse Rejection = ',Fipp.ImpulseRej div 100,'dB');
  write('Enter new Impulse Rejection value (3, 6, etc. 0=off) : ');
  readln(tmp);
  if tmp > 40 then Exit;
  Fipp.ImpulseRej := trunc(tmp * 100);
  if not(Fipp.SetImpulseRej()) then Exit;
  writeln('(108) New Impulse Rejection = ',FS_DbStr100(Fipp.ImpulseRej,true));
  pfunerr := 0;
end;

{---------}
procedure ShowSignalInfo;
begin
    writeln(' Sample Rate:',Fipp.SignalInfo.SampleRate,' Hz');
    writeln('Capture Size:',Fipp.SignalInfo.CaptureSize,' Samples');
    writeln(' Source Size:',Fipp.SignalInfo.SourceSamples,' Samples');
    writeln('   Ramp Size:',Fipp.SignalInfo.RampSamples,' Samples');
    writeln('Coupler Skew:',Fipp.SignalInfo.CouplerSkew,' Samples');
    writeln('  Probe Skew:',Fipp.SignalInfo.ProbeSkew,' Samples');
    writeln(' Input GainA:',FS_DbStr(Fipp.SignalInfo.GainA,false));
    writeln(' Input GainB:',FS_DbStr(Fipp.SignalInfo.GainB,false));
    writeln('Rms Offset L:',FS_DbStr(Fipp.SignalInfo.RmsOffsetLeft,false));
    writeln('Rms Offset R:',FS_DbStr(Fipp.SignalInfo.RmsOffsetRight,false));
    writeln(' Max Level L:',FS_DbStr(Fipp.SignalInfo.MaxLevelLeft,false));
    writeln(' Max Level R:',FS_DbStr(Fipp.SignalInfo.MaxLevelRight,false));
   if Fipp.SignalInfoSize > 12 then
   begin
    writeln(' Gain IndexA:',Fipp.SignalInfo.GainIndexA);  {13}
    writeln(' Gain IndexB:',Fipp.SignalInfo.GainIndexB); {14}
    writeln('Hw Gain SelA:',Fipp.SignalInfo.HwGainSelectA);  {15}
    writeln('Hw Gain SelB:',Fipp.SignalInfo.HwGainSelectB); {16}
   end;
   if Fipp.SignalInfoSize > 16 then
   begin
    writeln('InputLevelA:',FS_DbStr(Fipp.SignalInfo.InputLevelA,false));  {17}
    writeln('InputLevelB:',FS_DbStr(Fipp.SignalInfo.InputLevelB,false)); {18}
    writeln('  HeadroomA:',FS_DbStr(Fipp.SignalInfo.HeadroomA,false));  {19}
    writeln('  HeadroomB:',FS_DbStr(Fipp.SignalInfo.HeadroomB,false)); {20}
   end;
end;

procedure dof109; {get signal info}
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
    Fipp.SignalInfoSize := 0;
    if not(Fipp.GetSignalInfo()) then Exit;
    //writeln('109');
    ShowSignalInfo;
    assign(fc,'SIGINFO.DAT');
    rewrite(fc);
    writeln(fc,Fipp.SignalInfo.SampleRate);   {1}
    writeln(fc,Fipp.SignalInfo.CaptureSize);  {2}
    writeln(fc,Fipp.SignalInfo.SourceSamples);{3}
    writeln(fc,Fipp.SignalInfo.RampSamples);  {4}
    writeln(fc,Fipp.SignalInfo.CouplerSkew);  {5}
    writeln(fc,Fipp.SignalInfo.ProbeSkew);    {6}
    writeln(fc,Fipp.SignalInfo.GainA);        {7}
    writeln(fc,Fipp.SignalInfo.GainB);        {8}
    writeln(fc,Fipp.SignalInfo.RmsOffsetLeft); {9}
    writeln(fc,Fipp.SignalInfo.RmsOffsetRight);{10}
    writeln(fc,Fipp.SignalInfo.MaxLevelLeft);  {11}
    writeln(fc,Fipp.SignalInfo.MaxLevelRight); {12}
    if Fipp.SignalInfoSize > 12 then
    begin
      writeln(fc,Fipp.SignalInfo.GainIndexA);  {13}
      writeln(fc,Fipp.SignalInfo.GainIndexB); {14}
      writeln(fc,Fipp.SignalInfo.HwGainSelectA);  {15}
      writeln(fc,Fipp.SignalInfo.HwGainSelectB); {16}
    end;
    if Fipp.SignalInfoSize > 16 then
    begin
      writeln(fc,Fipp.SignalInfo.InputLevelA);  {17}
      writeln(fc,Fipp.SignalInfo.InputLevelB); {18}
      writeln(fc,Fipp.SignalInfo.HeadroomA);  {19}
      writeln(fc,Fipp.SignalInfo.HeadroomB); {20}
    end;
    close(fc);
  pfunerr := 0;
end;


{---------}
procedure dof110; {get raw capture data}
var s:str255;
var fc:text;
var i : integer;
var N : longint;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('(110) Enter Data Sample to Get (0-1) : ');
  readln(temp);
  Fipp.RawDataSelection := temp;
  write('Enter Collection Method (0=current, 1=new) : ');
  readln(temp);
  Fipp.RawDataMethod := temp;
  write('Enter Number of Samples to Get (0=default) : ');
  readln(temp);
  Fipp.RawSampleCount := temp;
  if not(Fipp.GetRawSampleData()) then Exit;
  s := 'Sample'+FS_IntStr(Fipp.RawDataSelection)+'.DAT';
 {//   ShowSample(FIPPrec);}
  write('Sample ',Fipp.RawDataSelection,' Saved to: ',S);
  write(' Bits:',Fipp.RawSampleData[3]);
  write(' Trg:',Fipp.RawSampleData[4]);
  write(' Rate:',Fipp.RawSampleData[5]);
  write(' Gain:',FS_Str3D(Fipp.RawSampleData[6]),'dB');
  writeln;
  assign(fc,S);
  rewrite(fc);
  for i := 0 to pred(Fipp.RawSamplePacketSize) do
  begin
    if UseShowInt = true then
      N := smallint(Fipp.RawSampleData[i])
    else N := word(Fipp.RawSampleData[i]);
    if (UseDelimit = true) and (i < pred(Fipp.RawSamplePacketSize)) then
      write(fc,N,',')
    else writeln(fc,N);
  end;
  close(fc);
  pfunerr := 0;
end;

{---------}
procedure dof111;
var s:str255;
var fc:text;
var i : integer;
var N : longint;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter Select Microphone : ');
  readln(temp);
  Fipp.CalMicSelection := temp;
  write('Enter Mic Cal List to read: ');
  readln(temp);
  Fipp.CalListSelection := temp;
  if not(Fipp.GetCalListData()) then Exit;
  writeln('(111) Cal List = ',Fipp.CalListSelection);

  s := 'Mic'+FS_IntStr(Fipp.CalMicSelection)+'CalData'+FS_IntStr(Fipp.CalListSelection)+'.DAT';
  write('Mic:',Fipp.CalMicSelection,' CalList:',Fipp.CalListSelection,' Saved to: ',S);
  writeln;
  assign(fc,S);
  rewrite(fc);
  for i := 0 to pred(Fipp.CalListDataSize) do
  begin
    if UseShowInt = true then
      N := smallint(Fipp.CalListData[i])
    else N := word(Fipp.CalListData[i]);
    if (UseDelimit = true) and (i < pred(Fipp.CalListDataSize)) then
      write(fc,N,',')
    else writeln(fc,N);
  end;
  close(fc);

  pfunerr := 0;
end;

{---------}
procedure dof112; {set curve selection}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCurveSelect()) then Exit;
  Fipp.CurveSelectValid := true;
  writeln('(113) Selected Curve = ',Fipp.CurveSelect);
  write('Enter new Curve selection : ');
  readln(temp);
  Fipp.CurveSelect := temp;
  if not(Fipp.SetCurveSelect()) then Exit;
  writeln('(112) New Curve selection = ',Fipp.CurveSelect);
  pfunerr := 0;
end;

{---------}
procedure dof113; {get curve selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCurveSelect()) then Exit;
  writeln('(113) Curve Selection : ',Fipp.CurveSelect);
  Fipp.CurveSelectValid := true;
  pfunerr := 0;
end;

{---------}
procedure dof114; {set curve status}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter Curve Number: ');
  readln(temp);
  Fipp.CurveSelect := temp;
{//    if not CurveSelectValid then              }
{//    begin                                      }
{//      if not(GetCurveSelect(FIPPrec)) then Exit;}
{//      CurveSelectValid := true;                  }
{//    end;                                          }
  if not(Fipp.GetCurveStatus()) then Exit;
  writeln('(115) Curve Selection = ',Fipp.CurveSelect);
  writeln('      Curve Status    = ',Fipp.CurveStatus);
    write('Enter new Curve Status: ');
  readln(temp);
  Fipp.CurveStatus := temp;
  if not(Fipp.SetCurveStatus()) then Exit;
  writeln('(114) New Curve Status = ',Fipp.CurveStatus);
  pfunerr := 0;
end;

{---------}
procedure dof115; {get curve status }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    write('Enter Curve Number: ');
    readln(temp);
    Fipp.CurveSelect := temp;
{//    if not CurveSelectValid then           }
{//    begin                                   }
{//      if not(GetCurveSelect(FIPPrec)) then Exit;}
{//      CurveSelectValid := true;            }
{//    end;                                    }
    if not(Fipp.GetCurveStatus()) then Exit;
    writeln('(115) Curve Selection = ',Fipp.CurveSelect);
    writeln('      Curve Status = ',Fipp.CurveStatus);
  pfunerr := 0;
end;

{---------}
procedure dof116; {set unaided curve selection}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetUnaidedSelect()) then Exit;
    write('(117) Selected Unaided Curve = ',Fipp.UnaidedSelect);
    if Fipp.UnaidedSelect = 0 then
      writeln(' (Custom)')
    else writeln(' (Average)');
    write('Enter new Unaided Curve Selection (0=Custom, 1=Average) : ');
    readln(temp);
    Fipp.UnaidedSelect := temp;
    if not(Fipp.SetUnaidedSelect()) then Exit;
    write('(116) New Unaided Curve selection = ',Fipp.UnaidedSelect);
    if Fipp.UnaidedSelect = 0 then
      writeln(' (Custom)')
    else writeln(' (Average)');
  pfunerr := 0;
end;

{---------}
procedure dof117; {get unaided curve selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetUnaidedSelect()) then Exit;
  write('(117) Unaided Curve Selection : ',Fipp.UnaidedSelect);
  if Fipp.UnaidedSelect = 0 then
    writeln(' (Custom)')
  else writeln(' (Average)');
  pfunerr := 0;
end;

{---------}
{set List}
procedure dof118;
type tCrv = array[0..MaxCurveSize] of INT16;
type ptCrv = ^tCrv;
var i : integer;
var Size : integer;
var temp:integer;
var What:string[80];
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Writeln('2=User Freq, 3=User Dist, 4=Tone Settle, 5=I/O Settle');
  write('(118) Enter List Number to Send (2-5) : ');
  readln(temp);
  Fipp.ListSelection := temp;
  Size := 0;  //init size to zero
  What := 'List'+FS_IntStr(Fipp.ListSelection)+'.DAT';
  if FileExists(What) then
  begin
    assign(fc,What);
    reset(fc);
    for i := 0 to pred(MaxCurveSize) do
    begin
      readln(fc,Fipp.ListData[i]);
      Size := i;
      if eof(fc) then break;
    end;
    close(fc);
    Fipp.ListDataSize := Size;
    if not(Fipp.SetListData()) then Exit;
  end;
  pfunerr := 0;
end;


function DataListStr(value:integer):str255;
begin
  case Value of
    FIPP_CURRENT_FREQ_LIST: //= 0;  //<not settable>
      Result := 'Cur Freq';
    FIPP_CURRENT_DIST_LIST: //= 1;  //<not settable>
      Result := 'Cur Dist';
    FIPP_USER_FREQ_LIST: //= 2;
      Result := 'User Freq';
    FIPP_USER_DIST_LIST: //= 3;
      Result := 'User Dist';
    FIPP_TONE_SWEEP_SETTLE_LIST: //= 4;
      Result := 'Tone Settle';
    FIPP_IO_SWEEP_SETTLE_LIST: //= 5;
      Result := 'I/O Settle';
    else Result := '('+FS_IntToStr(Value)+')';
  end;
end;


{---------}
{Get List}
procedure dof119;
var Filename:str255;
var fc:text;
var i : integer;
var N : longint;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Writeln('0=Cur Freq, 1=Cur Dist, 2=User Freq, 3=User Dist, 4=Tone Settle, 5=I/O Settle');
  write('(119) Enter List Data to Get (0-5) : ');
  readln(temp);
  Fipp.ListSelection := temp;
  if not(Fipp.GetListData()) then Exit;
  Filename := 'List'+FS_IntStr(Fipp.ListSelection)+'.DAT';
  write('List ',Fipp.ListSelection,' Saved to: ',Filename);
  writeln;
  assign(fc,Filename);
  rewrite(fc);
  for i := 0 to pred(Fipp.ListDataSize) do
  begin
    if UseShowInt = true then
      N := smallint(Fipp.ListData[i])
    else N := word(Fipp.ListData[i]);
    if (UseDelimit = true) and (i < pred(Fipp.ListDataSize)) then
      write(fc,N,',')
    else writeln(fc,N);
  end;
  close(fc);
  pfunerr := 0;
end;


{---------}
{get bitmap}
procedure dof120;
var Page,i,N,w,b,bpp,br: integer;
var xp,yp,yr,yi:integer;
var y,x,xr,Value:integer;
var ImgIndex:integer;
var cnt,style:integer;
var PalIndex : word;
var PixelIndex : integer;
var Filename:str255;
//var fc:text;
var ImgLinesPerChunk,ImgScreenBpp,ImgScanLineSize:integer;
var ImgScreenWidth,ImgScreenHeight,ImgBitMask:integer;
//var TempArray : FC_tCmdArray; //temp storage of image results
label ErrorExit;
const Xstart = 0;
const Ystart = 0;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Writeln('0=Printer Bitmap, 1=Screen');
  write('(120) Enter Bitmap Page to Get (0-1) : ');
  readln(Page);
  {Call with x,y,w,h,style = 0 to get info on the image we want.}
  {returns bytes per scan line in Xpos, Ypos = 0, Width is page width, Height is page height.}
  {returns default style available in Style (2=mono,4=16color,8=256color)}
  {Bitmap.Size = 0 (you have to calc the size yourself),}
  {Bitmap.Offset = required Data offset from the start of the Bitmap record in words (10).}
  {format = GetBitmap(xpos, ypos, width, height, style, page)}
  if not(Fipp.GetBitmap(0,0,0,0,0,Page)) then Exit;
  BitmapTotalSize := (Fipp.FryeBitmap.Height * Fipp.FryeBitmap.Xpos); {size in bytes}
  if (pImage <> NIL) then FreeMem(pImage);
  GetMem(pImage,BitmapTotalSize);
  FippImg.BuildMemoryImageMap(Fipp.FryeBitmap.Width,Fipp.FryeBitmap.Height);

  //copy bitmap info to local control parameters
  ImgScreenBpp := Fipp.FryeBitmap.Style;  //bits per pixel (1 to 8) 1=mono, 4=16 color, 8=256color
  ImgScanLineSize := Fipp.FryeBitmap.Xpos; //bytes per line
  ImgScreenWidth := Fipp.FryeBitmap.Width; //image width in pixels
  ImgScreenHeight := Fipp.FryeBitmap.Height; //image height in pixels
  if (ImgScreenBpp = 2) then
    ImgBitMask := $000f
  else if (ImgScreenBpp = 4) then
    ImgBitMask := $0003
  else if (ImgScreenBpp = 8) then
    ImgBitMask := $0001
  else ImgBitMask := 1;
  if ImgBitMask < 1 then ImgBitMask := $000f;
  if (ImgScanLineSize < 40) then ImgScanLineSize := 40;
  ImgLinesPerChunk := 1000 div (ImgScanLineSize div 2);
  w := ImgScreenWidth; //320;
  b := ImgLinesPerChunk; //240 div 5; //48;
  bpp := 0; //ImgScreenBpp; //for now we only support auto mode

  //get first image block
  //b=screen lines per chunk, bpp = read style (0=auto)
  //yr=current read line, xp=first X pos, yp=Y pos
  xp := 0;
  yp := 0;
  yr := 0;
  ImgIndex := 0;
  if b > ImgScreenHeight then b := ImgScreenHeight;

  while yr < ImgScreenHeight do
  begin
    br := b;
    yr := yp;
    xp := 0;
    //if StopMe = true then break;
    //get image data from instrument
    if not Fipp.GetBitmap(xp,yp,w,b,bpp,Page) then goto ErrorExit;
    PixelIndex := 0; //location of first word in bitmap data
    style := Fipp.FryeBitmap.Style; //get style of color (2=mono, 4=16color, 8=256color)
    cnt := Fipp.FryeBitmap.Size;    //data size in Bitmap Array in words
    if cnt >= FIPP_MAX_FRYE_BITMAP_DATA then goto ErrorExit; //bad img format

    //copy data to the internal Windows memory map image
    for yi := 0 to br-1 do
    begin
      y := yr+yi;
      for x := 0 to w-1 do  //BitMask if the X pos mask for each image word
      begin
        xr := x and ImgBitMask; //$0f;  //mono=0x0f, 16color=0x03, 256color=0x01
        //Value := TempArray.Raw[j];
        Value := Fipp.FryeBitmap.Data[PixelIndex];
        if (Style = 8) then
        begin
          //PalIndex := ((Value shr (xr*8)) and $FF);
          FippImg.MemImage.Canvas.Pixels[Xstart+x,YStart+y] := TColor(Value); //Palette256[PalIndex];
        end
        else if (Style = 4) then
        begin
          //xr := xr xor $01; //flip nibbles to keep 8000 16 color method happy.
          PalIndex := ((Value shr (xr*4)) and $0f);
          FippImg.MemImage.Canvas.Pixels[Xstart+x,YStart+y] := FC_EgaPalette[PalIndex];
        end
        else //default display mode is mono (style=2 or unknown)
        begin
          if ((Value shr xr) and 1) = 0 then
            FippImg.MemImage.Canvas.Pixels[Xstart+x,YStart+y] := clWhite
          else FippImg.MemImage.Canvas.Pixels[Xstart+x,Ystart+y] := clBlack;
        end;
        if xr = ImgBitMask then inc(PixelIndex);
      end;
    end;

    //send request for next block
    if (yp+b) < ImgScreenHeight then
    begin
      yp := yp+b;
      b := ImgLinesPerChunk;
      if (yp+b) > ImgScreenHeight then
        b := ImgScreenHeight - yp;
    end;
    if (yr+br) >= ImgScreenHeight then break;
  end; //endif(ImgScreenHeight)

  Filename := 'Bitmap'+FS_IntStr(Fipp.FryeBitmap.Page)+'.BMP';
  write('Bitmap ',Fipp.FryeBitmap.Page,' Saved to: ',Filename);
  writeln;
  FippImg.MemImage.SaveToFile(FileName);
  pfunerr := 0;

ErrorExit:
  if (pImage <> NIL) then FreeMem(pImage);
  pImage := NIL;
end;

{---------}
procedure dof121; {set static tone selection}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetStaticToneSelect()) then Exit;
  writeln('(122) Current Selected Static Tone = ',Fipp.StaticToneSelect);
  write('Enter New Static Tone Selection : ');
  readln(temp);
  Fipp.StaticToneSelect := temp;
  if not(Fipp.SetStaticToneSelect()) then Exit;
  writeln('(121) New Static Tone Selection = ',Fipp.StaticToneSelect);
  pfunerr := 0;
end;

{---------}
procedure dof122; {get static tone selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetStaticToneSelect()) then Exit;
  writeln('(122) Static Tone Selection : ',Fipp.StaticToneSelect);
  pfunerr := 0;
end;

function AidTypeStr(AidType:integer):str255;
begin
  case AidType of
    FIPP_AID_TYPE_NONE:   {0: NONE - No aid type selected (treat same as ITC) }
      Result := 'NONE';
    FIPP_AID_TYPE_BTE:    {1: BTE - Behind the ear             }
      Result := 'BTE';
    FIPP_AID_TYPE_ITE:    {2: ITE - In the ear                 }
      Result := 'ITE';
    FIPP_AID_TYPE_ITC:    {3: ITC - In the ear canal           }
      Result := 'ITC';
    FIPP_AID_TYPE_CIC:    {4: CIC - Completely in the ear canal}
      Result := 'CIC';
    FIPP_AID_TYPE_UEM:    {5: UEM - BTE with user's earmold  - not used }
      Result := 'UEM';
    else Result := 'unknown';
  end;
end;

function AidGroupStr(AidGroup:integer):str255;
begin
  if AidGroup = 0 then
    Result := 'STANDARD'
  else if AidGroup = 1 then
    Result := 'AGC'
  else if AidGroup = 2 then
    Result := 'ADAPTIVE'
  else Result := '('+FS_IntToStr(AidGroup)+')';
end;

{---------}
procedure dof123; {set aid type}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidInfoSelect()) then Exit;
  writeln('(124) Selected Aid Group = ',Fipp.AidGroupSelect,' (',AidGroupStr(Fipp.AidGroupSelect),')');
  if (Fipp.AidInfoSize > 1) then
  begin
    writeln('Selected Aid Type = ',Fipp.AidTypeSelect,' (',AidTypeStr(Fipp.AidTypeSelect),')');
  end;
  write('Enter New Aid Group Selection : ');
  readln(temp);
  Fipp.AidGroupSelect := temp;
  if (Fipp.AidInfoSize > 1) then
  begin
    write('Enter New Aid Type Selection : ');
    readln(temp);
    Fipp.AidTypeSelect := temp;
  end;
  if not(Fipp.SetAidInfoSelect()) then Exit;
  writeln('(123) New Aid Group Selection = ',Fipp.AidGroupSelect,' (',AidGroupStr(Fipp.AidGroupSelect),')');
  if (Fipp.AidInfoSize > 1) then
  begin
    writeln('Selected Aid Type = ',Fipp.AidTypeSelect,' (',AidTypeStr(Fipp.AidTypeSelect),')');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof124; {get aid type selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidInfoSelect()) then Exit;
  writeln('(124) Selected Aid Group = ',Fipp.AidGroupSelect,' (',AidGroupStr(Fipp.AidGroupSelect),')');
  if (Fipp.AidInfoSize > 1) then
  begin
    writeln('(124) Selected Aid Type = ',Fipp.AidTypeSelect,' (',AidTypeStr(Fipp.AidTypeSelect),')');
  end;
  pfunerr := 0;
end;


{---------}
procedure dof125; {set bias tone Params}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetBiasTone()) then Exit;
    if Fipp.BiasToneSize < 3 then {if one or two items, must be intermode dist freq diff}
    begin
      //This is for compatibility to the incorrect implementation on the FP35 in V6.00 to V6.12
      //see cmd 190/191 for correct implementation (V6.20+)
      writeln('Current Intermod Distortion Frequency Difference:');
       if Fipp.BiasToneSource = INVALID_DATA16 then writeln('Frequency Diff: OFF ($8000)')
       else if Fipp.BiasToneSource = 0 then writeln('Frequency Diff: HARM (0)')
       else writeln('Frequency Diff:',Fipp.BiasToneSource,'Hz');
      if Fipp.BiasToneSize = 2 then
      begin
        writeln('Sweep End Frequency:',Fipp.BiasToneFrequency,'Hz');
      end;
      writeln;
      write  ('Enter new Frequency Difference: ');
      readln(temp);
      Fipp.BiasToneSource := temp;
      Fipp.BiasToneFrequency := INVALID_DATA16;
      Fipp.BiasToneDuration := INVALID_DATA16;
      if Fipp.BiasToneSize = 2 then
      begin
        write('Enter new Sweep End Frequency: ');
        readln(temp);
        Fipp.BiasToneFrequency := temp;
      end;
      if not(Fipp.SetBiasTone()) then Exit;
      writeln;
       writeln('New Frequency Diff:',Fipp.BiasToneSource,'Hz');
       if Fipp.BiasToneSize = 2 then
       begin
         writeln('New Sweep End Frequency:',Fipp.BiasToneFrequency,'Hz');
       end;
    end
    else //must be std composite bias tone
    begin
      writeln('(126) Current Bias Tone Parameters:');
       writeln('   Source:',FS_DbStr(Fipp.BiasToneSource,true));
       writeln('Frequency:',Fipp.BiasToneFrequency,'Hz');
       writeln(' Duration:',Fipp.BiasToneDuration,'mS');
      writeln;
      write('Enter new Bias Tone source dB (50, 60, etc. 0=off) : ');
      readln(temp);
      if temp > 300 then Exit;
      Fipp.BiasToneSource := trunc(temp * 100);
      write  ('Enter new Bias Tone Frequency (Hz): ');
      readln(temp);
      Fipp.BiasToneFrequency := temp;
      write  ('Enter new Bias Tone Duration (mS):');
      readln(temp);
      Fipp.BiasToneDuration := temp;
      if not(Fipp.SetBiasTone()) then Exit;
      writeln('(125) New Bias Tone Parameters:');
       writeln('   Source:',FS_DbStr(Fipp.BiasToneSource,true),'dB');
       writeln('Frequency:',Fipp.BiasToneFrequency,'Hz');
       writeln(' Duration:',Fipp.BiasToneDuration,'mS');
    end;
    pfunerr := 0;
end;
//  writeln('(21) Current source = ',Fipp.SourceAmp div 100,'dB');

{---------}
procedure dof126; {get bias tone parameters}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetBiasTone()) then Exit;
    if Fipp.BiasToneSize < 3 then {if less than 3 items, must be intermode dist freq diff}
    begin
      //This is for compatibility to the incorrect implementation on the FP35 in V6.00 to V6.12
      //see cmd 190/191 for correct implementation (V6.20+)
      writeln('Current Intermod Distortion Frequency Difference:');
       if Fipp.BiasToneSource = INVALID_DATA16 then writeln('Frequency Diff: OFF ($8000)')
       else if Fipp.BiasToneSource = 0 then writeln('Frequency Diff: HARM (0)')
       else writeln('Frequency Diff:',Fipp.BiasToneSource,'Hz');
      if Fipp.BiasToneSize = 2 then
      begin
        writeln('Sweep End Frequency:',Fipp.BiasToneFrequency,'Hz');
      end;
      writeln;
    end
    else
    begin
      writeln('(126) Current Bias Tone Parameters:');
      writeln('   Source:',FS_DbStr(Fipp.BiasToneSource,true));
      writeln('Frequency:',Fipp.BiasToneFrequency,'Hz');
      writeln(' Duration:',Fipp.BiasToneDuration,'mS');
    end;
  pfunerr := 0;
end;

{---------}
function WarbleStr(WarbleSelect:integer):str255;
begin
  if WarbleSelect = 0 then WarbleStr := ' (OFF)'
  else if WarbleSelect = 1 then WarbleStr := ' (AUTO)'
  else if WarbleSelect = 2 then WarbleStr := ' (FAST)'
  else if WarbleSelect = 3 then WarbleStr := ' (SLOW)'
  else WarbleStr := '';
end;

procedure dof129; {set warble type}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetWarbleSelect()) then Exit;
  writeln('(130) Selected Warble = ',Fipp.WarbleSelect,WarbleStr(Fipp.WarbleSelect));
  write('Enter New Warble Selection : ');
  readln(temp);
  Fipp.WarbleSelect := temp;
  if not(Fipp.SetWarbleSelect()) then Exit;
  writeln('(129) New Warble Selection = ',Fipp.WarbleSelect,WarbleStr(Fipp.WarbleSelect));
  pfunerr := 0;
end;

{---------}
procedure dof130; {get warble selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetWarbleSelect()) then Exit;
  writeln('(130) Warble Selection : ',Fipp.WarbleSelect,WarbleStr(Fipp.WarbleSelect));
  if (Fipp.WarbleAmount > 0) then
  writeln('         Warble Amount : ',FS_Str3D(Fipp.WarbleAmount),'%');
  if (Fipp.WarbleRate > 0) then
  writeln('           Warble Rate : ',FS_Str3D(Fipp.WarbleRate),'%');
  pfunerr := 0;
end;


{---------}
procedure dof131; {get delay measurments - enhanced dig spch}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetDelayMeasurments()) then Exit;
    writeln('(131) System Delay      :',Fipp.SystemDelay,'uS');
    if (Fipp.HaDelaySize > 1) then
      writeln('      Hearing Aid Delay : ',Fipp.HearingAidDelay1,'uS');
    if (Fipp.HaDelaySize > 2) then
      writeln('   Hearing Aid Delay #2 : ',Fipp.HearingAidDelay2,'uS');
  pfunerr := 0;
end;

{---------}
procedure dof132; {set Rcv Timeout}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetRcvTimeout()) then Exit;
    writeln('(133) Current Receive Timeout = ',Fipp.RcvTimeout);
    write('Enter new Receive Timeout (mS): ');
    readln(temp);
    Fipp.RcvTimeout := temp;
    if not(Fipp.SetRcvTimeout()) then Exit;
    writeln('(132) New Receive Timeout = ',Fipp.RcvTimeout);
  pfunerr := 0;
end;

{---------}
procedure dof133; {get Rcv Timeout}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRcvTimeout()) then Exit;
  writeln('(133) Receive Timeout : ',Fipp.RcvTimeout);
  pfunerr := 0;
end;

function FitRuleStr(Value:integer):str255;
begin
  case Value of
    FIPP_NALRP_FITTING_RULE:      // (0) NALRP (was NAL-2)
      Result := 'NAL-RP';
    FIPP_POGO_FITTING_RULE:       // (1) POGO
      Result := 'POGO';
    FIPP_BERGER_FITTING_RULE:     // (2) Berger
      Result := 'BERGER';
    FIPP_THIRD_FITTING_RULE:      // (3) 1/3 Gain
      Result := '1/3 GAIN';
    FIPP_HALF_FITTING_RULE:       // (4) 1/2 Gain
      Result := '1/2 GAIN';
    FIPP_TWO_THIRD_FITTING_RULE:  // (5) 2/3 Gain
      Result := '2/3 GAIN';
    FIPP_DSL_LIN_FITTING_RULE:    // (6) DSL LINear fitting rule
      Result := 'DSL LIN';
    FIPP_DSL_WDRC_FITTING_RULE:   // (7) DSL WDRC fitting rule
      Result := 'DSL WDRC';
    FIPP_NALNL1_FITTING_RULE:     // (8) NAL-NL1 fitting rule
      Result := 'NAL-NL1';
    FIPP_MOD_NALNL1_FITTING_RULE: //(9) Modified NAL-NL1 fitting rule
      Result := 'MOD-NL1';
    FIPP_NALNL2_FITTING_RULE:     //(10) NAL-NL2 fitting rule
      Result := 'NAL-NL2';
    //fit rules 11->14 are currently undefined
    FIPP_DIRECT_FITTING_RULE:     // (15) Direct (manual entry)
      Result := 'DIRECT';
    else Result := '';
  end; //end(case)
end;
{---------}
procedure dof134; {set Fit Rule}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFitRule()) then Exit;
  writeln('(135) Current Fit Rule = (',Fipp.FitRule,') ',FitRuleStr(Fipp.FitRule));
  write('Enter new Fit Rule : ');
  readln(temp);
  Fipp.FitRule := temp;
  if not(Fipp.SetFitRule()) then Exit;
  writeln('(134) New Fit Rule = (',Fipp.FitRule,') ',FitRuleStr(Fipp.FitRule));
  pfunerr := 0;
end;

{---------}
procedure dof135; {get Fit Rule}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFitRule()) then Exit;
  writeln('(135) Fit Rule: (',Fipp.FitRule,') ',FitRuleStr(Fipp.FitRule));
  pfunerr := 0;
end;


function FilterStr(value:integer):str255;
begin
  case Value of
    FIPP_AUTO_FILTER:   //0,  //auto-select the filter
      Result := 'AUTO';
    FIPP_FLAT_FILTER:   //1,  //flat unweighted source
      Result := 'FLAT';
    FIPP_ANSI_FILTER:   //2,  //ansi speech filter
      Result := 'ANSI';
    FIPP_ICRA_FILTER:   //3,  //irca speech filter
      Result := 'ICRA';
    FIPP_CLTASS_FILTER: //4,  //UWO Child LTASS filter
      Result := 'CLTASS';
    FIPP_ALTASS_FILTER: //5,  //Cox&Moore Adult LTASS filter
      Result := 'ALTASS';
    FIPP_ANSI92_FILTER: //6,  //Ansi S3.42-1992 filter
      Result := 'ANSI92';
    FIPP_PINK_FILTER:   //7,  //pink noise filter
      Result := 'PINK';
    FIPP_ILTASS_FILTER: //8,  //NAL-NL1 International ltass filter
      Result := 'ILASS';
    else Result := '';
  end;
end;

{---------}
procedure dof136; {set Filter}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFilter()) then Exit;
  writeln('(137) Current Filter = (',Fipp.FilterType,') ',FilterStr(Fipp.FilterType));
  write('Enter new Filter : ');
  readln(temp);
  Fipp.FilterType := temp;
  if not(Fipp.SetFilter()) then Exit;
  writeln('(136) New Filter = (',Fipp.FilterType,') ',FilterStr(Fipp.FilterType));
  pfunerr := 0;
end;

{---------}
procedure dof137; {get Filter}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFilter()) then Exit;
  writeln('(137) Filter: (',Fipp.FilterType,') ',FilterStr(Fipp.FilterType));
  pfunerr := 0;
end;

{---------}
procedure dof138; {set compression value}
var tmp:single;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCompression()) then Exit;
  writeln('(139) Current Compression Threshold = ',Fipp.Compression div 100,'dB');
  write('Enter new Compression Threshold (40, 50, etc. 0=min) : ');
  readln(tmp);
  {if tmp > 40 then Exit;}
  Fipp.Compression := trunc(tmp * 100);
  if not(Fipp.SetCompression()) then Exit;
  writeln('(138) New Compression Threshold = ',FS_DbStr100(Fipp.Compression,true));
  pfunerr := 0;
end;


{---------}
procedure dof139; {get compression value}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCompression()) then Exit;
  writeln('(139) Current Compression Threshold = ',FS_DbStr100(Fipp.Compression,true));
  pfunerr := 0;
end;


{---------}
procedure dof140; {set age}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetClientAge()) then Exit;
  writeln('(141) Current Age = ',Fipp.ClientAge,' Mo');
  write('Enter new Age (12, 24, etc. 0=none) : ');
  readln(temp);
  Fipp.ClientAge := temp;
  if not(Fipp.SetClientAge()) then Exit;
  writeln('(140) New Age = ',Fipp.ClientAge,' Mo');
  pfunerr := 0;
end;


{---------}
procedure dof141; {get ClientAge}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetClientAge()) then Exit;
  writeln('(140) Current Age = ',Fipp.ClientAge,' Mo');
  pfunerr := 0;
end;

{---------}
procedure dof142; {set transducer loc}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTransducerLoc()) then Exit;
  writeln('(143) Current Transducer Location = ',Fipp.TransducerLoc);
  write('Enter Location (0, 45) : ');
  readln(temp);
  Fipp.TransducerLoc := temp;
  if not(Fipp.SetTransducerLoc()) then Exit;
  writeln('(142) New Transducer Location = ',Fipp.TransducerLoc);
  pfunerr := 0;
end;


{---------}
procedure dof143; {get transducer loc}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTransducerLoc()) then Exit;
  writeln('(143) Transducer Location = ',Fipp.TransducerLoc);
  pfunerr := 0;
end;


{---------}
procedure dof144; {Do calibration Adjust}
var temp : single;
var sel : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;

  //if in top cal screen, then we do system cal
  if Fipp.GetMachineState() = false then Exit;
  if (Fipp.MajorMachineState = 32) and (Fipp.MinorMachineState = 0) then
  begin
    write('(144) Enter (0) calibrate system, or (1) to save current calibration : ');
    readln(sel);
    Fipp.CalAdjValue := sel;
    if (Fipp.CalAdjValue = 0) or (Fipp.CalAdjValue = 1) then
    begin
      Fipp.CalAdjCmdSize := 1;
      if not(Fipp.DoCalAdj()) then Exit;
    end;
    pfunerr := 0;
    Exit;
  end;

  //if not in top cal screen, do mic sensitivity correction
  write('(144) Enter Coupler mic (0), or probe mic (1) correction to adjust : ');
  readln(sel);
  Fipp.CalAdjSelect := sel;
  Fipp.CalAdjValue := INT16($8000); //get current value
  Fipp.CalAdjCmdSize := 2;
  if not(Fipp.DoCalAdj()) then Exit;
  writeln('(144) Current Correction Value : ',FS_Str3D(Fipp.CalAdjValue));
  write('Enter Adjustment Amount (in dB) : ');
  readln(temp);
  Fipp.CalAdjValue := trunc(temp * 100);
  if not(Fipp.DoCalAdj()) then Exit; //fails if bad value passed

  Fipp.CalAdjSelect := sel;
  Fipp.CalAdjValue := INT16($8000); //get new value
  Fipp.CalAdjCmdSize := 2;
  if not(Fipp.DoCalAdj()) then Exit;
  writeln('(144) New Correction Value : ',FS_Str3D(Fipp.CalAdjValue));
  pfunerr := 0;
end;



{------}
procedure dof145; {Set leveling list}
var What : str255;
    Src,Dest:array[0..80] of char;
    fc:text;
    ii:word;
    i : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    What := 'LEVELING.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      writeln('Loading Leveling data from LEVELING.DAT file');
      reset(fc);
      for i := 0 to pred(Fipp.LevelingListSize) do
      begin
        readln(fc,Fipp.LevelingList[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find LEVELING.DAT file');
      Exit;
    end;

    if not(Fipp.SetLevelingList()) then Exit;
    ii := 0;
    for i := 0 to pred(Fipp.LevelingListSize) do
    begin
      write(FS_IntStr(Fipp.LevelingList[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;

  pfunerr := 0;
end;

function LevelListStr(Value:integer):string;
begin
  case Value of
  FIPP_LEVELING_ADJ_LIST:  //(0)
    Result := 'Leveling Adjust List';
  FIPP_LEVELING_FREQ_LIST: //(1)
    Result := 'Leveling Frequency List';
  FIPP_SPECTRUM_ADJ_LIST: //(2)
    Result := 'Spectrum Adjust List';
  FIPP_LEVELING_EAR_ADJ_LIST: //(100)
    Result := 'Earphone Adjust List';
  FIPP_LEVELING_EAR_FREQ_LIST: //(101)
    Result := 'Earphone Frequency List';
  FIPP_LEVELING_DSL_EAR_ADJ_LIST: //(102)
    Result := 'Earphone DSL Adjust List';
  FIPP_LEVELING_DSL_EAR_FREQ_LIST: //(103)
    Result := 'Earphone DSL Frequency List';
  FIPP_LEVELING_EAR_DIFF_LIST: //(104)
    Result := 'Earphone Adjust Difference List';
  else
    Result := '('+FS_IntToStr(Value)+')?';
  end;
end;

procedure ShowListselects;
begin
  writeln('Lev Adj(0), Lev Freq(1), Spec Adj(2), Ear Adj(100), Ear Freq(101)');
  writeln('Dsl Adj(102), Dsl Freq(103), Ear Adj Diff(104)');
end;
  //Select: 0=default, 1=left, 2=right, 3=both, -1=failed
{-----------------------------------------------}
procedure dof146;        {get leveling list}
var i,ii : integer;
    N : longint;
    fc:text;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    ShowListSelects();
    write('Enter Leveling List to Get (0-2) : ');
    readln(temp);
    Fipp.WhichLevelingList := temp;
    write('Enter Source Channel (0=Current, 1=Left, 2=Right): ');
    readln(temp);
    Fipp.WhichListChannel := temp;
    if not(Fipp.GetLevelingList()) then Exit;
    writeln(LevelListStr(Fipp.WhichLevelingList),':  Saved to LEVELING.DAT');
    assign(fc,'LEVELING.DAT');
    rewrite(fc);
    for i := 0 to pred(Fipp.LevelingListSize) do
    begin
      if (UseShowInt = true) then
        N := smallint(Fipp.LevelingList[i])
        else N:= word(Fipp.LevelingList[i]);
      if (UseDelimit = true) and (i < pred(Fipp.LevelingListSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  pfunerr := 0;
end;

{---------}
procedure dof147; {set leveling status }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetLevelState()) then Exit;
    writeln('(29) Current Leveling Status = ');
    TSUB_LevelingStatus();
    writeln;

    write('Set new Leveling State (0=Unleveled, 1=Leveled, 2=Save): ');
    readln(temp);
    Fipp.LevelState := temp;
    if not(Fipp.SetLevelingStatus()) then Exit;
    if not(Fipp.GetLevelState()) then Exit;
    writeln;

    writeln('(147) New Leveling State = ');
    TSUB_LevelingStatus();
  pfunerr := 0;
end;


{---------}
procedure dof148; {set aux port}
var tstr:str255;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetAuxPort()) then Exit;
    write('Current Aux Control State = $',FS_HexW(Fipp.AuxCtrl),'   Input:');
    if Fipp.AuxInCount = 0 then write('<none>') else write('$',FS_HexB(BYTE(Fipp.AuxInData[0])));
    writeln;

    write('Enter Start Aux Ctrl State ($nnnn) (-1=none):');
    readln(temp);
    Fipp.AuxStartCtrl := temp;

    write('Enter text to send ("."=none): ');
    readln(tstr);
    if ((tstr[1] = '.') and (length(tstr) = 1)) or (Length(tstr) = 0) then
    begin
      Fipp.AuxOutCount := 0;
    end
    else
    begin
      Fipp.AuxOutCount := ord(tstr[0]);
      move(tstr[1],Fipp.AuxOutData,Fipp.AuxOutCount);
    end;

    write('Enter Stop Aux Ctrl State ($nnnn) (-1=none):');
    readln(temp);
    Fipp.AuxEndCtrl := temp;

    if not(Fipp.SetAuxPort()) then Exit;
    writeln('Done');
  pfunerr := 0;
end;

{---------}
procedure dof149; {get aux port}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAuxPort()) then Exit;
  write('Current Aux Control State = $',FS_HexW(Fipp.AuxCtrl),'   Input:');
  if Fipp.AuxInCount = 0 then write('<none>')
    else SD_ShowBytes(Fipp.AuxInData,Fipp.AuxInCount,2);  {write('$',HexB(BYTE(AuxInData^[0])));}
  writeln;
  pfunerr := 0;
end;


{---------}
procedure dof150; {set User Number }
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetUserNumber()) then Exit;
    writeln('(151) Current User Number = ',Fipp.UserNumber);
    writeln('      Maximum User Number = ',Fipp.MaxUser);
    writeln;
    writeln('Enter new User Number');
    write('0=default, 1=User#1, 2=User#2, etc.): ');
    readln(temp);
    Fipp.UserNumber := temp;
    if not(Fipp.SetUserNumber()) then Exit;
    writeln;
    writeln('(150) New User Number = ',Fipp.UserNumber);
  pfunerr := 0;
end;


{---------}
procedure dof151; {Get User Number }
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetUserNumber()) then Exit;
  writeln('(151) Current User Number (0=default) = ',Fipp.UserNumber);
  writeln('      Maximum User Number = ',Fipp.MaxUser);
  pfunerr := 0;
end;

{---------}
function FitTypeStr(FitType:integer):str255;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if FitType = 0 then FitTypeStr := ' (OFF)'
  else if FitType = 1 then FitTypeStr := ' (UNILATERAL)'
  else if FitType = 2 then FitTypeStr := ' (BILATERAL)'
  else FitTypeStr := '';
end;

procedure dof152;   {set fit type - uni/bi}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetFitType()) then Exit;    {153} {fp35 v3.20 12/01/03}
    writeln('(153) Fit Type : ',Fipp.Fit.AidFitType,FitTypeStr(Fipp.Fit.AidFitType));
    write('Enter Fit Type : (1=Unilateral, 2=Bilateral)');
    readln(temp);
    Fipp.Fit.AidFitType := temp;
    if not(Fipp.SetFitType()) then Exit;    {152} {fp35 v3.20 12/01/03}
    writeln('(152) New Fit Type = ',Fipp.Fit.AidFitType,FitTypeStr(Fipp.Fit.AidFitType));
  pfunerr := 0;
end;

{---------}
procedure dof153;  {get fit type uni/bi}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetFitType()) then Exit;    {153} {fp35 v3.20 12/01/03}
  writeln('(153) Fit Type = ',Fipp.Fit.AidFitType,FitTypeStr(Fipp.Fit.AidFitType));
  pfunerr := 0;
end;

{---------}
function VentTypeStr(VentType:integer):str255;
begin
  case VentType of
    FIPP_FIT_VENT_OPEN:      {0 Vent Open}
      VentTypeStr := ' (Open)';
    FIPP_FIT_VENT_OCCLUDED:  {1 Vent Occluded}
      VentTypeStr := ' (Occluded)';
    FIPP_FIT_VENT_TIGHT:     {2 Vent tight}
      VentTypeStr := ' (Tight)';
    FIPP_FIT_VENT_MM1:       {3 Vent 1mm}
      VentTypeStr := ' (1mm)';
    FIPP_FIT_VENT_MM2:       {4 Vent 2mm}
      VentTypeStr := ' (2mm)';
    FIPP_FIT_VENT_MM3:       {5 Vent 3mm}
      VentTypeStr := ' (3mm)';
    else
      VentTypeStr := '';
  end;
end;

procedure dof154;  {set vent}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetVentType()) then Exit;    {155} {fp35 v3.20 12/01/03}
  writeln;
  writeln('0=Open, 1=Occluded, 2=Tight, 3=1mm, 4=2mm, 5=3mm');
  writeln;
  writeln('(155) Current Vent Type : ',Fipp.Fit.AidVentType,VentTypeStr(Fipp.Fit.AidVentType));
  write('Enter Vent Type : ');
  readln(temp);
  Fipp.Fit.AidVentType := temp;
  if not(Fipp.SetVentType()) then Exit;    {154} {fp35 v3.20 12/01/03}
  writeln;
  writeln('(154) New Vent Type = ',Fipp.Fit.AidVentType,VentTypeStr(Fipp.Fit.AidVentType));
  pfunerr := 0;
end;

{---------}
procedure dof155;  {get vent}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetVentType()) then Exit;    {155} {fp35 v3.20 12/01/03}
  writeln('(155) Vent Type = ',Fipp.Fit.AidVentType,VentTypeStr(Fipp.Fit.AidVentType));
  pfunerr := 0;
end;

{---------}
function TubingTypeStr(TubingType:integer):str255;
begin
  case TubingType of
    FIPP_FIT_TUBING_NONE:    {0 Tubing ( None ) [cic, itc, ite aids] }
      TubingTypeStr := ' (None)';
    FIPP_FIT_TUBING_LIBBY4:  {1 Tubing ( Libby 4 )                   }
      TubingTypeStr := ' (Libby 4)';
    FIPP_FIT_TUBING_LIBBY3:  {2 Tubing ( Libby 3 )                   }
      TubingTypeStr := ' (Libby 3)';
    FIPP_FIT_TUBING_CFA2:    {3 Tubing ( CFA #2 horn )               }
      TubingTypeStr := ' (CFA #2 horn)';
    FIPP_FIT_TUBING_CFA3:    {4 Tubing ( CFA #3 stepped bore )       }
      TubingTypeStr := ' (CFA #3 stepped bore)';
    FIPP_FIT_TUBING_No13:    {5 Tubing ( #13 )                       }
      TubingTypeStr := ' (#13)';
    FIPP_FIT_TUBING_sixC5:   {6 Tubing ( 6C5 )                       }
      TubingTypeStr := ' (6C5)';
    FIPP_FIT_TUBING_sixC10:  {7 Tubing ( 6C10 )                      }
      TubingTypeStr := ' (6C10)';
    else
      TubingTypeStr := '';
  end;
end;

procedure dof156;   {set tubing}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTubingType()) then Exit;    {157} {fp35 v3.20 12/01/03}
  writeln;
  writeln('0=None, 1=Libby4, 2=Libby3, 3=CFA#2, 4=CFA#3, 5=#13, 6=6C5, 7=6C10');
  writeln('(157) Tubing Type : ',Fipp.Fit.AidTubingType,TubingTypeStr(Fipp.Fit.AidTubingType));
  writeln;
  write('Enter Tubing Type : ');
  readln(temp);
  Fipp.Fit.AidTubingType := temp;
  if not(Fipp.SetTubingType()) then Exit;    {156} {fp35 v3.20 12/01/03}
  writeln;
  writeln('(156) New Tubing Type = ',Fipp.Fit.AidTubingType,TubingTypeStr(Fipp.Fit.AidTubingType));
  pfunerr := 0;
end;

{---------}
procedure dof157;  {get tubing}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetTubingType()) then Exit;    {157} {fp35 v3.20 12/01/03}
  writeln('(157) Tubing Type = ',Fipp.Fit.AidTubingType,TubingTypeStr(Fipp.Fit.AidTubingType));
  pfunerr := 0;
end;

{---------}
procedure dof158; {set aid channels}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidChannels()) then Exit;    {159} {fp35 v3.20 12/01/03}
  writeln('Aid Channels : ',Fipp.Fit.AidChannels);
  write('Enter Aid Channels : ');
  readln(temp);
  Fipp.Fit.AidChannels := temp;
  if not(Fipp.SetAidChannels()) then Exit;    {158} {fp35 v3.20 12/01/03}
  writeln('New Aid Channels = ',Fipp.Fit.AidChannels);
  pfunerr := 0;
end;

{---------}
procedure dof159;   {get aid channels}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidChannels()) then Exit;    {159} {fp35 v3.20 12/01/03}
  writeln('Aid Channels = ',Fipp.Fit.AidChannels);
  pfunerr := 0;
end;

{---------}
function AidLimitingStr(Limiting:integer):str255;
begin
  case Limiting of
    0: AidLimitingStr := ' (NONE)';
    1: AidLimitingStr := ' (WIDEBAND)';
    2: AidLimitingStr := ' (MULTICHAN.)';
    else AidLimitingStr := '';
  end;
end;

procedure dof160;  {set aid limiting}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidLimiting()) then Exit;    {161} {fp35 v3.20 12/01/03}
  writeln;
  writeln('0=None, 1=Wideband, 2=Multichannel');
  writeln('(161) Aid Limiting : ',Fipp.Fit.AidLimiting,AidLimitingStr(Fipp.Fit.AidLimiting));
  writeln;
  write('Enter Aid Limiting : ');
  readln(temp);
  Fipp.Fit.AidLimiting := temp;
  if not(Fipp.SetAidLimiting()) then Exit;    {160} {fp35 v3.20 12/01/03}
  writeln;
  writeln('(160) New Aid Limiting = ',Fipp.Fit.AidLimiting,AidLimitingStr(Fipp.Fit.AidLimiting));
  pfunerr := 0;
end;

{---------}
procedure dof161;  {get aid limiting}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAidLimiting()) then Exit;    {161} {fp35 v3.20 12/01/03}
  writeln('(161) Aid Limiting = ',Fipp.Fit.AidLimiting,AidLimitingStr(Fipp.Fit.AidLimiting));
  pfunerr := 0;
end;


{---------}
function RefMethodStr(RefMethod:integer):str255;
begin
  case RefMethod of
    {-1: RefMethodStr := ' (AUTO)';}
    0: RefMethodStr := ' Undisturbed Field';
    1: RefMethodStr := ' Head Surface';
    else RefMethodStr := '?';
  end;
end;

procedure dof162; {set sound field ref method}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRefMethod()) then Exit;    {163} {fp35 v3.70 06/-06/06}
  writeln;
  writeln('(163) Current Ref Method: ',Fipp.Fit.RefMethod,RefMethodStr(Fipp.Fit.RefMethod));
  write('Enter Ref Method (0=Undisturbed, 1=Head Surface) : ');
  readln(temp);
  Fipp.Fit.RefMethod := temp;
  if not(Fipp.SetRefMethod()) then Exit;    {162} {fp35 v3.70 06/06/06}
  writeln;
  writeln('(162) New Ref Method = ',Fipp.Fit.RefMethod,RefMethodStr(Fipp.Fit.RefMethod));
  pfunerr := 0;
end;


procedure dof163;  {get sournd field reference method}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetRefMethod()) then Exit;    {163} {fp35 v3.70 06/06/06}
  writeln('(163) Reference Method = ',Fipp.Fit.RefMethod,RefMethodStr(Fipp.Fit.RefMethod));
  pfunerr := 0;
end;





{---------}
{type FitRecordType = packed record}
{       FitRule:integer;       }
{       ClientAge:integer;     }
{       AidGroup:integer;      }
{       AidType:integer;       }
{       AidCompression:integer;}
{       OutputDevice:integer;  }
{       SpeakerLoc:integer;    }
{       AidChannels:integer;   }
{       AidLimiting:integer;   }
{       AidFitType:integer;    }
{       AidVentType:integer;   }
{       AidTubingType:integer; }
{     end;}
procedure ShowFitParam;
begin
  writeln('Fit Rule    :',Fipp.Fit.FitRule);
  writeln('Client Age  :',Fipp.Fit.ClientAge);
  writeln('Aid Group   :',Fipp.Fit.AidGroup);
  writeln('Aid Type    :',Fipp.Fit.AidType);
  writeln('Aid Compres.:',Fipp.Fit.AidCompression);
  writeln('Output Dev. :',Fipp.Fit.OutputDevice);
  writeln('Speaker Loc.:',Fipp.Fit.SpeakerLoc);
  writeln('Aid Chan.   :',Fipp.Fit.AidChannels);
  writeln('Limiting    :',Fipp.Fit.AidLimiting);
  writeln('Fit Type    :',Fipp.Fit.AidFitType);
  writeln('Vent Type   :',Fipp.Fit.AidVentType);
  writeln('Tubing Type :',Fipp.Fit.AidTubingType);
  if (Fipp.FitCount > 12) then
    writeln('Reference:',Fipp.Fit.RefMethod);
end;

{---------}
procedure dof164; {set fit params}
var what:str255;
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
    What := 'FITPARAM.DAT';
    if FileExists(what) then
    begin
      Fipp.Fit.RefMethod := smallint($0ffff);
      assign(fc,What);
      writeln('Loading Fitting params FITPARAM.DAT file');
      reset(fc);
      readln(fc,Fipp.Fit.FitRule);
      readln(fc,Fipp.Fit.ClientAge);
      readln(fc,Fipp.Fit.AidGroup);
      readln(fc,Fipp.Fit.AidType);
      readln(fc,Fipp.Fit.AidCompression);
      readln(fc,Fipp.Fit.OutputDevice);
      readln(fc,Fipp.Fit.SpeakerLoc);
      readln(fc,Fipp.Fit.AidChannels);
      readln(fc,Fipp.Fit.AidLimiting);
      readln(fc,Fipp.Fit.AidFitType);
      readln(fc,Fipp.Fit.AidVentType);
      readln(fc,Fipp.Fit.AidTubingType);
      if (Fipp.FitCount > 12) then
        readln(fc,Fipp.Fit.RefMethod);
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find FITPARAM.DAT file');
      Exit;
    end;
    ShowFitParam;
    if not(Fipp.SetFitParam()) then Exit;
  pfunerr := 0;
end;

{---------}
procedure dof165;  {get fit params}
var fc:text;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetFitParam()) then Exit;    {162} {fp35 v3.20 12/01/03}
    ShowFitParam;
    assign(fc,'FITPARAM.DAT');
    rewrite(fc);
    writeln(fc,Fipp.Fit.FitRule);
    writeln(fc,Fipp.Fit.ClientAge);
    writeln(fc,Fipp.Fit.AidGroup);
    writeln(fc,Fipp.Fit.AidType);
    writeln(fc,Fipp.Fit.AidCompression);
    writeln(fc,Fipp.Fit.OutputDevice);
    writeln(fc,Fipp.Fit.SpeakerLoc);
    writeln(fc,Fipp.Fit.AidChannels);
    writeln(fc,Fipp.Fit.AidLimiting);
    writeln(fc,Fipp.Fit.AidFitType);
    writeln(fc,Fipp.Fit.AidVentType);
    writeln(fc,Fipp.Fit.AidTubingType);
    if (Fipp.FitCount > 12) then
      writeln(fc,Fipp.Fit.RefMethod);
    close(fc);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof166;    {set User ID text}
var UidText : String;
    i : integer;
    c : char;
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Fipp.UserNumber := 0; {first try to get the default user to see if this command is available}
  if not(Fipp.GetUserIDText()) then Exit;

  writeln;
  write('Enter User ID Text to set (0=Default, 1=User#1, 2=User#2, etc.): ');
  readln(temp);
  if (Temp < 0) or (Temp > 15) then Temp := 0;
  Fipp.UserNumber := temp;
  if not(Fipp.GetUserIDText()) then Exit;
  c := #255;

  if LU_LabelIsBlank(FIPP_MAX_USERID_TEXT,Fipp.UserIDText[Fipp.UserNumber]) = false then
  begin
    SD_ShowLabel(FIPP_MAX_USERID_TEXT,Fipp.UserIDText[Fipp.UserNumber]);
    writeln;
    writeln('Press ESCape to send this User ID,');
    write('Press any other key to enter new text: ');
    c := FT_ConGetKey();
    writeln;
  end
  else
  begin
    writeln('Enter User ID Text');
  end;
  writeln;
  if (c <> #$1b) then
  begin
    LU_EnterUserID(UidText);
    i := 1;
    while i < FIPP_MAX_USERID_TEXT do //MaxUserIDTextSize do
    begin
      Fipp.UserIDText[Fipp.UserNumber][pred(i)] := UidText[i];
      inc(i);
    end;
    Fipp.UserIDText[Fipp.UserNumber][pred(i)] := #0;
  end;
  if not(Fipp.SetUserIDText()) then Exit;
  writeln;
  writeln('* User ID Sent *');
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof167;    {get User ID TEXT }
var temp : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Fipp.UserNumber := 0; {first try to get the default user to see if this command is available}
  if not(Fipp.GetUserIDText()) then Exit;
  write('Enter User ID text to read (0=Default, 1=User#1, 2=User#2, etc.): ');
  readln(temp);
  if (temp > 15) or (Temp < 0) then Temp := 0;
  Fipp.UserNumber := temp;
  if not(Fipp.GetUserIDText()) then Exit;
  writeln('Current User ID Text:');
  writeln;
  SD_ShowLabel(FIPP_MAX_USERID_TEXT,Fipp.UserIDText[Fipp.UserNumber]);
  writeln;
  pfunerr := 0;
end;

{---------}
procedure dof168; {set skew}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    write('Enter which Skew to set (0=Default): ');
    readln(temp);
    if (temp > 15) or (Temp < 0) then Temp := 0;
    Fipp.WhichSkew := temp;
    if not(Fipp.GetSkew()) then Exit;
    writeln('(169) Current Skew = ',Fipp.Skew);
    write('Enter new Skew 0->255 (0=default): ');
    readln(temp);
    Fipp.Skew := temp;
    if not(Fipp.SetSkew()) then Exit;
    writeln('(168) New Skew = ',Fipp.Skew);
  pfunerr := 0;
end;


{---------}
procedure dof169; {Get Skew}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    write('Which Skew to get (0=Default): ');
    readln(temp);
    if (temp > 15) or (Temp < 0) then Temp := 0;
    Fipp.WhichSkew := temp;
    if not(Fipp.GetSkew()) then Exit;
    writeln('(169) Current Skew (0=default) = ',Fipp.Skew);
  pfunerr := 0;
end;


{---------}
procedure dof170; {set screen mode}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetScreenMode()) then Exit;
    writeln('(171) Current Display Mode (0=default) = ',Fipp.LcdMode);
  if (Fipp.vgaOption = true) then
  begin
    writeln('      Current palette (0=default) = ',Fipp.VgaPalette);
  end;
  write('Enter new Display Mode (0=default): ');
  readln(temp);
  Fipp.LcdMode := temp;
  if Fipp.vgaOption = true then
  begin
    write('Enter new palette (0=default): ');
    readln(temp);
    Fipp.VgaPalette := temp;
  end;
  if not(Fipp.SetScreenMode()) then Exit;
    writeln('(170) New Display Mode (0=default) = ',Fipp.LcdMode);
  if (Fipp.vgaOption = true) then
  begin
    writeln('      New palette (0=default) = ',Fipp.VgaPalette);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof171; {Get screen mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetScreenMode()) then Exit;
  writeln('(171) Current Display Mode (0=default) = ',Fipp.LcdMode);
  if (Fipp.vgaoption = true) then
  begin
    writeln('Current palette (0=default) = ',Fipp.VgaPalette);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof172; {set coupler}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCouplerSelection()) then Exit;
  writeln('(173) Current Coupler = ',Fipp.CouplerSelection);
  write('Enter new Coupler Selection (0=None, 1=2cc, 2=oes, 3=cic): ');
  readln(temp);
  Fipp.CouplerSelection := temp;
  if not(Fipp.SetCouplerSelection()) then Exit;
  writeln('(172) New Coupler = ',Fipp.CouplerSelection);
  pfunerr := 0;
end;


{---------}
procedure dof173; {Get coupler}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCouplerSelection()) then Exit;
  writeln('(173) Current Coupler Selection (0=None, 1=2cc, 2=oes, 3=cic): ',Fipp.CouplerSelection);
  pfunerr := 0;
end;


{---------}
procedure dof174; {set analysis}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetAnalysisSelection()) then Exit;
    writeln('(175) Current Analysis = ',Fipp.AnalysisSelection);
    writeln('-1=def, 0=None, 1=TRMS, 2=CRMS, 3=ERMS, 4=DFT, 5=FFT, 6=ERMS5K');
    write('Enter new Analysis Selection :');
    readln(temp);
    Fipp.AnalysisSelection := temp;
    if not(Fipp.SetAnalysisSelection()) then Exit;
    writeln('(174) New Analysis = ',Fipp.AnalysisSelection);
  pfunerr := 0;
end;


{---------}
procedure dof175; {Get analysis}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAnalysisSelection()) then Exit;
  writeln('-1=def, 0=None, 1=TRMS, 2=CRMS, 3=ERMS, 4=DFT, 5=FFT, 6=ERMS5K');
  writeln('(175) Current Analysis Selection: ', Fipp.AnalysisSelection);
  pfunerr := 0;
end;



{-------}
procedure dof176; {do custom test}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.DoCustomTest()) then Exit;
  writeln('Custom Test has been initiated.');
  pfunerr := 0;
end;


{-------}
procedure dof177; {do parameters}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
    writeln('  0=Reset user settings to Factory Defaults');
    writeln('  1=Restore user settings from EEROM');
    writeln('  2=Save current user settings to EEROM');
      write('What to do? : ');
    readln(temp);
    Fipp.ParameterSaveHow := temp;
    if not(Fipp.DoParameterSave()) then Exit;
    if not(Fipp.GetCmdStatus()) then Exit;
    if (Fipp.CmdStatus <> 0) then
    begin
      writeln('Command Failed - Command Result Status = ',Fipp.CmdStatus);
    end
    else
    begin
      Writeln('Command was successful');
    end;
  pfunerr := 0;
end;

{-------}
procedure dof178; {do target}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.DoTarget()) then Exit;
    if not(Fipp.GetCmdStatus()) then Exit;
    if (Fipp.CmdStatus <> 0) then
    begin
      writeln('Command Failed - Command Result Status = ',Fipp.CmdStatus);
    end
    else
    begin
      writeln('Target has been generated.');
    end;
  pfunerr := 0;
end;


{-------}
procedure dof179; {get battery info}
begin
  if (TSUB_OpenPort() = false) then Exit;
    if not(Fipp.GetBatteryInfo()) then Exit;
    if Fipp.BatteryInfoSize = 0 then Exit;
    if Fipp.BatteryInfoSize >= 1 then
      writeln('  Battery Type      = ',Fipp.BatteryType);
    if Fipp.BatteryInfoSize >= 2 then
      writeln('  Battery Size      = ',Fipp.BatterySize);
    if Fipp.BatteryInfoSize >= 3 then
      writeln('  Battery mAH       = ',Fipp.BatteryMAH);
    if Fipp.BatteryInfoSize >= 4 then
      writeln('  Battery Volts     = ',Fipp.BatteryVolt);
    if Fipp.BatteryInfoSize >= 5 then
      writeln('  Battery impedance = ',Fipp.BatteryImp);
    writeln;
  pfunerr := 0;
end;


{---------}
procedure dof180; {set stored parameter}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter Stored Parameter Item Number : ');
  readln(temp);
  if not(Fipp.GetStoredParameter()) then Exit;
  writeln('Current Value of ',Fipp.StoredParameterNumber,' = ',Fipp.StoredParameterValue);
  write('Enter New Value : ');
  readln(temp);
  Fipp.StoredParameterValue := temp;
  if not(Fipp.SetStoredParameter()) then Exit;
  writeln('New Value of ',Fipp.StoredParameterNumber,' = ',Fipp.StoredParameterValue);
  pfunerr := 0;
end;


{---------}
procedure dof181; {Get stored parameter}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  write('Enter Stored Parameter Item Number to Read: ');
  readln(temp);
  writeln('Current Value of ',Fipp.StoredParameterNumber,' = ',Fipp.StoredParameterValue);
  pfunerr := 0;
end;


procedure dof182; {set curve group}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCurveGroupSelect()) then Exit;
  writeln('Current Curve Group Selection = ',Fipp.CurveGroupSelect);
  write('Enter new Curve Group Selection (0=None, 1=Group1, 2=Group2, 3=Group3): ');
  readln(temp);
  Fipp.CurveGroupSelect := temp;
  if not(Fipp.SetCurveGroupSelect()) then Exit;
  writeln('New Curve Group Selection = ',Fipp.CurveGroupSelect);
  pfunerr := 0;
end;

procedure dof183; {get curve group}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetCurveGroupSelect()) then Exit;
  writeln('Current Curve Group Selection (0=None, 1=Group1, 2=Group2, 3=Group3): ',Fipp.CurveGroupSelect);
  pfunerr := 0;
end;

procedure ShowAgcFrequencySelection;
begin
  if (Fipp.AgcFreqSelect = 0) then
    writeln('Current AGC Switching Enable : ',FS_onoff(Fipp.AgcFreqEnable))
  else if (Fipp.AgcFreqSelectSize > 2) then
    writeln('Current AGC Selection Enable : ',Fipp.AgcFreqSelect,'Hz = Index[',Fipp.AgcFreqIndex,'] = ',FS_onoff(Fipp.AgcFreqEnable))
  else writeln('Current AGC Selection Enable : ',Fipp.AgcFreqSelect,'Hz = ',FS_onoff(Fipp.AgcFreqEnable));
end;

procedure dof184; {set AGC parameters}
var Temp:integer;
var Selector:integer;
var CmdSize: integer;
var MaxIndex:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  //First read the frequency select to find out what we have out there
  Fipp.AgcFreqSelect := 0;
  Fipp.AgcFreqEnable := 0;
  if not(Fipp.GetAgcFreqSelect()) then Exit;
  CmdSize := Fipp.AgcFreqSelectSize;
  if (CmdSize = 3) then
  begin
    MaxIndex := Fipp.AgcFreqIndex; //if size=3, then Index is returned as number of indexes available
    writeln('Note: Enter Frequency, or use "0" for AGC Switching control, or');
    writeln('enter "1" to set Freq Enable by index, or "2" to set Frequency by index or');
      write('enter AGC Selection Frequency (eg: 0, 1, 2, 250, 500, 1000, 2000, 4000): ');
  end
  else
  begin
    MaxIndex := 0;
    writeln('Note: Enter Frequency, or use "0" for AGC Switching control.');
    write('Enter AGC Selection Frequency (eg: 0, 250, 500, 1000, 2000, 4000): ');
  end;
  readln(temp);
  Selector := temp;
  if (Selector = 1) or (Selector = 2) then //index access was requested
  begin
    write('Enter location (Index) (0->',MaxIndex,'): ');
    readln(temp);
    Fipp.AgcFreqIndex := temp;
    Fipp.AgcFreqSelect := INVALID_DATA16;
    if (Selector = 2) then
    begin
      write('Enter AGC Selection Frequency (eg: 250, 500, 1000, 2000, 4000): ');
      readln(temp);
      //NewFreq := temp;
      Fipp.AgcFreqSelect := temp;
    end;
  end
  else //do this if just freq was entered
  begin
    Fipp.AgcFreqSelect := Selector;
    Fipp.AgcFreqIndex := INVALID_DATA16;
  end;

  //store a new frequency instead of doing enable
  if (Selector = 2) then
  begin
    if not(Fipp.SetAgcFreqSelect()) then Exit;
    Fipp.AgcFreqSelectSize := 3;
    if not(Fipp.GetAgcFreqSelect()) then Exit;
    ShowAgcFrequencySelection();
    pfunerr := 0;
    Exit;
  end;

  //normal enable setting, do that.
  //first Check if the freq is out there
  if not(Fipp.GetAgcFreqSelect()) then Exit;
  ShowAgcFrequencySelection();
  write('Enter new State (0=OFF, 1=ON): ');
  readln(temp);
  Fipp.AgcFreqEnable := temp;
  Fipp.AgcFreqSelectSize := 2;
  if not(Fipp.SetAgcFreqSelect()) then Exit;
  ShowAgcFrequencySelection();
  pfunerr := 0;
end;

procedure dof185; {get agc parameters}
var Temp:integer;
var MaxIndex : integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  Fipp.AgcFreqSelect := 0;
  Fipp.AgcFreqEnable := 0;
  Fipp.AgcFreqSelectSize := 2;
  if not(Fipp.GetAgcFreqSelect()) then Exit;
  if (Fipp.AgcFreqSelectSize = 3) then
  begin
    MaxIndex := Fipp.AgcFreqIndex;
    writeln('Note: use "0" for AGC Switching control, or "2" to read from Index');
    write('Enter AGC Selection Frequency (eg: 0, 2, 250, 500, 1000, 2000, 4000): ');
    readln(temp);
    if (temp = 2) then
    begin
      write('Enter location (Index) (0->',MaxIndex-1,'): ');
      readln(temp);
      Fipp.AgcFreqSelect := INVALID_DATA16;
      Fipp.AgcFreqIndex := temp;
      end
    else
    begin
      Fipp.AgcFreqSelect := temp;
      Fipp.AgcFreqIndex := INVALID_DATA16;
    end;
    Fipp.AgcFreqSelectSize := 3;
  end
  else
  begin
    writeln('Note: use "0" for AGC Switching control.');
    write('Enter AGC Selection Frequency (eg: 0, 250, 500, 1000, 2000, 4000): ');
    readln(temp);
    Fipp.AgcFreqSelect := temp;
    Fipp.AgcFreqSelectSize := 2;
  end;
  if not(Fipp.GetAgcFreqSelect()) then Exit;
  ShowAgcFrequencySelection();
  pfunerr := 0;
end;


procedure dof186; {Set Input Port Selection}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetInputPortSelect()) then Exit;
  writeln('Current Input Port Selection = ',Fipp.InputPortSelect);
  write('Enter new Input Port Selection (0=Auto, 1=Input1, 2=Input2, -1=Line): ');
  readln(temp);
  Fipp.InputPortSelect := temp;
  if not(Fipp.SetInputPortSelect()) then Exit;
  writeln('New Input Port Selection = ',Fipp.InputPortSelect);
  pfunerr := 0;
end;

procedure dof187; {Get Input Port Selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetInputPortSelect()) then Exit;
  writeln('Current Input Port Selection (0=Auto, 1=Input1, 2=Input2, -1=Line): ',Fipp.InputPortSelect);
  pfunerr := 0;
end;

{------------------------------------------------}
procedure dof188;   {set angle}
var tmp:single;
begin
  if (TSUB_OpenPort() = false) then Exit;
  //if not(Fipp.GetAngleSelect()) then Exit;
  writeln('(189) Current Angle (degrees) = ',FS_Deg64(Fipp.AngleSelect));
  write('Enter new Angle (10, 60.5, etc.) : ');
  readln(tmp);
  if (tmp > 360) or (tmp < 0) then Exit;
  Fipp.AngleSelect := trunc(tmp * 64);
  //if not(Fipp.SetAngleSelect()) then Exit;
  writeln('(0) New Angle = ',FS_Deg64(Fipp.AngleSelect));
  pfunerr := 0;
end;


procedure dof189; {Get Angle Selection}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetAngleSelect()) then Exit;
  writeln('Current Angle Selection (degrees): ',FS_Deg64(Fipp.AngleSelect));
  pfunerr := 0;
end;


procedure dof190; {Set Diff freq}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetDiffFreq()) then Exit;
  writeln('(191) Current Difference Frequency Selection = ',Fipp.DiffFreq,'Hz');
  write('Enter new Difference Frequency (0Hz=Single tone): ');
  readln(temp);
  Fipp.DiffFreq := temp;
  if (Fipp.DiffFreqRspSize > 1) then
  begin
    writeln('(191) Current Sweep End Frequency = ',Fipp.SweepEndFreq,'Hz');
    write('Enter new Difference Frequency : ');
    readln(temp);
    Fipp.SweepEndFreq := temp;
  end;
  if not(Fipp.SetDiffFreq()) then Exit;
  writeln('(191) New Difference Frequency = ',Fipp.DiffFreq);
  if (Fipp.DiffFreqRspSize > 1) then
  begin
    writeln('(191) New Sweep End Frequency = ',Fipp.SweepEndFreq,'Hz');
  end;
  pfunerr := 0;
end;

procedure dof191; {Get Diff freq}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetDiffFreq()) then Exit;
  writeln('(191) Difference Frequency Selection (0Hz=Single Tone): ',Fipp.DiffFreq,'Hz');
  if (Fipp.DiffFreqRspSize > 1) then
  begin
    writeln('Sweep End Frequency = ',Fipp.SweepEndFreq,'Hz');
  end;  
  pfunerr := 0;
end;

function UserModeStr(value:integer):str255;
begin
  if Value = 0 then
    Result := 'NOVICE (0)'
  else if Value = 1 then
    Result := 'EASY (1)'
  else if Value = 2 then
    Result := 'ADVANCED (2)'
  else if Value = 3 then
    Result := 'EXPERT (3)'
  else
    Result := '? ('+FS_IntToStr(Value)+')';
end;

procedure dof192; {Set User Mode}
var Temp:integer;
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetUserMode()) then Exit;
  writeln('(193) Current User Mode : ',UserModeStr(Fipp.UserMode));
  write('Enter new User Mode (0=Novice,1=Easy,2=Advanced,3=Expert): ');
  readln(temp);
  Fipp.UserMode := temp;
  if not(Fipp.SetUserMode()) then Exit;
  writeln('(192) New User Mode : ',UserModeStr(Fipp.UserMode));
  pfunerr := 0;
end;


procedure dof193; {Get User Mode}
begin
  if (TSUB_OpenPort() = false) then Exit;
  if not(Fipp.GetUserMode()) then Exit;
  writeln('(193) Current User Mode : ',UserModeStr(Fipp.UserMode));
  pfunerr := 0;
end;



end.

